/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.UnJoinNodeWayAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class SplitWayAction
extends JosmAction {
    public SplitWayAction() {
        super(I18n.tr("Split Way", new Object[0]), "splitway", I18n.tr("Split a way at the selected node.", new Object[0]), Shortcut.registerShortcut("tools:splitway", I18n.tr("Tool: {0}", I18n.tr("Split Way", new Object[0])), 80, 5003), true);
        this.putValue("help", HelpUtil.ht("/Action/SplitWay"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        List<List<Node>> list;
        Object object;
        if (SegmentToKeepSelectionDialog.DISPLAY_COUNT.get() > 0) {
            new Notification(I18n.tr("Cannot split since another split operation is already in progress", new Object[0])).setIcon(2).show();
            return;
        }
        Collection<OsmPrimitive> collection = this.getLayerManager().getEditDataSet().getSelected();
        List<Node> list2 = OsmPrimitive.getFilteredList(collection, Node.class);
        List<Way> list3 = OsmPrimitive.getFilteredList(collection, Way.class);
        List<Way> list4 = SplitWayAction.getApplicableWays(list3, list2);
        if (list4 == null) {
            new Notification(I18n.tr("The current selection cannot be used for splitting - no node is selected.", new Object[0])).setIcon(2).show();
            return;
        }
        if (list4.isEmpty()) {
            new Notification(I18n.tr("The selected nodes do not share the same way.", new Object[0])).setIcon(2).show();
            return;
        }
        if (list4.size() > 1) {
            object = list4.iterator();
            block0: while (object.hasNext()) {
                list = object.next();
                for (Node object2 : list2) {
                    if (((Way)((Object)list)).isInnerNode(object2)) continue;
                    object.remove();
                    continue block0;
                }
            }
        }
        if (list4.isEmpty()) {
            new Notification(I18n.trn("The selected node is not in the middle of any way.", "The selected nodes are not in the middle of any way.", list2.size(), new Object[0])).setIcon(2).show();
            return;
        }
        if (list4.size() > 1) {
            new Notification(I18n.trn("There is more than one way using the node you selected. Please select the way also.", "There is more than one way using the nodes you selected. Please select the way also.", list2.size(), new Object[0])).setIcon(2).show();
            return;
        }
        object = list4.get(0);
        list = SplitWayAction.buildSplitChunks((Way)object, list2);
        if (list != null) {
            Object object2;
            List<Relation> list5 = OsmPrimitive.getFilteredList(collection, Relation.class);
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(list3.size() + list5.size());
            arrayList.addAll(list3);
            arrayList.addAll(list5);
            List<Way> list6 = SplitWayAction.createNewWaysFromChunks((Way)object, (Iterable<List<Node>>)list);
            Way way = Strategy.keepLongestChunk().determineWayToKeep(list6);
            if (ExpertToggleAction.isExpert() && !((AbstractPrimitive)object).isNew()) {
                object2 = new SegmentToKeepSelectionDialog((Way)object, list6, way, arrayList);
                ((ExtendedDialog)object2).toggleEnable("way.split.segment-selection-dialog");
                if (!((ExtendedDialog)object2).toggleCheckState()) {
                    ((Dialog)object2).setModal(false);
                    ((ExtendedDialog)object2).showDialog();
                    return;
                }
            }
            if (way != null) {
                object2 = SplitWayAction.doSplitWay(this.getLayerManager().getEditLayer(), (Way)object, way, list6, arrayList);
                MainApplication.undoRedo.add(((SplitWayResult)object2).getCommand());
                if (!((SplitWayResult)object2).getNewSelection().isEmpty()) {
                    this.getLayerManager().getEditDataSet().setSelected(((SplitWayResult)object2).getNewSelection());
                }
            }
        }
    }

    static List<Way> getApplicableWays(List<Way> list, List<Node> list2) {
        if (list2.isEmpty()) {
            return null;
        }
        if (list2.size() == 1) {
            Node node = list2.get(0);
            List<Way> list3 = node.getParentWays();
            Way way = null;
            for (Way way2 : list3) {
                if (!list.contains(way2) || !way2.isInnerNode(node)) continue;
                if (way == null) {
                    way = way2;
                    continue;
                }
                way = null;
                break;
            }
            if (way != null) {
                return Collections.singletonList(way);
            }
        }
        return UnJoinNodeWayAction.getApplicableWays(list, list2);
    }

    public static List<List<Node>> buildSplitChunks(Way way, List<Node> list) {
        Object object;
        CheckParameterUtil.ensureParameterNotNull(way, "wayToSplit");
        CheckParameterUtil.ensureParameterNotNull(list, "splitPoints");
        HashSet<Node> hashSet = new HashSet<Node>(list);
        LinkedList<List<Node>> linkedList = new LinkedList<List<Node>>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        linkedList.add(arrayList);
        Iterator<Node> iterator = way.getNodes().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            boolean bl = arrayList.isEmpty() || !iterator.hasNext();
            arrayList.add(object);
            if (!hashSet.contains(object) || bl) continue;
            arrayList = new ArrayList();
            arrayList.add(object);
            linkedList.add(arrayList);
        }
        object = (List)linkedList.get(linkedList.size() - 1);
        if (linkedList.size() >= 2 && ((List)linkedList.get(0)).get(0) == object.get(object.size() - 1) && !hashSet.contains(((List)linkedList.get(0)).get(0))) {
            if (linkedList.size() == 2) {
                new Notification(I18n.tr("You must select two or more nodes to split a circular way.", new Object[0])).setIcon(2).show();
                return null;
            }
            object.remove(object.size() - 1);
            object.addAll((Collection)linkedList.get(0));
            linkedList.remove(linkedList.size() - 1);
            linkedList.set(0, (List<Node>)object);
        }
        if (linkedList.size() < 2) {
            if (((List)linkedList.get(0)).get(0) == ((List)linkedList.get(0)).get(((List)linkedList.get(0)).size() - 1)) {
                new Notification(I18n.tr("You must select two or more nodes to split a circular way.", new Object[0])).setIcon(2).show();
            } else {
                new Notification(I18n.tr("The way cannot be split at the selected nodes. (Hint: Select nodes in the middle of the way.)", new Object[0])).setIcon(2).show();
            }
            return null;
        }
        return linkedList;
    }

    protected static List<Way> createNewWaysFromChunks(Way way, Iterable<List<Node>> iterable) {
        ArrayList<Way> arrayList = new ArrayList<Way>();
        for (List<Node> list : iterable) {
            Way way2 = new Way();
            way2.setKeys(way.getKeys());
            way2.setNodes(list);
            arrayList.add(way2);
        }
        return arrayList;
    }

    public static SplitWayResult splitWay(OsmDataLayer osmDataLayer, Way way, List<List<Node>> list, Collection<? extends OsmPrimitive> collection) {
        return SplitWayAction.splitWay(osmDataLayer, way, list, collection, Strategy.keepLongestChunk());
    }

    public static SplitWayResult splitWay(OsmDataLayer osmDataLayer, Way way, List<List<Node>> list, Collection<? extends OsmPrimitive> collection, Strategy strategy) {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(collection.size() + list.size());
        arrayList.addAll(collection);
        List<Way> list2 = SplitWayAction.createNewWaysFromChunks(way, list);
        Way way2 = strategy.determineWayToKeep(list2);
        return way2 != null ? SplitWayAction.doSplitWay(osmDataLayer, way, way2, list2, arrayList) : null;
    }

    static SplitWayResult doSplitWay(OsmDataLayer osmDataLayer, Way way, Way way2, List<Way> list, List<OsmPrimitive> list2) {
        ArrayList<Command> arrayList = new ArrayList<Command>(list.size());
        Collection<String> collection = Main.pref.getCollection("way.split.roles.nowarn", Arrays.asList("outer", "inner", "forward", "backward", "north", "south", "east", "west"));
        MapFrame mapFrame = MainApplication.getMap();
        boolean bl = mapFrame != null && mapFrame.mapMode == mapFrame.mapModeDraw;
        Way way3 = new Way(way);
        way3.setNodes(way2.getNodes());
        arrayList.add(osmDataLayer != null ? new ChangeCommand(osmDataLayer, (OsmPrimitive)way, (OsmPrimitive)way3) : new ChangeCommand(way.getDataSet(), (OsmPrimitive)way, (OsmPrimitive)way3));
        if (!bl && !list2.contains(way)) {
            list2.add(way);
        }
        int n = list.indexOf(way2);
        list.remove(way2);
        if (!bl) {
            list2.addAll(list);
        }
        for (Way way4 : list) {
            arrayList.add(osmDataLayer != null ? new AddCommand(osmDataLayer, (OsmPrimitive)way4) : new AddCommand(way.getDataSet(), (OsmPrimitive)way4));
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (Relation relation : OsmPrimitive.getFilteredList(way.getReferrers(), Relation.class)) {
            if (!relation.isUsable()) continue;
            Relation relation2 = null;
            String string = Optional.ofNullable(relation.get("type")).orElse("");
            int n2 = 0;
            int n3 = 0;
            List<RelationMember> list3 = relation.getMembers();
            for (RelationMember relationMember : list3) {
                if (relationMember.isWay() && relationMember.getMember() == way) {
                    PrimitiveId primitiveId;
                    Object object;
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object6;
                    boolean bl4 = true;
                    if ("restriction".equals(string) || "destination_sign".equals(string)) {
                        object6 = relationMember.getRole();
                        if ("from".equals(object6) || "to".equals(object6)) {
                            OsmPrimitive osmPrimitive = SplitWayAction.findVia(relation, string);
                            object5 = new ArrayList<Node>();
                            if (osmPrimitive != null) {
                                if (osmPrimitive instanceof Node) {
                                    object5.add((Node)osmPrimitive);
                                } else if (osmPrimitive instanceof Way) {
                                    object5.add(((Way)osmPrimitive).lastNode());
                                    object5.add(((Way)osmPrimitive).firstNode());
                                }
                            }
                            object4 = null;
                            object3 = object5.iterator();
                            while (object3.hasNext()) {
                                Node node = (Node)object3.next();
                                if (!way3.isFirstLastNode(node)) continue;
                                object4 = way;
                            }
                            if (object4 == null) {
                                for (Way way4 : list) {
                                    object = object5.iterator();
                                    while (object.hasNext()) {
                                        primitiveId = (Node)object.next();
                                        if (!way4.isFirstLastNode((Node)primitiveId)) continue;
                                        object4 = way4;
                                    }
                                }
                                if (object4 != null) {
                                    if (relation2 == null) {
                                        relation2 = new Relation(relation);
                                    }
                                    relation2.addMember(new RelationMember((String)object6, (OsmPrimitive)object4));
                                    relation2.removeMembersFor(way);
                                    bl4 = false;
                                }
                            } else {
                                bl4 = false;
                            }
                        } else if (!"via".equals(object6)) {
                            bl3 = true;
                        }
                    } else if (!"route".equals(string) && !"multipolygon".equals(string)) {
                        bl3 = true;
                    }
                    if (relation2 == null) {
                        relation2 = new Relation(relation);
                    }
                    if (bl4) {
                        if (relationMember.hasRole() && !collection.contains(relationMember.getRole())) {
                            bl2 = true;
                        }
                        object6 = null;
                        int n4 = 1;
                        while (n3 - n4 >= 0 || n3 + n4 < list3.size()) {
                            if (n3 - n4 >= 0 && list3.get(n3 - n4).isWay()) {
                                object5 = list3.get(n3 - n4).getWay();
                                if (((Way)object5).lastNode() == way.firstNode() || ((Way)object5).firstNode() == way.firstNode()) {
                                    object6 = Boolean.FALSE;
                                    break;
                                }
                                if (((Way)object5).firstNode() != way.lastNode() && ((Way)object5).lastNode() != way.lastNode()) break;
                                object6 = Boolean.TRUE;
                                break;
                            }
                            if (n3 + n4 < list3.size() && list3.get(n3 + n4).isWay()) {
                                object5 = list3.get(n3 + n4).getWay();
                                if (((Way)object5).lastNode() == way.firstNode() || ((Way)object5).firstNode() == way.firstNode()) {
                                    object6 = Boolean.TRUE;
                                    break;
                                }
                                if (((Way)object5).firstNode() != way.lastNode() && ((Way)object5).lastNode() != way.lastNode()) break;
                                object6 = Boolean.FALSE;
                                break;
                            }
                            ++n4;
                        }
                        int n5 = n2;
                        object4 = list.subList(0, n);
                        object3 = object4.iterator();
                        while (object3.hasNext()) {
                            Way way5 = (Way)object3.next();
                            object = new RelationMember(relationMember.getRole(), way5);
                            ++n5;
                            if (Boolean.TRUE.equals(object6)) {
                                relation2.addMember(n2 + 1, (RelationMember)object);
                                continue;
                            }
                            relation2.addMember(n5 - 1, (RelationMember)object);
                        }
                        object3 = list.subList(n, list.size());
                        Iterator iterator = object3.iterator();
                        while (iterator.hasNext()) {
                            object = (Way)iterator.next();
                            primitiveId = new RelationMember(relationMember.getRole(), (OsmPrimitive)object);
                            ++n5;
                            if (Boolean.TRUE.equals(object6)) {
                                relation2.addMember(n2, (RelationMember)primitiveId);
                                continue;
                            }
                            relation2.addMember(n5, (RelationMember)primitiveId);
                        }
                        n2 = n5;
                    }
                }
                ++n2;
                ++n3;
            }
            if (relation2 == null) continue;
            arrayList.add(osmDataLayer != null ? new ChangeCommand(osmDataLayer, (OsmPrimitive)relation, relation2) : new ChangeCommand(relation.getDataSet(), (OsmPrimitive)relation, relation2));
        }
        if (bl2) {
            new Notification(I18n.tr("A role based relation membership was copied to all new ways.<br>You should verify this and correct it when necessary.", new Object[0])).setIcon(2).show();
        } else if (bl3) {
            new Notification(I18n.tr("A relation membership was copied to all new ways.<br>You should verify this and correct it when necessary.", new Object[0])).setIcon(2).show();
        }
        return new SplitWayResult(new SequenceCommand(I18n.trn("Split way {0} into {1} part", "Split way {0} into {1} parts", list.size() + 1, way.getDisplayName(DefaultNameFormatter.getInstance()), list.size() + 1), arrayList), list2, way, list);
    }

    static OsmPrimitive findVia(Relation relation, String string) {
        for (RelationMember relationMember : relation.getMembers()) {
            if ((!"restriction".equals(string) || !"via".equals(relationMember.getRole())) && (!"destination_sign".equals(string) || !relationMember.hasRole("sign", "intersection"))) continue;
            return relationMember.getMember();
        }
        return null;
    }

    public static SplitWayResult split(OsmDataLayer osmDataLayer, Way way, List<Node> list, Collection<? extends OsmPrimitive> collection) {
        List<List<Node>> list2 = SplitWayAction.buildSplitChunks(way, list);
        return list2 != null ? SplitWayAction.splitWay(osmDataLayer, way, list2, collection) : null;
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        if (collection == null) {
            this.setEnabled(false);
            return;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Node)) continue;
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    @FunctionalInterface
    public static interface Strategy {
        public Way determineWayToKeep(Iterable<Way> var1);

        public static Strategy keepLongestChunk() {
            return iterable -> {
                Way way = null;
                for (Way way2 : iterable) {
                    if (way != null && way2.getNodesCount() <= way.getNodesCount()) continue;
                    way = way2;
                }
                return way;
            };
        }

        public static Strategy keepFirstChunk() {
            return iterable -> (Way)iterable.iterator().next();
        }
    }

    static class SegmentListCellRenderer
    extends DefaultListCellRenderer {
        SegmentListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
            String string = DefaultNameFormatter.getInstance().format((Way)object);
            String string2 = string.replace(I18n.tr(" [id: {0}]", ((Way)object).getId()), "").replace(I18n.tr(" [id: {0}]", ((Way)object).getUniqueId()), "");
            ((JLabel)component).setText(I18n.tr("Segment {0}: {1}", n + 1, string2));
            return component;
        }
    }

    static class SegmentToKeepSelectionDialog
    extends ExtendedDialog {
        static final AtomicInteger DISPLAY_COUNT = new AtomicInteger();
        final transient Way selectedWay;
        final transient List<Way> newWays;
        final JList<Way> list;
        final transient List<OsmPrimitive> selection;
        final transient Way wayToKeep;

        SegmentToKeepSelectionDialog(Way way, List<Way> list, Way way2, List<OsmPrimitive> list2) {
            super(Main.parent, I18n.tr("Which way segment should reuse the history of {0}?", way.getId()), new String[]{I18n.tr("Ok", new Object[0]), I18n.tr("Cancel", new Object[0])}, true);
            this.selectedWay = way;
            this.newWays = list;
            this.selection = list2;
            this.wayToKeep = way2;
            this.list = new JList<Way>(list.toArray(new Way[list.size()]));
            this.configureList();
            this.setButtonIcons("ok", "cancel");
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)new JLabel(this.getTitle()), GBC.eol().fill(2));
            jPanel.add(this.list, GBC.eop().fill(2));
            this.setContent(jPanel);
            this.setDefaultCloseOperation(1);
        }

        private void configureList() {
            this.list.setSelectionMode(0);
            this.list.addListSelectionListener(listSelectionEvent -> {
                Way way = this.list.getSelectedValue();
                if (way != null && MainApplication.isDisplayingMapView() && way.getNodesCount() > 1) {
                    ArrayList<WaySegment> arrayList = new ArrayList<WaySegment>(way.getNodesCount() - 1);
                    Iterator<Node> iterator = way.getNodes().iterator();
                    Node node = iterator.next();
                    while (iterator.hasNext()) {
                        Node node2 = iterator.next();
                        arrayList.add(WaySegment.forNodePair(this.selectedWay, node, node2));
                        node = node2;
                    }
                    this.setHighlightedWaySegments(arrayList);
                }
            });
            this.list.setCellRenderer(new SegmentListCellRenderer());
        }

        protected void setHighlightedWaySegments(Collection<WaySegment> collection) {
            this.selectedWay.getDataSet().setHighlightedWaySegments(collection);
            MainApplication.getMap().mapView.repaint();
        }

        @Override
        public void setVisible(boolean bl) {
            super.setVisible(bl);
            if (bl) {
                DISPLAY_COUNT.incrementAndGet();
                this.list.setSelectedValue(this.wayToKeep, true);
            } else {
                this.setHighlightedWaySegments(Collections.emptyList());
                DISPLAY_COUNT.decrementAndGet();
            }
        }

        @Override
        protected void buttonAction(int n, ActionEvent actionEvent) {
            super.buttonAction(n, actionEvent);
            this.toggleSaveState();
            if (this.getValue() == 1) {
                SplitWayResult splitWayResult = SplitWayAction.doSplitWay(MainApplication.getLayerManager().getEditLayer(), this.selectedWay, this.list.getSelectedValue(), this.newWays, this.selection);
                MainApplication.undoRedo.add(splitWayResult.getCommand());
                if (!splitWayResult.getNewSelection().isEmpty()) {
                    MainApplication.getLayerManager().getEditDataSet().setSelected(splitWayResult.getNewSelection());
                }
            }
        }
    }

    public static class SplitWayResult {
        private final Command command;
        private final List<? extends PrimitiveId> newSelection;
        private final Way originalWay;
        private final List<Way> newWays;

        public SplitWayResult(Command command, List<? extends PrimitiveId> list, Way way, List<Way> list2) {
            this.command = command;
            this.newSelection = list;
            this.originalWay = way;
            this.newWays = list2;
        }

        public Command getCommand() {
            return this.command;
        }

        public List<? extends PrimitiveId> getNewSelection() {
            return this.newSelection;
        }

        public Way getOriginalWay() {
            return this.originalWay;
        }

        public List<Way> getNewWays() {
            return this.newWays;
        }
    }
}

