/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.UpdatePrimitivesTask;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class UpdateSelectionAction
extends JosmAction {
    public static void handlePrimitiveGoneException(long l, OsmPrimitiveType osmPrimitiveType) {
        MultiFetchServerObjectReader multiFetchServerObjectReader = MultiFetchServerObjectReader.create();
        multiFetchServerObjectReader.append(MainApplication.getLayerManager().getEditDataSet(), l, osmPrimitiveType);
        try {
            DataSet dataSet = multiFetchServerObjectReader.parseOsm(NullProgressMonitor.INSTANCE);
            MainApplication.getLayerManager().getEditLayer().mergeFrom(dataSet);
        }
        catch (OsmTransferException osmTransferException) {
            ExceptionDialogUtil.explainException(osmTransferException);
        }
    }

    public static void updatePrimitives(Collection<OsmPrimitive> collection) {
        MainApplication.worker.submit(new UpdatePrimitivesTask(MainApplication.getLayerManager().getEditLayer(), collection));
    }

    public static void updatePrimitive(PrimitiveId primitiveId) {
        CheckParameterUtil.ensureParameterNotNull(primitiveId, "id");
        UpdateSelectionAction.updatePrimitives(Collections.singleton(Optional.ofNullable(Optional.ofNullable(MainApplication.getLayerManager().getEditLayer()).orElseThrow((Supplier<IllegalStateException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePrimitive$0(), ()Ljava/lang/IllegalStateException;)()).data.getPrimitiveById(primitiveId)).orElseThrow(() -> new IllegalStateException(I18n.tr("Did not find an object with id {0} in the current dataset", primitiveId)))));
    }

    public UpdateSelectionAction() {
        super(I18n.tr("Update selection", new Object[0]), "updatedata", I18n.tr("Updates the currently selected objects from the server (re-downloads data)", new Object[0]), Shortcut.registerShortcut("file:updateselection", I18n.tr("File: {0}", I18n.tr("Update selection", new Object[0])), 85, 5008), true, "updateselection", true);
        this.putValue("help", HelpUtil.ht("/Action/UpdateSelection"));
    }

    public UpdateSelectionAction(String string, String string2, String string3, Shortcut shortcut, boolean bl, String string4) {
        super(string, string2, string3, shortcut, bl, string4, true);
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty() && !Main.isOffline(OnlineResource.OSM_API));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> collection = this.getData();
        if (collection.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("There are no selected objects to update.", new Object[0]), I18n.tr("Selection empty", new Object[0]), 1);
            return;
        }
        UpdateSelectionAction.updatePrimitives(collection);
    }

    public Collection<OsmPrimitive> getData() {
        return this.getLayerManager().getEditDataSet().getAllSelected();
    }

    private static /* synthetic */ IllegalStateException lambda$updatePrimitive$0() {
        return new IllegalStateException(I18n.tr("No current dataset found", new Object[0]));
    }
}

