/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.NoteInputDialog;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.util.KeyPressReleaseListener;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class AddNoteAction
extends MapMode
implements KeyPressReleaseListener {
    private final transient NoteData noteData;

    public AddNoteAction(NoteData noteData) {
        super(I18n.tr("Add a new Note", new Object[0]), "addnote", I18n.tr("Add note mode", new Object[0]), ImageProvider.getCursor("crosshair", "create_note"));
        CheckParameterUtil.ensureParameterNotNull(noteData, "data");
        this.noteData = noteData;
    }

    @Override
    public String getModeHelpText() {
        return I18n.tr("Click the location where you wish to create a new note", new Object[0]);
    }

    @Override
    public void enterMode() {
        super.enterMode();
        MapFrame mapFrame = MainApplication.getMap();
        mapFrame.mapView.addMouseListener(this);
        mapFrame.keyDetector.addKeyListener(this);
    }

    @Override
    public void exitMode() {
        super.exitMode();
        MapFrame mapFrame = MainApplication.getMap();
        mapFrame.mapView.removeMouseListener(this);
        mapFrame.keyDetector.removeKeyListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        MapFrame mapFrame = MainApplication.getMap();
        mapFrame.selectMapMode(mapFrame.mapModeSelect);
        NoteInputDialog noteInputDialog = new NoteInputDialog(Main.parent, I18n.tr("Create new note", new Object[0]), I18n.tr("Create note", new Object[0]));
        noteInputDialog.showNoteDialog(I18n.tr("Enter a detailed comment to create a note", new Object[0]), ImageProvider.get("dialogs/notes", "note_new"));
        if (noteInputDialog.getValue() != 1) {
            Logging.debug("User aborted note creation");
            return;
        }
        String string = noteInputDialog.getInputText();
        if (string != null && !string.isEmpty()) {
            LatLon latLon = mapFrame.mapView.getLatLon(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            this.noteData.createNote(latLon, string);
        } else {
            new Notification(I18n.tr("You must enter a comment to create a new note", new Object[0])).setIcon(2).show();
        }
    }

    @Override
    public void doKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            MapFrame mapFrame = MainApplication.getMap();
            mapFrame.selectMapMode(mapFrame.mapModeSelect);
        }
    }

    @Override
    public void doKeyReleased(KeyEvent keyEvent) {
    }
}

