/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command.conflict;

import java.util.Objects;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public abstract class ConflictResolveCommand
extends Command {
    private final ConflictCollection resolvedConflicts = new ConflictCollection();

    public ConflictResolveCommand() {
    }

    public ConflictResolveCommand(OsmDataLayer osmDataLayer) {
        super(osmDataLayer);
    }

    protected void rememberConflict(Conflict<?> conflict) {
        if (!this.resolvedConflicts.hasConflictForMy((OsmPrimitive)conflict.getMy())) {
            this.resolvedConflicts.add(conflict);
        }
    }

    protected void reconstituteConflicts() {
        DataSet dataSet = this.getAffectedDataSet();
        for (Conflict<?> conflict : this.resolvedConflicts) {
            if (dataSet.getConflicts().hasConflictForMy((OsmPrimitive)conflict.getMy())) continue;
            dataSet.getConflicts().add(conflict);
        }
    }

    @Override
    public void undoCommand() {
        super.undoCommand();
        if (MainApplication.isDisplayingMapView()) {
            if (!MainApplication.getLayerManager().containsLayer(this.getLayer())) {
                Logging.warn(I18n.tr("Cannot undo command ''{0}'' because layer ''{1}'' is not present any more", this.toString(), this.getLayer().toString()));
                return;
            }
            MainApplication.getLayerManager().setActiveLayer(this.getLayer());
        }
        this.reconstituteConflicts();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resolvedConflicts);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ConflictResolveCommand conflictResolveCommand = (ConflictResolveCommand)object;
        return Objects.equals(this.resolvedConflicts, conflictResolveCommand.resolvedConflicts);
    }
}

