/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command.conflict;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.command.conflict.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class RelationMemberConflictResolverCommand
extends ConflictResolveCommand {
    private final Conflict<Relation> conflict;
    private final List<RelationMember> mergedMembers;

    public RelationMemberConflictResolverCommand(Conflict<? extends OsmPrimitive> conflict, List<RelationMember> list) {
        this.conflict = conflict;
        this.mergedMembers = list;
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Resolve conflicts in member list of relation {0}", this.conflict.getMy().getId());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "object");
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.conflict.getMy().setMembers(this.mergedMembers);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.conflict.getMy());
    }

    @Override
    public void undoCommand() {
        OsmDataLayer osmDataLayer = this.getLayer();
        if (!MainApplication.getLayerManager().containsLayer(osmDataLayer)) {
            Logging.warn(I18n.tr("Cannot undo command ''{0}'' because layer ''{1}'' is not present any more", this.toString(), osmDataLayer.toString()));
            return;
        }
        MainApplication.getLayerManager().setActiveLayer(osmDataLayer);
        DataSet dataSet = MainApplication.getLayerManager().getEditDataSet();
        super.undoCommand();
        if (!dataSet.getConflicts().hasConflictForMy(this.conflict.getMy())) {
            dataSet.getConflicts().add(this.conflict);
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.conflict, this.mergedMembers);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RelationMemberConflictResolverCommand relationMemberConflictResolverCommand = (RelationMemberConflictResolverCommand)object;
        return Objects.equals(this.conflict, relationMemberConflictResolverCommand.conflict) && Objects.equals(this.mergedMembers, relationMemberConflictResolverCommand.mergedMembers);
    }
}

