/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.preferences.AbstractSetting;
import org.openstreetmap.josm.data.preferences.ListListSetting;
import org.openstreetmap.josm.data.preferences.ListSetting;
import org.openstreetmap.josm.data.preferences.MapListSetting;
import org.openstreetmap.josm.data.preferences.Setting;
import org.openstreetmap.josm.data.preferences.StringSetting;
import org.openstreetmap.josm.gui.io.CustomConfigurator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class PreferencesUtils {
    private PreferencesUtils() {
    }

    public static void replacePreferences(Preferences preferences, Preferences preferences2) {
        for (Map.Entry<String, Setting<?>> entry : preferences.settingsMap.entrySet()) {
            preferences2.putSetting(entry.getKey(), entry.getValue());
        }
    }

    public static void appendPreferences(Preferences preferences, Preferences preferences2) {
        for (Map.Entry<String, Setting<?>> entry : preferences.settingsMap.entrySet()) {
            Collection<Object> collection;
            AbstractSetting abstractSetting;
            String string = entry.getKey();
            if (entry.getValue() instanceof StringSetting) {
                preferences2.putSetting(string, entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof ListSetting) {
                abstractSetting = (ListSetting)entry.getValue();
                collection = PreferencesUtils.getCollection(preferences2, string, true);
                if (collection == null) continue;
                for (Object object : (List)abstractSetting.getValue()) {
                    if (collection.contains(object)) continue;
                    collection.add(object);
                }
                preferences2.putCollection(string, collection);
                continue;
            }
            if (entry.getValue() instanceof ListListSetting) {
                abstractSetting = (ListListSetting)entry.getValue();
                collection = PreferencesUtils.getArray(preferences2, string, true);
                if (collection == null) continue;
                for (Object object : (List)abstractSetting.getValue()) {
                    if (collection.contains(object)) continue;
                    collection.add(object);
                }
                preferences2.putArray(string, collection);
                continue;
            }
            if (!(entry.getValue() instanceof MapListSetting)) continue;
            abstractSetting = (MapListSetting)entry.getValue();
            collection = PreferencesUtils.getListOfStructs(preferences2, string, true);
            if (collection == null) continue;
            for (Object object : (List)abstractSetting.getValue()) {
                if (collection.contains(object)) continue;
                collection.add(object);
            }
            preferences2.putListOfStructs(entry.getKey(), collection);
        }
    }

    public static void deletePreferenceValues(Preferences preferences, Preferences preferences2) {
        for (Map.Entry<String, Setting<?>> entry : preferences.settingsMap.entrySet()) {
            Iterator<Object> iterator;
            Object object2;
            Collection<Object> collection;
            AbstractSetting abstractSetting;
            String string = entry.getKey();
            if (entry.getValue() instanceof StringSetting) {
                abstractSetting = (StringSetting)entry.getValue();
                if (!abstractSetting.equals(preferences2.settingsMap.get(string))) continue;
                preferences2.put(string, null);
                continue;
            }
            if (entry.getValue() instanceof ListSetting) {
                abstractSetting = (ListSetting)entry.getValue();
                collection = PreferencesUtils.getCollection(preferences2, string, true);
                if (collection == null) continue;
                for (Object object2 : (List)abstractSetting.getValue()) {
                    CustomConfigurator.log("Deleting preferences: from list %s: %s\n", string, object2);
                    collection.remove(object2);
                }
                preferences2.putCollection(entry.getKey(), collection);
                continue;
            }
            if (entry.getValue() instanceof ListListSetting) {
                abstractSetting = (ListListSetting)entry.getValue();
                collection = PreferencesUtils.getArray(preferences2, string, true);
                if (collection == null) continue;
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    object2 = (Collection)iterator.next();
                    for (Object object3 : (List)abstractSetting.getValue()) {
                        if (!object2.containsAll((Collection<?>)object3)) continue;
                        CustomConfigurator.log("Deleting preferences: list from lists %s: %s\n", string, object2);
                        iterator.remove();
                    }
                }
                preferences2.putArray(string, collection);
                continue;
            }
            if (!(entry.getValue() instanceof MapListSetting)) continue;
            abstractSetting = (MapListSetting)entry.getValue();
            collection = PreferencesUtils.getListOfStructs(preferences2, string, true);
            if (collection == null) continue;
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                object2 = (Map)iterator.next();
                for (Object object3 : (List)abstractSetting.getValue()) {
                    if (!object2.entrySet().containsAll(object3.entrySet())) continue;
                    CustomConfigurator.log("Deleting preferences: deleting map from maps %s: %s\n", string, object2);
                    iterator.remove();
                }
            }
            preferences2.putListOfStructs(entry.getKey(), collection);
        }
    }

    public static void deletePreferenceKeyByPattern(String string, Preferences preferences) {
        Map<String, Setting<?>> map = preferences.getAllSettings();
        for (Map.Entry<String, Setting<?>> entry : map.entrySet()) {
            String string2 = entry.getKey();
            if (!string2.matches(string)) continue;
            CustomConfigurator.log("Deleting preferences: deleting key from preferences: " + string2);
            preferences.putSetting(string2, null);
        }
    }

    public static void deletePreferenceKey(String string, Preferences preferences) {
        Map<String, Setting<?>> map = preferences.getAllSettings();
        if (map.containsKey(string)) {
            CustomConfigurator.log("Deleting preferences: deleting key from preferences: " + string);
            preferences.putSetting(string, null);
        }
    }

    private static Collection<String> getCollection(Preferences preferences, String string, boolean bl) {
        ListSetting listSetting = Utils.cast(preferences.settingsMap.get(string), ListSetting.class);
        ListSetting listSetting2 = Utils.cast(preferences.defaultsMap.get(string), ListSetting.class);
        if (listSetting == null && listSetting2 == null) {
            if (bl) {
                PreferencesUtils.defaultUnknownWarning(string);
            }
            return null;
        }
        if (listSetting != null) {
            return new ArrayList<String>((Collection)listSetting.getValue());
        }
        return listSetting2.getValue() == null ? null : new ArrayList((Collection)listSetting2.getValue());
    }

    private static Collection<Collection<String>> getArray(Preferences preferences, String string, boolean bl) {
        ListListSetting listListSetting = Utils.cast(preferences.settingsMap.get(string), ListListSetting.class);
        ListListSetting listListSetting2 = Utils.cast(preferences.defaultsMap.get(string), ListListSetting.class);
        if (listListSetting == null && listListSetting2 == null) {
            if (bl) {
                PreferencesUtils.defaultUnknownWarning(string);
            }
            return null;
        }
        if (listListSetting != null) {
            return new ArrayList<Collection<String>>((Collection)listListSetting.getValue());
        }
        return listListSetting2.getValue() == null ? null : new ArrayList((Collection)listListSetting2.getValue());
    }

    private static List<Map<String, String>> getListOfStructs(Preferences preferences, String string, boolean bl) {
        MapListSetting mapListSetting = Utils.cast(preferences.settingsMap.get(string), MapListSetting.class);
        MapListSetting mapListSetting2 = Utils.cast(preferences.settingsMap.get(string), MapListSetting.class);
        if (mapListSetting == null && mapListSetting2 == null) {
            if (bl) {
                PreferencesUtils.defaultUnknownWarning(string);
            }
            return null;
        }
        if (mapListSetting != null) {
            return new ArrayList<Map<String, String>>((Collection)mapListSetting.getValue());
        }
        return mapListSetting2.getValue() == null ? null : new ArrayList((Collection)mapListSetting2.getValue());
    }

    private static void defaultUnknownWarning(String string) {
        CustomConfigurator.log("Warning: Unknown default value of %s , skipped\n", string);
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Settings file asks to append preferences to <b>{0}</b>,<br/> but its default value is unknown at this moment.<br/> Please activate corresponding function manually and retry importing.", string), I18n.tr("Warning", new Object[0]), 2);
    }

    public static void showPrefs(Preferences preferences) {
        Logging.info("properties: " + preferences.settingsMap);
    }

    public static void modifyPreferencesByScript(ScriptEngine scriptEngine, Preferences preferences, String string) throws ScriptException {
        PreferencesUtils.loadPrefsToJS(scriptEngine, preferences, "API.pref", true);
        scriptEngine.eval(string);
        PreferencesUtils.readPrefsFromJS(scriptEngine, preferences, "API.pref");
    }

    public static void readPrefsFromJS(ScriptEngine scriptEngine, Preferences preferences, String string) throws ScriptException {
        String string2 = "stringMap = new java.util.TreeMap ;listMap =  new java.util.TreeMap ;listlistMap = new java.util.TreeMap ;listmapMap =  new java.util.TreeMap ;for (key in " + string + ") {  val = " + string + "[key];  type = typeof val == 'string' ? 'string' : val.type;  if (type == 'string') {    stringMap.put(key, val);  } else if (type == 'list') {    l = new java.util.ArrayList;    for (i=0; i<val.length; i++) {      l.add(java.lang.String.valueOf(val[i]));    }    listMap.put(key, l);  } else if (type == 'listlist') {    l = new java.util.ArrayList;    for (i=0; i<val.length; i++) {      list=val[i];      jlist=new java.util.ArrayList;      for (j=0; j<list.length; j++) {         jlist.add(java.lang.String.valueOf(list[j]));      }      l.add(jlist);    }    listlistMap.put(key, l);  } else if (type == 'listmap') {    l = new java.util.ArrayList;    for (i=0; i<val.length; i++) {      map=val[i];      jmap=new java.util.TreeMap;      for (var key2 in map) {         jmap.put(key2,java.lang.String.valueOf(map[key2]));      }      l.add(jmap);    }    listmapMap.put(key, l);  }  else {   " + CustomConfigurator.class.getName() + ".log('Unknown type:'+val.type+ '- use list, listlist or listmap'); }  }";
        scriptEngine.eval(string2);
        Map map = (Map)scriptEngine.get("stringMap");
        Map map2 = (Map)scriptEngine.get("listMap");
        Map map3 = (Map)scriptEngine.get("listlistMap");
        Map map4 = (Map)scriptEngine.get("listmapMap");
        preferences.settingsMap.clear();
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            hashMap.put(entry.getKey(), new StringSetting((String)entry.getValue()));
        }
        for (Map.Entry entry : map2.entrySet()) {
            hashMap.put(entry.getKey(), new ListSetting((List)entry.getValue()));
        }
        for (Map.Entry entry : map3.entrySet()) {
            List list = (List)entry.getValue();
            hashMap.put(entry.getKey(), new ListListSetting(list));
        }
        for (Map.Entry entry : map4.entrySet()) {
            hashMap.put(entry.getKey(), new MapListSetting((List)entry.getValue()));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            if (((Setting)entry.getValue()).equals(preferences.defaultsMap.get(entry.getKey()))) continue;
            preferences.settingsMap.put((String)entry.getKey(), (Setting<?>)entry.getValue());
        }
    }

    public static void loadPrefsToJS(ScriptEngine scriptEngine, Preferences preferences, String string, boolean bl) throws ScriptException {
        Setting<?> setting;
        TreeMap treeMap = new TreeMap();
        TreeMap treeMap2 = new TreeMap();
        TreeMap treeMap3 = new TreeMap();
        TreeMap treeMap4 = new TreeMap();
        if (bl) {
            for (Map.Entry<String, Setting<?>> entry2 : preferences.defaultsMap.entrySet()) {
                setting = entry2.getValue();
                if (setting instanceof StringSetting) {
                    treeMap.put(entry2.getKey(), ((StringSetting)setting).getValue());
                    continue;
                }
                if (setting instanceof ListSetting) {
                    treeMap2.put(entry2.getKey(), ((ListSetting)setting).getValue());
                    continue;
                }
                if (setting instanceof ListListSetting) {
                    treeMap3.put(entry2.getKey(), ((ListListSetting)setting).getValue());
                    continue;
                }
                if (!(setting instanceof MapListSetting)) continue;
                treeMap4.put(entry2.getKey(), ((MapListSetting)setting).getValue());
            }
        }
        preferences.settingsMap.entrySet().removeIf(entry -> ((Setting)entry.getValue()).getValue() == null);
        for (Map.Entry<String, Setting<?>> entry2 : preferences.settingsMap.entrySet()) {
            setting = entry2.getValue();
            if (setting instanceof StringSetting) {
                treeMap.put(entry2.getKey(), ((StringSetting)setting).getValue());
                continue;
            }
            if (setting instanceof ListSetting) {
                treeMap2.put(entry2.getKey(), ((ListSetting)setting).getValue());
                continue;
            }
            if (setting instanceof ListListSetting) {
                treeMap3.put(entry2.getKey(), ((ListListSetting)setting).getValue());
                continue;
            }
            if (!(setting instanceof MapListSetting)) continue;
            treeMap4.put(entry2.getKey(), ((MapListSetting)setting).getValue());
        }
        scriptEngine.put("stringMap", treeMap);
        scriptEngine.put("listMap", treeMap2);
        scriptEngine.put("listlistMap", treeMap3);
        scriptEngine.put("listmapMap", treeMap4);
        String string2 = "function getJSList( javaList ) { var jsList; var i;  if (javaList == null) return null;jsList = [];  for (i = 0; i < javaList.size(); i++) {    jsList.push(String(list.get(i)));  }return jsList;}function getJSMap( javaMap ) { var jsMap; var it; var e;  if (javaMap == null) return null; jsMap = {}; for (it = javaMap.entrySet().iterator(); it.hasNext();) {    e = it.next();    jsMap[ String(e.getKey()) ] = String(e.getValue());   }  return jsMap;}for (it = stringMap.entrySet().iterator(); it.hasNext();) {  e = it.next();" + string + "[String(e.getKey())] = String(e.getValue());}\nfor (it = listMap.entrySet().iterator(); it.hasNext();) {  e = it.next();  list = e.getValue();  jslist = getJSList(list);  jslist.type = 'list';" + string + "[String(e.getKey())] = jslist;}\nfor (it = listlistMap.entrySet().iterator(); it.hasNext(); ) {  e = it.next();  listlist = e.getValue();  jslistlist = [];  for (it2 = listlist.iterator(); it2.hasNext(); ) {    list = it2.next();     jslistlist.push(getJSList(list));    }  jslistlist.type = 'listlist';" + string + "[String(e.getKey())] = jslistlist;}\nfor (it = listmapMap.entrySet().iterator(); it.hasNext();) {  e = it.next();  listmap = e.getValue();  jslistmap = [];  for (it2 = listmap.iterator(); it2.hasNext();) {    map = it2.next();    jslistmap.push(getJSMap(map));    }  jslistmap.type = 'listmap';" + string + "[String(e.getKey())] = jslistmap;}\n";
        scriptEngine.eval(string2);
    }
}

