/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.imagery.ImageryReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class ImageryLayerInfo {
    public static final ImageryLayerInfo instance = new ImageryLayerInfo();
    private final List<ImageryInfo> layers = new ArrayList<ImageryInfo>();
    private final Map<String, ImageryInfo> layerIds = new HashMap<String, ImageryInfo>();
    private static final List<ImageryInfo> defaultLayers = new ArrayList<ImageryInfo>();
    private static final List<ImageryInfo> allDefaultLayers = new ArrayList<ImageryInfo>();
    private static final Map<String, ImageryInfo> defaultLayerIds = new HashMap<String, ImageryInfo>();
    private static final String[] DEFAULT_LAYER_SITES = new String[]{Main.getJOSMWebsite() + "/maps"};

    public static Collection<String> getImageryLayersSites() {
        return Main.pref.getCollection("imagery.layers.sites", Arrays.asList(DEFAULT_LAYER_SITES));
    }

    private ImageryLayerInfo() {
    }

    public ImageryLayerInfo(ImageryLayerInfo imageryLayerInfo) {
        this.layers.addAll(imageryLayerInfo.layers);
    }

    public void clear() {
        this.layers.clear();
        this.layerIds.clear();
    }

    public void load(boolean bl) {
        this.clear();
        List<ImageryInfo.ImageryPreferenceEntry> list = Main.pref.getListOfStructs("imagery.entries", null, ImageryInfo.ImageryPreferenceEntry.class);
        if (list != null) {
            for (ImageryInfo.ImageryPreferenceEntry imageryPreferenceEntry : list) {
                try {
                    ImageryInfo imageryInfo = new ImageryInfo(imageryPreferenceEntry);
                    this.add(imageryInfo);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logging.warn("Unable to load imagery preference entry:" + illegalArgumentException);
                }
            }
            Collections.sort(this.layers);
        }
        this.loadDefaults(false, null, bl);
    }

    public void loadDefaults(boolean bl, ExecutorService executorService, boolean bl2) {
        DefaultEntryLoader defaultEntryLoader = new DefaultEntryLoader(bl, bl2);
        if (executorService == null) {
            defaultEntryLoader.realRun();
            defaultEntryLoader.finish();
        } else {
            executorService.execute(defaultEntryLoader);
        }
    }

    private static void buildIdMap(List<ImageryInfo> list, Map<String, ImageryInfo> map) {
        map.clear();
        HashSet<String> hashSet = new HashSet<String>();
        for (ImageryInfo object : list) {
            if (object.getId() == null) continue;
            if (map.containsKey(object.getId())) {
                hashSet.add(object.getId());
                Logging.error("Id ''{0}'' is not unique - used by ''{1}'' and ''{2}''!", object.getId(), object.getName(), map.get(object.getId()).getName());
                continue;
            }
            map.put(object.getId(), object);
        }
        for (String string : hashSet) {
            map.remove(string);
        }
    }

    public void updateEntriesFromDefaults(boolean bl) {
        boolean bl2 = false;
        TreeSet<String> treeSet = new TreeSet<String>(Main.pref.getCollection("imagery.layers.default"));
        TreeSet<String> treeSet2 = new TreeSet<String>();
        for (ImageryInfo imageryInfo3 : defaultLayers) {
            if (!imageryInfo3.isDefaultEntry()) continue;
            boolean bl3 = false;
            for (String string : treeSet) {
                if (string.equals(imageryInfo3.getId())) {
                    bl3 = true;
                    treeSet2.add(string);
                    treeSet.remove(string);
                    break;
                }
                if (!ImageryLayerInfo.isSimilar(string, imageryInfo3.getUrl())) continue;
                bl3 = true;
                if (imageryInfo3.getId() != null) {
                    treeSet2.add(imageryInfo3.getId());
                }
                treeSet.remove(string);
                break;
            }
            boolean bl4 = false;
            if (!bl3) {
                if (imageryInfo3.getId() != null) {
                    treeSet2.add(imageryInfo3.getId());
                    for (ImageryInfo imageryInfo : this.layers) {
                        if (!ImageryLayerInfo.isSimilar(imageryInfo3, imageryInfo)) continue;
                        bl4 = true;
                        break;
                    }
                } else {
                    Logging.error("Default imagery ''{0}'' has no id. Skipping.", imageryInfo3.getName());
                }
            }
            if (bl3 || bl4) continue;
            this.add(new ImageryInfo(imageryInfo3));
            bl2 = true;
        }
        if (!bl && !treeSet.isEmpty()) {
            treeSet2.addAll(treeSet);
        }
        Main.pref.putCollection("imagery.layers.default", treeSet2);
        for (int i = 0; i < this.layers.size(); ++i) {
            ImageryInfo imageryInfo;
            ImageryInfo imageryInfo3;
            imageryInfo3 = this.layers.get(i);
            if (imageryInfo3.getId() == null || (imageryInfo = defaultLayerIds.get(imageryInfo3.getId())) == null || imageryInfo.equalsPref(imageryInfo3)) continue;
            this.layers.set(i, imageryInfo);
            Logging.info(I18n.tr("Update imagery ''{0}''", imageryInfo3.getName()));
            bl2 = true;
        }
        if (bl2) {
            this.save();
        }
    }

    public void dropOldEntries() {
        ArrayList arrayList = new ArrayList();
        for (Map.Entry<String, ImageryInfo> entry : this.layerIds.entrySet()) {
            if (defaultLayerIds.containsKey(entry.getKey())) continue;
            this.remove(entry.getValue());
            arrayList.add(entry.getKey());
            Logging.info(I18n.tr("Drop old imagery ''{0}''", ((ImageryInfo)entry.getValue()).getName()));
        }
        if (!arrayList.isEmpty()) {
            for (Map.Entry<String, ImageryInfo> entry : arrayList) {
                this.layerIds.remove(entry);
            }
            this.save();
        }
    }

    private static boolean isSimilar(ImageryInfo imageryInfo, ImageryInfo imageryInfo2) {
        if (imageryInfo == null) {
            return false;
        }
        if (!imageryInfo.getImageryType().equals((Object)imageryInfo2.getImageryType())) {
            return false;
        }
        if (imageryInfo.getId() != null && imageryInfo2.getId() != null) {
            return imageryInfo.getId().equals(imageryInfo2.getId());
        }
        return ImageryLayerInfo.isSimilar(imageryInfo.getUrl(), imageryInfo2.getUrl());
    }

    private static boolean isSimilar(String string, String string2) {
        return Objects.equals(string, string2) || string != null && string2 != null && !string.isEmpty() && !string2.isEmpty() && (string.contains(string2) || string2.contains(string));
    }

    public void add(ImageryInfo imageryInfo) {
        this.layers.add(imageryInfo);
    }

    public void remove(ImageryInfo imageryInfo) {
        this.layers.remove(imageryInfo);
    }

    public void save() {
        ArrayList<ImageryInfo.ImageryPreferenceEntry> arrayList = new ArrayList<ImageryInfo.ImageryPreferenceEntry>();
        for (ImageryInfo imageryInfo : this.layers) {
            arrayList.add(new ImageryInfo.ImageryPreferenceEntry(imageryInfo));
        }
        Main.pref.putListOfStructs("imagery.entries", arrayList, ImageryInfo.ImageryPreferenceEntry.class);
    }

    public List<ImageryInfo> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public List<ImageryInfo> getDefaultLayers() {
        return Collections.unmodifiableList(defaultLayers);
    }

    public List<ImageryInfo> getAllDefaultLayers() {
        return Collections.unmodifiableList(allDefaultLayers);
    }

    public static void addLayer(ImageryInfo imageryInfo) {
        instance.add(imageryInfo);
        instance.save();
    }

    public static void addLayers(Collection<ImageryInfo> collection) {
        for (ImageryInfo imageryInfo : collection) {
            instance.add(imageryInfo);
        }
        instance.save();
        Collections.sort(ImageryLayerInfo.instance.layers);
    }

    public String getUniqueId(ImageryInfo imageryInfo) {
        if (imageryInfo.getId() != null && this.layerIds.get(imageryInfo.getId()) == imageryInfo) {
            return imageryInfo.getId();
        }
        return null;
    }

    class DefaultEntryLoader
    extends PleaseWaitRunnable {
        private final boolean clearCache;
        private final boolean fastFail;
        private final List<ImageryInfo> newLayers;
        private ImageryReader reader;
        private boolean canceled;
        private boolean loadError;

        DefaultEntryLoader(boolean bl, boolean bl2) {
            super(I18n.tr("Update default entries", new Object[0]));
            this.newLayers = new ArrayList<ImageryInfo>();
            this.clearCache = bl;
            this.fastFail = bl2;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
            Utils.close(this.reader);
        }

        @Override
        protected void realRun() {
            for (String string : ImageryLayerInfo.getImageryLayersSites()) {
                if (this.canceled) {
                    return;
                }
                this.loadSource(string);
            }
        }

        protected void loadSource(String string) {
            boolean bl = true;
            try {
                OnlineResource.JOSM_WEBSITE.checkOfflineAccess(string, Main.getJOSMWebsite());
            }
            catch (OfflineAccessException offlineAccessException) {
                Logging.log(Logging.LEVEL_WARN, offlineAccessException);
                bl = false;
            }
            if (this.clearCache && bl) {
                CachedFile.cleanup(string);
            }
            try {
                this.reader = new ImageryReader(string);
                this.reader.setFastFail(this.fastFail);
                List<ImageryInfo> list = this.reader.parse();
                this.newLayers.addAll(list);
            }
            catch (IOException iOException) {
                this.loadError = true;
                Logging.log(Logging.LEVEL_ERROR, iOException);
            }
            catch (SAXException sAXException) {
                this.loadError = true;
                Logging.error(sAXException);
            }
        }

        @Override
        protected void finish() {
            defaultLayers.clear();
            allDefaultLayers.clear();
            defaultLayers.addAll(this.newLayers);
            for (ImageryInfo imageryInfo : this.newLayers) {
                allDefaultLayers.add(imageryInfo);
                for (ImageryInfo imageryInfo2 : imageryInfo.getMirrors()) {
                    allDefaultLayers.add(imageryInfo2);
                }
            }
            defaultLayerIds.clear();
            Collections.sort(defaultLayers);
            Collections.sort(allDefaultLayers);
            ImageryLayerInfo.buildIdMap(allDefaultLayers, defaultLayerIds);
            ImageryLayerInfo.this.updateEntriesFromDefaults(!this.loadError);
            ImageryLayerInfo.buildIdMap(ImageryLayerInfo.this.layers, ImageryLayerInfo.this.layerIds);
            if (!this.loadError && !defaultLayerIds.isEmpty()) {
                ImageryLayerInfo.this.dropOldEntries();
            }
        }
    }
}

