/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.FilterMatcher;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public final class FilterWorker {
    private FilterWorker() {
    }

    public static boolean executeFilters(Collection<OsmPrimitive> collection, Filter ... filterArray) throws SearchParseError {
        return FilterWorker.executeFilters(collection, FilterMatcher.of(filterArray));
    }

    public static boolean executeFilters(Collection<OsmPrimitive> collection, FilterMatcher filterMatcher) {
        boolean bl = FilterWorker.doExecuteFilters(SubclassFilteredCollection.filter(collection, Relation.class::isInstance), filterMatcher);
        bl |= FilterWorker.doExecuteFilters(SubclassFilteredCollection.filter(collection, Way.class::isInstance), filterMatcher);
        return bl |= FilterWorker.doExecuteFilters(SubclassFilteredCollection.filter(collection, Node.class::isInstance), filterMatcher);
    }

    private static boolean doExecuteFilters(Collection<OsmPrimitive> collection, FilterMatcher filterMatcher) {
        boolean bl = false;
        for (OsmPrimitive osmPrimitive : collection) {
            FilterMatcher.FilterType filterType = filterMatcher.isHidden(osmPrimitive);
            if (filterType != FilterMatcher.FilterType.NOT_FILTERED) {
                bl |= osmPrimitive.setDisabledState(true);
                osmPrimitive.setHiddenType(filterType == FilterMatcher.FilterType.EXPLICIT);
                continue;
            }
            FilterMatcher.FilterType filterType2 = filterMatcher.isDisabled(osmPrimitive);
            if (filterType2 != FilterMatcher.FilterType.NOT_FILTERED) {
                bl |= osmPrimitive.setDisabledState(false);
                osmPrimitive.setDisabledType(filterType2 == FilterMatcher.FilterType.EXPLICIT);
                continue;
            }
            bl |= osmPrimitive.unsetDisabledState();
        }
        return bl;
    }

    public static boolean executeFilters(OsmPrimitive osmPrimitive, FilterMatcher filterMatcher) {
        return FilterWorker.doExecuteFilters(Collections.singleton(osmPrimitive), filterMatcher);
    }

    public static boolean clearFilterFlags(Collection<OsmPrimitive> collection) {
        boolean bl = false;
        for (OsmPrimitive osmPrimitive : collection) {
            bl |= osmPrimitive.unsetDisabledState();
        }
        return bl;
    }
}

