/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodePair;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Pair;

public class NodeGraph {
    private final Set<NodePair> edges;
    private int numUndirectedEges;
    private final Map<Node, List<NodePair>> successors = new LinkedHashMap<Node, List<NodePair>>();
    private final Map<Node, List<NodePair>> predecessors = new LinkedHashMap<Node, List<NodePair>>();

    public static List<NodePair> buildNodePairs(Way way, boolean bl) {
        ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
        for (Pair<Node, Node> pair : way.getNodePairs(false)) {
            arrayList.add(new NodePair(pair));
            if (bl) continue;
            arrayList.add(new NodePair(pair).swap());
        }
        return arrayList;
    }

    public static List<NodePair> buildNodePairs(List<Way> list, boolean bl) {
        ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
        for (Way way : list) {
            arrayList.addAll(NodeGraph.buildNodePairs(way, bl));
        }
        return arrayList;
    }

    public static List<NodePair> eliminateDuplicateNodePairs(List<NodePair> list) {
        ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
        for (NodePair nodePair : list) {
            if (arrayList.contains(nodePair) || arrayList.contains(nodePair.swap())) continue;
            arrayList.add(nodePair);
        }
        return arrayList;
    }

    public static NodeGraph createDirectedGraphFromNodePairs(List<NodePair> list) {
        NodeGraph nodeGraph = new NodeGraph();
        for (NodePair nodePair : list) {
            nodeGraph.add(nodePair);
        }
        return nodeGraph;
    }

    public static NodeGraph createDirectedGraphFromWays(Collection<Way> collection) {
        NodeGraph nodeGraph = new NodeGraph();
        for (Way way : collection) {
            nodeGraph.add(NodeGraph.buildNodePairs(way, true));
        }
        return nodeGraph;
    }

    public static NodeGraph createUndirectedGraphFromNodeList(List<NodePair> list) {
        NodeGraph nodeGraph = new NodeGraph();
        for (NodePair nodePair : list) {
            nodeGraph.add(nodePair);
            nodeGraph.add(nodePair.swap());
        }
        return nodeGraph;
    }

    public static NodeGraph createUndirectedGraphFromNodeWays(Collection<Way> collection) {
        NodeGraph nodeGraph = new NodeGraph();
        for (Way way : collection) {
            nodeGraph.add(NodeGraph.buildNodePairs(way, false));
        }
        return nodeGraph;
    }

    public static NodeGraph createNearlyUndirectedGraphFromNodeWays(Collection<Way> collection) {
        boolean bl = true;
        NodeGraph nodeGraph = new NodeGraph();
        for (Way way : collection) {
            if (!way.isNew()) {
                nodeGraph.add(NodeGraph.buildNodePairs(way, bl));
                bl = false;
                continue;
            }
            nodeGraph.add(NodeGraph.buildNodePairs(way, false));
        }
        return nodeGraph;
    }

    protected void rememberSuccessor(NodePair nodePair) {
        if (this.successors.containsKey(nodePair.getA())) {
            if (!this.successors.get(nodePair.getA()).contains(nodePair)) {
                this.successors.get(nodePair.getA()).add(nodePair);
            }
        } else {
            ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
            arrayList.add(nodePair);
            this.successors.put(nodePair.getA(), arrayList);
        }
    }

    protected void rememberPredecessors(NodePair nodePair) {
        if (this.predecessors.containsKey(nodePair.getB())) {
            if (!this.predecessors.get(nodePair.getB()).contains(nodePair)) {
                this.predecessors.get(nodePair.getB()).add(nodePair);
            }
        } else {
            ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
            arrayList.add(nodePair);
            this.predecessors.put(nodePair.getB(), arrayList);
        }
    }

    protected boolean isTerminalNode(Node node) {
        if (this.successors.get(node) == null) {
            return false;
        }
        if (this.successors.get(node).size() != 1) {
            return false;
        }
        if (this.predecessors.get(node) == null) {
            return true;
        }
        if (this.predecessors.get(node).size() == 1) {
            NodePair nodePair = this.successors.get(node).get(0);
            NodePair nodePair2 = this.predecessors.get(node).get(0);
            return nodePair.equals(nodePair2.swap());
        }
        return false;
    }

    protected void prepare() {
        LinkedHashSet<NodePair> linkedHashSet = new LinkedHashSet<NodePair>();
        this.successors.clear();
        this.predecessors.clear();
        for (NodePair nodePair : this.edges) {
            if (!linkedHashSet.contains(nodePair) && !linkedHashSet.contains(nodePair.swap())) {
                linkedHashSet.add(nodePair);
            }
            this.rememberSuccessor(nodePair);
            this.rememberPredecessors(nodePair);
        }
        this.numUndirectedEges = linkedHashSet.size();
    }

    public NodeGraph() {
        this.edges = new LinkedHashSet<NodePair>();
    }

    public void add(NodePair nodePair) {
        if (!this.edges.contains(nodePair)) {
            this.edges.add(nodePair);
        }
    }

    public void add(Collection<NodePair> collection) {
        for (NodePair nodePair : collection) {
            this.add(nodePair);
        }
    }

    protected Set<Node> getTerminalNodes() {
        LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>();
        for (Node node : this.getNodes()) {
            if (!this.isTerminalNode(node)) continue;
            linkedHashSet.add(node);
        }
        return linkedHashSet;
    }

    protected List<NodePair> getOutboundPairs(NodePair nodePair) {
        return this.getOutboundPairs(nodePair.getB());
    }

    protected List<NodePair> getOutboundPairs(Node node) {
        return Optional.ofNullable(this.successors.get(node)).orElseGet(Collections::emptyList);
    }

    protected Set<Node> getNodes() {
        LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>(2 * this.edges.size());
        for (NodePair nodePair : this.edges) {
            linkedHashSet.add(nodePair.getA());
            linkedHashSet.add(nodePair.getB());
        }
        return linkedHashSet;
    }

    protected boolean isSpanningWay(Stack<NodePair> stack) {
        return this.numUndirectedEges == stack.size();
    }

    protected List<Node> buildPathFromNodePairs(Stack<NodePair> stack) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (NodePair nodePair : stack) {
            linkedList.add(nodePair.getA());
        }
        linkedList.add(stack.peek().getB());
        return linkedList;
    }

    protected List<Node> buildSpanningPath(Node node) {
        if (node != null) {
            Stack<NodePair> stack = new Stack<NodePair>();
            Stack<NodePair> stack2 = new Stack<NodePair>();
            stack2.addAll(this.getOutboundPairs(node));
            while (!stack2.isEmpty()) {
                NodePair nodePair = (NodePair)stack2.pop();
                if (stack.contains(nodePair) || stack.contains(nodePair.swap())) continue;
                while (!stack.isEmpty() && !((NodePair)stack.peek()).isPredecessorOf(nodePair)) {
                    stack.pop();
                }
                stack.push(nodePair);
                if (this.isSpanningWay(stack)) {
                    return this.buildPathFromNodePairs(stack);
                }
                stack2.addAll(this.getOutboundPairs(stack.peek()));
            }
        }
        return Collections.emptyList();
    }

    public List<Node> buildSpanningPath() {
        this.prepare();
        Set<Node> set = this.getTerminalNodes();
        set = set.isEmpty() ? this.getNodes() : set;
        for (Node node : set) {
            List<Node> list = this.buildSpanningPath(node);
            if (list.isEmpty()) continue;
            return list;
        }
        return null;
    }
}

