/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.JosmRuntimeException;

public class QuadBucketPrimitiveStore {
    private final QuadBuckets<Node> nodes = new QuadBuckets();
    private final QuadBuckets<Way> ways = new QuadBuckets();
    private final Collection<Relation> relations = new ArrayList<Relation>();

    public List<Node> searchNodes(BBox bBox) {
        return this.nodes.search(bBox);
    }

    public boolean containsNode(Node node) {
        return this.nodes.contains(node);
    }

    public List<Way> searchWays(BBox bBox) {
        return this.ways.search(bBox);
    }

    public boolean containsWay(Way way) {
        return this.ways.contains(way);
    }

    public List<Relation> searchRelations(BBox bBox) {
        return this.relations.stream().filter(relation -> relation.getBBox().intersects(bBox)).collect(Collectors.toList());
    }

    public boolean containsRelation(Relation relation) {
        return this.relations.contains(relation);
    }

    public void addPrimitive(OsmPrimitive osmPrimitive) {
        boolean bl = false;
        if (osmPrimitive instanceof Node) {
            bl = this.nodes.add((Node)osmPrimitive);
        } else if (osmPrimitive instanceof Way) {
            bl = this.ways.add((Way)osmPrimitive);
        } else if (osmPrimitive instanceof Relation) {
            bl = this.relations.add((Relation)osmPrimitive);
        }
        if (!bl) {
            throw new JosmRuntimeException("failed to add primitive: " + osmPrimitive);
        }
    }

    protected void removePrimitive(OsmPrimitive osmPrimitive) {
        boolean bl = false;
        if (osmPrimitive instanceof Node) {
            bl = this.nodes.remove(osmPrimitive);
        } else if (osmPrimitive instanceof Way) {
            bl = this.ways.remove(osmPrimitive);
        } else if (osmPrimitive instanceof Relation) {
            bl = this.relations.remove(osmPrimitive);
        }
        if (!bl) {
            throw new JosmRuntimeException("failed to remove primitive: " + osmPrimitive);
        }
    }

    protected void reindexNode(Node node, LatLon latLon, EastNorth eastNorth) {
        if (!this.nodes.remove(node)) {
            throw new JosmRuntimeException("Reindexing node failed to remove");
        }
        node.setCoorInternal(latLon, eastNorth);
        if (!this.nodes.add(node)) {
            throw new JosmRuntimeException("Reindexing node failed to add");
        }
        for (OsmPrimitive osmPrimitive : node.getReferrers()) {
            if (osmPrimitive instanceof Way) {
                this.reindexWay((Way)osmPrimitive);
                continue;
            }
            QuadBucketPrimitiveStore.reindexRelation((Relation)osmPrimitive);
        }
    }

    protected void reindexWay(Way way) {
        BBox bBox = way.getBBox();
        if (!this.ways.remove(way)) {
            throw new JosmRuntimeException("Reindexing way failed to remove");
        }
        way.updatePosition();
        if (!this.ways.add(way)) {
            throw new JosmRuntimeException("Reindexing way failed to add");
        }
        if (!way.getBBox().equals(bBox)) {
            for (OsmPrimitive osmPrimitive : way.getReferrers()) {
                QuadBucketPrimitiveStore.reindexRelation((Relation)osmPrimitive);
            }
        }
    }

    protected static void reindexRelation(Relation relation) {
        BBox bBox = relation.getBBox();
        relation.updatePosition();
        if (!bBox.equals(relation.getBBox())) {
            for (OsmPrimitive osmPrimitive : relation.getReferrers()) {
                QuadBucketPrimitiveStore.reindexRelation((Relation)osmPrimitive);
            }
        }
    }

    public void clear() {
        this.nodes.clear();
        this.ways.clear();
        this.relations.clear();
    }
}

