/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint.relations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionChangeListener;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public final class MultipolygonCache
implements DataSetListener,
LayerManager.LayerChangeListener,
ProjectionChangeListener,
SelectionChangedListener {
    private static final MultipolygonCache INSTANCE = new MultipolygonCache();
    private final Map<DataSet, Map<Relation, Multipolygon>> cache = new ConcurrentHashMap<DataSet, Map<Relation, Multipolygon>>();
    private final Collection<Multipolygon.PolyData> selectedPolyData = new ArrayList<Multipolygon.PolyData>();

    private MultipolygonCache() {
        Main.addProjectionChangeListener(this);
        DataSet.addSelectionListener(this);
        MainApplication.getLayerManager().addLayerChangeListener(this);
    }

    public static MultipolygonCache getInstance() {
        return INSTANCE;
    }

    public Multipolygon get(Relation relation) {
        return this.get(relation, false);
    }

    public Multipolygon get(Relation relation, boolean bl) {
        Multipolygon multipolygon = null;
        if (relation != null) {
            Map<Relation, Multipolygon> map = this.cache.get(relation.getDataSet());
            if (map == null) {
                map = new ConcurrentHashMap<Relation, Multipolygon>();
                this.cache.put(relation.getDataSet(), map);
            }
            if ((multipolygon = map.get(relation)) == null || bl) {
                multipolygon = new Multipolygon(relation);
                map.put(relation, multipolygon);
                for (Multipolygon.PolyData polyData : multipolygon.getCombinedPolygons()) {
                    if (!polyData.isSelected()) continue;
                    this.selectedPolyData.add(polyData);
                }
            }
        }
        return multipolygon;
    }

    public void clear(DataSet dataSet) {
        Map<Relation, Multipolygon> map = this.cache.remove(dataSet);
        if (map != null) {
            map.clear();
        }
    }

    public void clear() {
        this.cache.clear();
    }

    private Collection<Map<Relation, Multipolygon>> getMapsFor(DataSet dataSet) {
        ArrayList<Map<Relation, Multipolygon>> arrayList = new ArrayList<Map<Relation, Multipolygon>>();
        Map<Relation, Multipolygon> map = this.cache.get(dataSet);
        if (map != null) {
            arrayList.add(map);
        }
        return arrayList;
    }

    private static boolean isMultipolygon(OsmPrimitive osmPrimitive) {
        return osmPrimitive instanceof Relation && ((Relation)osmPrimitive).isMultipolygon();
    }

    private void updateMultipolygonsReferringTo(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        this.updateMultipolygonsReferringTo(abstractDatasetChangedEvent, abstractDatasetChangedEvent.getPrimitives(), abstractDatasetChangedEvent.getDataset());
    }

    private void updateMultipolygonsReferringTo(AbstractDatasetChangedEvent abstractDatasetChangedEvent, Collection<? extends OsmPrimitive> collection, DataSet dataSet) {
        this.updateMultipolygonsReferringTo(abstractDatasetChangedEvent, collection, dataSet, null);
    }

    private Collection<Map<Relation, Multipolygon>> updateMultipolygonsReferringTo(AbstractDatasetChangedEvent abstractDatasetChangedEvent, Collection<? extends OsmPrimitive> collection, DataSet dataSet, Collection<Map<Relation, Multipolygon>> collection2) {
        Collection<Map<Relation, Multipolygon>> collection3 = collection2;
        if (collection != null) {
            for (OsmPrimitive osmPrimitive : collection) {
                if (MultipolygonCache.isMultipolygon(osmPrimitive)) {
                    if (collection3 == null) {
                        collection3 = this.getMapsFor(dataSet);
                    }
                    MultipolygonCache.processEvent(abstractDatasetChangedEvent, (Relation)osmPrimitive, collection3);
                    continue;
                }
                if (osmPrimitive instanceof Way && osmPrimitive.getDataSet() != null) {
                    for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                        if (!MultipolygonCache.isMultipolygon(osmPrimitive2)) continue;
                        if (collection3 == null) {
                            collection3 = this.getMapsFor(dataSet);
                        }
                        MultipolygonCache.processEvent(abstractDatasetChangedEvent, (Relation)osmPrimitive2, collection3);
                    }
                    continue;
                }
                if (!(osmPrimitive instanceof Node) || osmPrimitive.getDataSet() == null) continue;
                collection3 = this.updateMultipolygonsReferringTo(abstractDatasetChangedEvent, osmPrimitive.getReferrers(), dataSet, collection3);
            }
        }
        return collection3;
    }

    private static void processEvent(AbstractDatasetChangedEvent abstractDatasetChangedEvent, Relation relation, Collection<Map<Relation, Multipolygon>> collection) {
        if (abstractDatasetChangedEvent instanceof NodeMovedEvent || abstractDatasetChangedEvent instanceof WayNodesChangedEvent) {
            MultipolygonCache.dispatchEvent(abstractDatasetChangedEvent, relation, collection);
        } else if (abstractDatasetChangedEvent instanceof PrimitivesRemovedEvent) {
            if (abstractDatasetChangedEvent.getPrimitives().contains(relation)) {
                MultipolygonCache.removeMultipolygonFrom(relation, collection);
            }
        } else {
            MultipolygonCache.removeMultipolygonFrom(relation, collection);
        }
    }

    private static void dispatchEvent(AbstractDatasetChangedEvent abstractDatasetChangedEvent, Relation relation, Collection<Map<Relation, Multipolygon>> collection) {
        for (Map<Relation, Multipolygon> map : collection) {
            Multipolygon multipolygon = map.get(relation);
            if (multipolygon == null) continue;
            for (Multipolygon.PolyData polyData : multipolygon.getCombinedPolygons()) {
                if (abstractDatasetChangedEvent instanceof NodeMovedEvent) {
                    polyData.nodeMoved((NodeMovedEvent)abstractDatasetChangedEvent);
                    continue;
                }
                if (!(abstractDatasetChangedEvent instanceof WayNodesChangedEvent)) continue;
                boolean bl = polyData.isClosed();
                polyData.wayNodesChanged((WayNodesChangedEvent)abstractDatasetChangedEvent);
                if (polyData.isClosed() == bl) continue;
                MultipolygonCache.removeMultipolygonFrom(relation, collection);
                return;
            }
        }
    }

    private static void removeMultipolygonFrom(Relation relation, Collection<Map<Relation, Multipolygon>> collection) {
        for (Map<Relation, Multipolygon> object : collection) {
            object.remove(relation);
        }
        for (OsmPrimitive osmPrimitive : relation.getMemberPrimitivesList()) {
            osmPrimitive.clearCachedStyle();
        }
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent primitivesAddedEvent) {
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent primitivesRemovedEvent) {
        this.updateMultipolygonsReferringTo(primitivesRemovedEvent);
    }

    @Override
    public void tagsChanged(TagsChangedEvent tagsChangedEvent) {
        this.updateMultipolygonsReferringTo(tagsChangedEvent);
    }

    @Override
    public void nodeMoved(NodeMovedEvent nodeMovedEvent) {
        this.updateMultipolygonsReferringTo(nodeMovedEvent);
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent wayNodesChangedEvent) {
        this.updateMultipolygonsReferringTo(wayNodesChangedEvent);
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent relationMembersChangedEvent) {
        this.updateMultipolygonsReferringTo(relationMembersChangedEvent);
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
    }

    @Override
    public void dataChanged(DataChangedEvent dataChangedEvent) {
        Collection<Map<Relation, Multipolygon>> collection = null;
        for (OsmPrimitive osmPrimitive : dataChangedEvent.getPrimitives()) {
            if (!MultipolygonCache.isMultipolygon(osmPrimitive)) continue;
            if (collection == null) {
                collection = this.getMapsFor(dataChangedEvent.getDataset());
            }
            for (Map map : collection) {
                map.remove(osmPrimitive);
            }
        }
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent layerAddEvent) {
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent layerOrderChangeEvent) {
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent layerRemoveEvent) {
        if (layerRemoveEvent.getRemovedLayer() instanceof OsmDataLayer) {
            this.clear(((OsmDataLayer)layerRemoveEvent.getRemovedLayer()).data);
        }
    }

    @Override
    public void projectionChanged(Projection projection, Projection projection2) {
        this.clear();
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        Object object = this.selectedPolyData.iterator();
        while (object.hasNext()) {
            object.next().setSelected(false);
            object.remove();
        }
        object = null;
        Collection<Map<Relation, Multipolygon>> collection2 = null;
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Way) || osmPrimitive.getDataSet() == null) continue;
            if (object == null) {
                object = osmPrimitive.getDataSet();
            }
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                if (!MultipolygonCache.isMultipolygon(osmPrimitive2)) continue;
                if (collection2 == null) {
                    collection2 = this.getMapsFor((DataSet)object);
                }
                for (Map map : collection2) {
                    Multipolygon multipolygon = (Multipolygon)map.get(osmPrimitive2);
                    if (multipolygon == null) continue;
                    for (Multipolygon.PolyData polyData : multipolygon.getCombinedPolygons()) {
                        if (!polyData.getWayIds().contains(osmPrimitive.getUniqueId())) continue;
                        polyData.setSelected(true);
                        this.selectedPolyData.add(polyData);
                    }
                }
            }
        }
    }
}

