/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.preferences.AbstractSetting;
import org.openstreetmap.josm.data.preferences.SettingVisitor;

public class MapListSetting
extends AbstractSetting<List<Map<String, String>>> {
    public MapListSetting(List<Map<String, String>> list) {
        super(list);
        this.consistencyTest();
    }

    public MapListSetting copy() {
        if (this.value == null) {
            return new MapListSetting(null);
        }
        ArrayList arrayList = new ArrayList(((List)this.value).size());
        for (Map map : (List)this.value) {
            LinkedHashMap linkedHashMap = new LinkedHashMap(map);
            arrayList.add(Collections.unmodifiableMap(linkedHashMap));
        }
        return new MapListSetting(Collections.unmodifiableList(arrayList));
    }

    private void consistencyTest() {
        if (this.value == null) {
            return;
        }
        if (((List)this.value).contains(null)) {
            throw new IllegalArgumentException("Error: Null as list element in preference setting");
        }
        for (Map map : (List)this.value) {
            if (map.containsKey(null)) {
                throw new IllegalArgumentException("Error: Null as map key in preference setting");
            }
            if (!map.containsValue(null)) continue;
            throw new IllegalArgumentException("Error: Null as map value in preference setting");
        }
    }

    @Override
    public void visit(SettingVisitor settingVisitor) {
        settingVisitor.visit(this);
    }

    public MapListSetting getNullInstance() {
        return new MapListSetting(null);
    }
}

