/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences.sources;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.preferences.sources.ExtendedSourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourcePrefHelper;
import org.openstreetmap.josm.tools.I18n;

public class PresetPrefHelper
extends SourcePrefHelper {
    public static final PresetPrefHelper INSTANCE = new PresetPrefHelper();

    public PresetPrefHelper() {
        super("taggingpreset.entries");
    }

    @Override
    public Collection<ExtendedSourceEntry> getDefault() {
        ExtendedSourceEntry extendedSourceEntry = new ExtendedSourceEntry("defaultpresets.xml", "resource://data/defaultpresets.xml");
        extendedSourceEntry.title = I18n.tr("Internal Preset", new Object[0]);
        extendedSourceEntry.description = I18n.tr("The default preset for JOSM", new Object[0]);
        return Collections.singletonList(extendedSourceEntry);
    }

    @Override
    public Map<String, String> serialize(SourceEntry sourceEntry) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("url", sourceEntry.url);
        hashMap.put("title", sourceEntry.title == null ? "" : sourceEntry.title);
        return hashMap;
    }

    @Override
    public SourceEntry deserialize(Map<String, String> map) {
        return new SourceEntry(map.get("url"), null, map.get("title"), true);
    }
}

