/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation;

import java.awt.Color;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public enum Severity {
    ERROR(1, I18n.tr("Errors", new Object[0]), "error", new ColorProperty(I18n.marktr("validation error"), Color.RED).get()),
    WARNING(2, I18n.tr("Warnings", new Object[0]), "warning", new ColorProperty(I18n.marktr("validation warning"), Color.YELLOW).get()),
    OTHER(3, I18n.tr("Other", new Object[0]), "other", new ColorProperty(I18n.marktr("validation other"), Color.CYAN).get());

    private final int level;
    private final String message;
    private final String icon;
    private final Color color;

    private Severity(int n2, String string2, String string3, Color color) {
        this.level = n2;
        this.message = string2;
        this.icon = string3;
        this.color = color;
    }

    public static void getColors() {
        for (Severity severity : Severity.values()) {
            Logging.debug("{0}", new Object[]{severity});
        }
    }

    public String toString() {
        return this.message;
    }

    public String getIcon() {
        return this.icon;
    }

    public Color getColor() {
        return this.color;
    }

    public int getLevel() {
        return this.level;
    }
}

