/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.nodes;

import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.conflict.ConflictColors;
import org.openstreetmap.josm.gui.conflict.pair.AbstractListMergeModel;
import org.openstreetmap.josm.tools.ImageProvider;

public class NodeListTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private final ImageIcon icon = ImageProvider.get("data", "node");
    private final transient Border rowNumberBorder = BorderFactory.createEmptyBorder(0, 4, 0, 0);

    public NodeListTableCellRenderer() {
        this.setOpaque(true);
    }

    protected void reset() {
        this.setBackground(ConflictColors.BGCOLOR.get());
        this.setForeground(ConflictColors.FGCOLOR.get());
        this.setBorder(null);
        this.setIcon(null);
        this.setToolTipText(null);
    }

    protected void renderNode(AbstractListMergeModel.EntriesTableModel entriesTableModel, Node node, int n, boolean bl) {
        this.setIcon(this.icon);
        this.setBorder(null);
        if (entriesTableModel.getListMergeModel().isFrozen()) {
            this.setBackground(ConflictColors.BGCOLOR_FROZEN.get());
        } else if (bl) {
            this.setBackground(ConflictColors.BGCOLOR_SELECTED.get());
        } else if (entriesTableModel.isParticipatingInCurrentComparePair()) {
            if (entriesTableModel.isSamePositionInOppositeList(n)) {
                this.setBackground(ConflictColors.BGCOLOR_SAME_POSITION_IN_OPPOSITE.get());
            } else if (entriesTableModel.isIncludedInOppositeList(n)) {
                this.setBackground(ConflictColors.BGCOLOR_IN_OPPOSITE.get());
            } else {
                this.setBackground(ConflictColors.BGCOLOR_NOT_IN_OPPOSITE.get());
            }
        }
        this.setText(node.getDisplayName(DefaultNameFormatter.getInstance()));
        this.setToolTipText(DefaultNameFormatter.getInstance().buildDefaultToolTip(node));
    }

    protected void renderEmptyRow() {
        this.setIcon(null);
        this.setBackground(ConflictColors.BGCOLOR_EMPTY_ROW.get());
        this.setText("");
    }

    protected void renderRowId(AbstractListMergeModel.EntriesTableModel entriesTableModel, int n) {
        this.setIcon(null);
        this.setBorder(this.rowNumberBorder);
        if (entriesTableModel.getListMergeModel().isFrozen()) {
            this.setBackground(ConflictColors.BGCOLOR_FROZEN.get());
        } else if (entriesTableModel.isParticipatingInCurrentComparePair()) {
            this.setBackground(ConflictColors.BGCOLOR_PARTICIPATING_IN_COMPARISON.get());
            this.setForeground(ConflictColors.FGCOLOR_PARTICIPATING_IN_COMPARISON.get());
        }
        this.setText(Integer.toString(n + 1));
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Node node = (Node)object;
        this.reset();
        if (node == null) {
            this.renderEmptyRow();
        } else {
            switch (n2) {
                case 0: {
                    this.renderRowId(this.getModel(jTable), n);
                    break;
                }
                case 1: {
                    this.renderNode(this.getModel(jTable), node, n, bl);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MessageFormat.format("Unexpected column index. Got {0}.", n2));
                }
            }
        }
        return this;
    }

    protected AbstractListMergeModel.EntriesTableModel getModel(JTable jTable) {
        return (AbstractListMergeModel.EntriesTableModel)jTable.getModel();
    }
}

