/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.properties;

import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.ConflictColors;
import org.openstreetmap.josm.gui.conflict.pair.AbstractMergePanel;
import org.openstreetmap.josm.gui.conflict.pair.IConflictResolver;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.properties.PropertiesMergeModel;
import org.openstreetmap.josm.gui.history.VersionInfoPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class PropertiesMerger
extends AbstractMergePanel
implements ChangeListener,
IConflictResolver {
    private static final DecimalFormat COORD_FORMATTER = new DecimalFormat("###0.0000000");
    private final JLabel lblMyCoordinates = PropertiesMerger.buildValueLabel("label.mycoordinates");
    private final JLabel lblMergedCoordinates = PropertiesMerger.buildValueLabel("label.mergedcoordinates");
    private final JLabel lblTheirCoordinates = PropertiesMerger.buildValueLabel("label.theircoordinates");
    private final JLabel lblMyDeletedState = PropertiesMerger.buildValueLabel("label.mydeletedstate");
    private final JLabel lblMergedDeletedState = PropertiesMerger.buildValueLabel("label.mergeddeletedstate");
    private final JLabel lblTheirDeletedState = PropertiesMerger.buildValueLabel("label.theirdeletedstate");
    private final JLabel lblMyReferrers = PropertiesMerger.buildValueLabel("label.myreferrers");
    private final JLabel lblTheirReferrers = PropertiesMerger.buildValueLabel("label.theirreferrers");
    private final transient PropertiesMergeModel model = new PropertiesMergeModel();
    private final VersionInfoPanel mineVersionInfo = new VersionInfoPanel();
    private final VersionInfoPanel theirVersionInfo = new VersionInfoPanel();

    public PropertiesMerger() {
        this.model.addChangeListener(this);
        this.buildRows();
    }

    @Override
    protected List<? extends AbstractMergePanel.MergeRow> getRows() {
        return Arrays.asList(new AbstractMergePanel.TitleRow(), new VersionInfoRow(), new MergeCoordinatesRow(), new UndecideCoordinatesRow(), new MergeDeletedStateRow(), new UndecideDeletedStateRow(), new ReferrersRow(), new EmptyFillRow());
    }

    protected static JLabel buildValueLabel(String string) {
        JLabel jLabel = new JLabel();
        jLabel.setName(string);
        jLabel.setHorizontalAlignment(0);
        jLabel.setOpaque(true);
        jLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        return jLabel;
    }

    protected static String coordToString(LatLon latLon) {
        if (latLon == null) {
            return I18n.tr("(none)", new Object[0]);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(').append(COORD_FORMATTER.format(latLon.lat())).append(',').append(COORD_FORMATTER.format(latLon.lon())).append(')');
        return stringBuilder.toString();
    }

    protected static String deletedStateToString(Boolean bl) {
        if (bl == null) {
            return I18n.tr("(none)", new Object[0]);
        }
        if (bl.booleanValue()) {
            return I18n.tr("deleted", new Object[0]);
        }
        return I18n.tr("not deleted", new Object[0]);
    }

    protected static String referrersToString(List<OsmPrimitive> list) {
        if (list.isEmpty()) {
            return I18n.tr("(none)", new Object[0]);
        }
        StringBuilder stringBuilder = new StringBuilder("<html>");
        for (OsmPrimitive osmPrimitive : list) {
            stringBuilder.append(Utils.escapeReservedCharactersHTML(osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()))).append("<br>");
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    protected void updateCoordinates() {
        this.lblMyCoordinates.setText(PropertiesMerger.coordToString(this.model.getMyCoords()));
        this.lblMergedCoordinates.setText(PropertiesMerger.coordToString(this.model.getMergedCoords()));
        this.lblTheirCoordinates.setText(PropertiesMerger.coordToString(this.model.getTheirCoords()));
        if (!this.model.hasCoordConflict()) {
            this.lblMyCoordinates.setBackground(ConflictColors.BGCOLOR_NO_CONFLICT.get());
            this.lblMergedCoordinates.setBackground(ConflictColors.BGCOLOR_NO_CONFLICT.get());
            this.lblTheirCoordinates.setBackground(ConflictColors.BGCOLOR_NO_CONFLICT.get());
        } else if (!this.model.isDecidedCoord()) {
            this.lblMyCoordinates.setBackground(ConflictColors.BGCOLOR_UNDECIDED.get());
            this.lblMergedCoordinates.setBackground(ConflictColors.BGCOLOR_NO_CONFLICT.get());
            this.lblTheirCoordinates.setBackground(ConflictColors.BGCOLOR_UNDECIDED.get());
        } else {
            this.lblMyCoordinates.setBackground(this.model.isCoordMergeDecision(MergeDecisionType.KEEP_MINE) ? ConflictColors.BGCOLOR_DECIDED.get() : ConflictColors.BGCOLOR_NO_CONFLICT.get());
            this.lblMergedCoordinates.setBackground(ConflictColors.BGCOLOR_DECIDED.get());
            this.lblTheirCoordinates.setBackground(this.model.isCoordMergeDecision(MergeDecisionType.KEEP_THEIR) ? ConflictColors.BGCOLOR_DECIDED.get() : ConflictColors.BGCOLOR_NO_CONFLICT.get());
        }
    }

    protected void updateDeletedState() {
        this.lblMyDeletedState.setText(PropertiesMerger.deletedStateToString(this.model.getMyDeletedState()));
        this.lblMergedDeletedState.setText(PropertiesMerger.deletedStateToString(this.model.getMergedDeletedState()));
        this.lblTheirDeletedState.setText(PropertiesMerger.deletedStateToString(this.model.getTheirDeletedState()));
        if (!this.model.hasDeletedStateConflict()) {
            this.lblMyDeletedState.setBackground(ConflictColors.BGCOLOR_NO_CONFLICT.get());
            this.lblMergedDeletedState.setBackground(ConflictColors.BGCOLOR_NO_CONFLICT.get());
            this.lblTheirDeletedState.setBackground(ConflictColors.BGCOLOR_NO_CONFLICT.get());
        } else if (!this.model.isDecidedDeletedState()) {
            this.lblMyDeletedState.setBackground(ConflictColors.BGCOLOR_UNDECIDED.get());
            this.lblMergedDeletedState.setBackground(ConflictColors.BGCOLOR_NO_CONFLICT.get());
            this.lblTheirDeletedState.setBackground(ConflictColors.BGCOLOR_UNDECIDED.get());
        } else {
            this.lblMyDeletedState.setBackground(this.model.isDeletedStateDecision(MergeDecisionType.KEEP_MINE) ? ConflictColors.BGCOLOR_DECIDED.get() : ConflictColors.BGCOLOR_NO_CONFLICT.get());
            this.lblMergedDeletedState.setBackground(ConflictColors.BGCOLOR_DECIDED.get());
            this.lblTheirDeletedState.setBackground(this.model.isDeletedStateDecision(MergeDecisionType.KEEP_THEIR) ? ConflictColors.BGCOLOR_DECIDED.get() : ConflictColors.BGCOLOR_NO_CONFLICT.get());
        }
    }

    protected void updateReferrers() {
        this.lblMyReferrers.setText(PropertiesMerger.referrersToString(this.model.getMyReferrers()));
        this.lblMyReferrers.setBackground(ConflictColors.BGCOLOR_NO_CONFLICT.get());
        this.lblTheirReferrers.setText(PropertiesMerger.referrersToString(this.model.getTheirReferrers()));
        this.lblTheirReferrers.setBackground(ConflictColors.BGCOLOR_NO_CONFLICT.get());
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateCoordinates();
        this.updateDeletedState();
        this.updateReferrers();
    }

    public PropertiesMergeModel getModel() {
        return this.model;
    }

    @Override
    public void deletePrimitive(boolean bl) {
        if (bl) {
            if (this.model.getMergedCoords() == null) {
                this.model.decideCoordsConflict(MergeDecisionType.KEEP_MINE);
            }
        } else {
            this.model.decideCoordsConflict(MergeDecisionType.UNDECIDED);
        }
    }

    @Override
    public void populate(Conflict<? extends OsmPrimitive> conflict) {
        this.model.populate(conflict);
        this.mineVersionInfo.update(conflict.getMy(), true);
        this.theirVersionInfo.update(conflict.getTheir(), false);
    }

    @Override
    public void decideRemaining(MergeDecisionType mergeDecisionType) {
        if (!this.model.isDecidedCoord()) {
            this.model.decideDeletedStateConflict(mergeDecisionType);
        }
        if (!this.model.isDecidedCoord()) {
            this.model.decideCoordsConflict(mergeDecisionType);
        }
    }

    class UndecideDeletedStateConflictAction
    extends AbstractAction
    implements ChangeListener {
        UndecideDeletedStateConflictAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagundecide"));
            this.putValue("ShortDescription", I18n.tr("Undecide conflict between deleted state", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesMerger.this.model.decideDeletedStateConflict(MergeDecisionType.UNDECIDED);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.setEnabled(PropertiesMerger.this.model.hasDeletedStateConflict() && PropertiesMerger.this.model.isDecidedDeletedState());
        }
    }

    class KeepTheirDeletedStateAction
    extends AbstractAction
    implements ChangeListener {
        KeepTheirDeletedStateAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeeptheir"));
            this.putValue("ShortDescription", I18n.tr("Keep their deleted state", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesMerger.this.model.decideDeletedStateConflict(MergeDecisionType.KEEP_THEIR);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.setEnabled(PropertiesMerger.this.model.hasDeletedStateConflict() && !PropertiesMerger.this.model.isDecidedDeletedState());
        }
    }

    class KeepMyDeletedStateAction
    extends AbstractAction
    implements ChangeListener {
        KeepMyDeletedStateAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeepmine"));
            this.putValue("ShortDescription", I18n.tr("Keep my deleted state", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesMerger.this.model.decideDeletedStateConflict(MergeDecisionType.KEEP_MINE);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.setEnabled(PropertiesMerger.this.model.hasDeletedStateConflict() && !PropertiesMerger.this.model.isDecidedDeletedState());
        }
    }

    class UndecideCoordinateConflictAction
    extends AbstractAction
    implements ChangeListener {
        UndecideCoordinateConflictAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagundecide"));
            this.putValue("ShortDescription", I18n.tr("Undecide conflict between different coordinates", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesMerger.this.model.decideCoordsConflict(MergeDecisionType.UNDECIDED);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.setEnabled(PropertiesMerger.this.model.hasCoordConflict() && PropertiesMerger.this.model.isDecidedCoord());
        }
    }

    class KeepTheirCoordinatesAction
    extends AbstractAction
    implements ChangeListener {
        KeepTheirCoordinatesAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeeptheir"));
            this.putValue("ShortDescription", I18n.tr("Keep their coordinates", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesMerger.this.model.decideCoordsConflict(MergeDecisionType.KEEP_THEIR);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.setEnabled(PropertiesMerger.this.model.hasCoordConflict() && !PropertiesMerger.this.model.isDecidedCoord() && PropertiesMerger.this.model.getTheirCoords() != null);
        }
    }

    class KeepMyCoordinatesAction
    extends AbstractAction
    implements ChangeListener {
        KeepMyCoordinatesAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeepmine"));
            this.putValue("ShortDescription", I18n.tr("Keep my coordinates", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesMerger.this.model.decideCoordsConflict(MergeDecisionType.KEEP_MINE);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.setEnabled(PropertiesMerger.this.model.hasCoordConflict() && !PropertiesMerger.this.model.isDecidedCoord() && PropertiesMerger.this.model.getMyCoords() != null);
        }
    }

    private static final class EmptyFillRow
    extends AbstractMergePanel.MergeRow {
        private EmptyFillRow() {
        }

        @Override
        protected JComponent merged() {
            return new JPanel();
        }

        @Override
        protected void addConstraints(GBC gBC, int n) {
            super.addConstraints(gBC, n);
            gBC.weighty = 1.0;
        }
    }

    private final class ReferrersRow
    extends AbstractMergePanel.MergeRow {
        private ReferrersRow() {
        }

        @Override
        protected JComponent rowTitle() {
            return new JLabel(I18n.tr("Referenced by:", new Object[0]));
        }

        @Override
        protected JComponent mineField() {
            return PropertiesMerger.this.lblMyReferrers;
        }

        @Override
        protected JComponent theirsField() {
            return PropertiesMerger.this.lblTheirReferrers;
        }
    }

    private final class VersionInfoRow
    extends AbstractMergePanel.MergeRowWithoutButton {
        private VersionInfoRow() {
        }

        @Override
        protected JComponent mineField() {
            return PropertiesMerger.this.mineVersionInfo;
        }

        @Override
        protected JComponent theirsField() {
            return PropertiesMerger.this.theirVersionInfo;
        }
    }

    private final class UndecideDeletedStateRow
    extends AbstractMergePanel.AbstractUndecideRow {
        private UndecideDeletedStateRow() {
        }

        @Override
        protected UndecideDeletedStateConflictAction createAction() {
            UndecideDeletedStateConflictAction undecideDeletedStateConflictAction = new UndecideDeletedStateConflictAction();
            PropertiesMerger.this.model.addChangeListener(undecideDeletedStateConflictAction);
            return undecideDeletedStateConflictAction;
        }

        @Override
        protected String getButtonName() {
            return "button.undecidedeletedstate";
        }
    }

    private final class UndecideCoordinatesRow
    extends AbstractMergePanel.AbstractUndecideRow {
        private UndecideCoordinatesRow() {
        }

        @Override
        protected UndecideCoordinateConflictAction createAction() {
            UndecideCoordinateConflictAction undecideCoordinateConflictAction = new UndecideCoordinateConflictAction();
            PropertiesMerger.this.model.addChangeListener(undecideCoordinateConflictAction);
            return undecideCoordinateConflictAction;
        }

        @Override
        protected String getButtonName() {
            return "button.undecidecoordinates";
        }
    }

    private final class MergeCoordinatesRow
    extends AbstractMergePanel.MergeRow {
        private MergeCoordinatesRow() {
        }

        @Override
        protected JComponent rowTitle() {
            return new JLabel(I18n.tr("Coordinates:", new Object[0]));
        }

        @Override
        protected JComponent mineField() {
            return PropertiesMerger.this.lblMyCoordinates;
        }

        @Override
        protected JComponent mineButton() {
            KeepMyCoordinatesAction keepMyCoordinatesAction = new KeepMyCoordinatesAction();
            PropertiesMerger.this.model.addChangeListener(keepMyCoordinatesAction);
            JButton jButton = new JButton(keepMyCoordinatesAction);
            jButton.setName("button.keepmycoordinates");
            return jButton;
        }

        @Override
        protected JComponent merged() {
            return PropertiesMerger.this.lblMergedCoordinates;
        }

        @Override
        protected JComponent theirsButton() {
            KeepTheirCoordinatesAction keepTheirCoordinatesAction = new KeepTheirCoordinatesAction();
            PropertiesMerger.this.model.addChangeListener(keepTheirCoordinatesAction);
            JButton jButton = new JButton(keepTheirCoordinatesAction);
            jButton.setName("button.keeptheircoordinates");
            return jButton;
        }

        @Override
        protected JComponent theirsField() {
            return PropertiesMerger.this.lblTheirCoordinates;
        }
    }

    private final class MergeDeletedStateRow
    extends AbstractMergePanel.MergeRow {
        private MergeDeletedStateRow() {
        }

        @Override
        protected JComponent rowTitle() {
            return new JLabel(I18n.tr("Deleted State:", new Object[0]));
        }

        @Override
        protected JComponent mineField() {
            return PropertiesMerger.this.lblMyDeletedState;
        }

        @Override
        protected JComponent mineButton() {
            KeepMyDeletedStateAction keepMyDeletedStateAction = new KeepMyDeletedStateAction();
            PropertiesMerger.this.model.addChangeListener(keepMyDeletedStateAction);
            JButton jButton = new JButton(keepMyDeletedStateAction);
            jButton.setName("button.keepmydeletedstate");
            return jButton;
        }

        @Override
        protected JComponent merged() {
            return PropertiesMerger.this.lblMergedDeletedState;
        }

        @Override
        protected JComponent theirsButton() {
            KeepTheirDeletedStateAction keepTheirDeletedStateAction = new KeepTheirDeletedStateAction();
            PropertiesMerger.this.model.addChangeListener(keepTheirDeletedStateAction);
            JButton jButton = new JButton(keepTheirDeletedStateAction);
            jButton.setName("button.keeptheirdeletedstate");
            return jButton;
        }

        @Override
        protected JComponent theirsField() {
            return PropertiesMerger.this.lblTheirDeletedState;
        }
    }
}

