/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.gui.datatransfer.data.PrimitiveTransferData;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class RelationMemberTransferable
implements Transferable {
    public static final DataFlavor RELATION_MEMBER_DATA = new DataFlavor(Data.class, "Relation member");
    private final Collection<RelationMember> members;

    public RelationMemberTransferable(Collection<RelationMember> collection) {
        this.members = new ArrayList<RelationMember>(collection);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{RELATION_MEMBER_DATA, PrimitiveTransferData.DATA_FLAVOR, DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return Arrays.asList(this.getTransferDataFlavors()).contains(dataFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            return this.getStringData();
        }
        if (RELATION_MEMBER_DATA.equals(dataFlavor)) {
            return this.getRelationMemberData();
        }
        if (PrimitiveTransferData.DATA_FLAVOR.equals(dataFlavor)) {
            return this.getPrimitiveData();
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    private PrimitiveTransferData getPrimitiveData() {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (RelationMember relationMember : this.members) {
            hashSet.add(relationMember.getMember());
        }
        return PrimitiveTransferData.getData(hashSet);
    }

    protected String getStringData() {
        StringBuilder stringBuilder = new StringBuilder();
        for (RelationMember relationMember : this.members) {
            stringBuilder.append((Object)relationMember.getType()).append(' ').append(relationMember.getUniqueId()).append(' ').append(relationMember.getRole()).append(" # ").append(relationMember.getMember().getDisplayName(DefaultNameFormatter.getInstance())).append('\n');
        }
        return stringBuilder.toString().replace("\u200e", "").replace("\u200f", "");
    }

    protected Data getRelationMemberData() {
        return Data.getData(this.members);
    }

    public static final class Data
    implements Serializable {
        private static final long serialVersionUID = -8432393711635811029L;
        private final Collection<RelationMemberData> relationMemberDatas;

        private Data(Collection<RelationMemberData> collection) {
            CheckParameterUtil.ensureThat(collection instanceof Serializable, "primitiveData must be instanceof Serializable");
            this.relationMemberDatas = collection;
        }

        public Collection<RelationMemberData> getRelationMemberData() {
            return Collections.unmodifiableCollection(this.relationMemberDatas);
        }

        public static Data getData(Collection<RelationMember> collection) {
            ArrayList<RelationMemberData> arrayList = new ArrayList<RelationMemberData>(collection.size());
            for (RelationMember relationMember : collection) {
                arrayList.add(new RelationMemberData(relationMember.getRole(), relationMember.getType(), relationMember.getUniqueId()));
            }
            return new Data(arrayList);
        }
    }
}

