/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.event.ActionEvent;
import org.openstreetmap.josm.gui.dialogs.relation.GenericRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.IRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AddFromSelectionAction;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class AddSelectedAfterSelection
extends AddFromSelectionAction {
    public AddSelectedAfterSelection(MemberTableModel memberTableModel, SelectionTableModel selectionTableModel, IRelationEditor iRelationEditor) {
        super(null, memberTableModel, null, selectionTableModel, null, null, iRelationEditor);
        this.putValue("ShortDescription", I18n.tr("Add all objects selected in the current dataset after the last selected member", new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "copyaftercurrentright"));
        this.updateEnabledState();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.selectionTableModel.getRowCount() > 0 && this.memberTableModel.getSelectionModel().getMinSelectionIndex() >= 0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.memberTableModel.addMembersAfterIdx(this.filterConfirmedPrimitives(this.selectionTableModel.getSelection()), this.memberTableModel.getSelectionModel().getMaxSelectionIndex());
        }
        catch (GenericRelationEditor.AddAbortException addAbortException) {
            Logging.trace(addAbortException);
        }
    }
}

