/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.sort;

import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;

final class RelationSortUtils {
    private RelationSortUtils() {
    }

    static WayConnectionType.Direction roundaboutType(RelationMember relationMember) {
        if (relationMember == null || !relationMember.isWay()) {
            return WayConnectionType.Direction.NONE;
        }
        return RelationSortUtils.roundaboutType(relationMember.getWay());
    }

    static WayConnectionType.Direction roundaboutType(Way way) {
        int n;
        if (way != null && way.hasTag("junction", "roundabout") && (n = way.getNodesCount()) > 2 && n < 200) {
            Node node = way.getNode(0);
            Node node2 = way.getNode(1);
            Node node3 = way.getNode(2);
            if (node != null && node2 != null && node3 != null && way.isClosed()) {
                EastNorth eastNorth = node.getEastNorth();
                EastNorth eastNorth2 = node2.getEastNorth();
                EastNorth eastNorth3 = node3.getEastNorth();
                if (eastNorth != null && eastNorth2 != null && eastNorth3 != null) {
                    eastNorth = eastNorth2.subtract(eastNorth);
                    eastNorth2 = eastNorth3.subtract(eastNorth2);
                    return eastNorth.north() * eastNorth2.east() - eastNorth2.north() * eastNorth.east() > 0.0 ? WayConnectionType.Direction.ROUNDABOUT_LEFT : WayConnectionType.Direction.ROUNDABOUT_RIGHT;
                }
            }
        }
        return WayConnectionType.Direction.NONE;
    }

    static boolean isBackward(RelationMember relationMember) {
        return "backward".equals(relationMember.getRole());
    }

    static boolean isForward(RelationMember relationMember) {
        return "forward".equals(relationMember.getRole());
    }

    static boolean isOneway(RelationMember relationMember) {
        return RelationSortUtils.isForward(relationMember) || RelationSortUtils.isBackward(relationMember);
    }
}

