/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicArrowButton;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.preferences.AbstractProperty;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.download.AbstractDownloadSourcePanel;
import org.openstreetmap.josm.gui.download.DownloadSettings;
import org.openstreetmap.josm.gui.download.DownloadSource;
import org.openstreetmap.josm.gui.download.DownloadSourceSizingPolicy;
import org.openstreetmap.josm.gui.download.OverpassQueryList;
import org.openstreetmap.josm.gui.download.OverpassQueryWizardDialog;
import org.openstreetmap.josm.gui.preferences.server.OverpassServerPreference;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.io.OverpassDownloadReader;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class OverpassDownloadSource
implements DownloadSource<OverpassDownloadData> {
    @Override
    public AbstractDownloadSourcePanel<OverpassDownloadData> createPanel() {
        return new OverpassDownloadSourcePanel(this);
    }

    @Override
    public void doDownload(OverpassDownloadData overpassDownloadData, DownloadSettings downloadSettings) {
        Bounds bounds = downloadSettings.getDownloadBounds().orElse(new Bounds(0.0, 0.0, 0.0, 0.0));
        DownloadOsmTask downloadOsmTask = new DownloadOsmTask();
        downloadOsmTask.setZoomAfterDownload(downloadSettings.zoomToData());
        Future<?> future = downloadOsmTask.download(new OverpassDownloadReader(bounds, OverpassServerPreference.getOverpassServer(), overpassDownloadData.getQuery()), downloadSettings.asNewLayer(), bounds, null);
        MainApplication.worker.submit(new PostDownloadHandler(downloadOsmTask, future, overpassDownloadData.getErrorReporter()));
    }

    @Override
    public String getLabel() {
        return I18n.tr("Download from Overpass API", new Object[0]);
    }

    @Override
    public boolean onlyExpert() {
        return true;
    }

    static class OverpassDownloadData {
        private String query;
        private Consumer<Collection<Object>> errorReporter;

        OverpassDownloadData(String string, Consumer<Collection<Object>> consumer) {
            this.query = string;
            this.errorReporter = consumer;
        }

        String getQuery() {
            return this.query;
        }

        Consumer<Collection<Object>> getErrorReporter() {
            return this.errorReporter;
        }
    }

    public static class OverpassDownloadSourcePanel
    extends AbstractDownloadSourcePanel<OverpassDownloadData> {
        private static final String SIMPLE_NAME = "overpassdownloadpanel";
        private static final AbstractProperty<Integer> PANEL_SIZE_PROPERTY = new IntegerProperty("download.tabsplit.overpassdownloadpanel", 150).cached();
        private static final BooleanProperty OVERPASS_QUERY_LIST_OPENED = new BooleanProperty("download.overpass.query-list.opened", false);
        private static final String ACTION_IMG_SUBDIR = "dialogs";
        private JosmTextArea overpassQuery;
        private OverpassQueryList overpassQueryList;

        public OverpassDownloadSourcePanel(OverpassDownloadSource overpassDownloadSource) {
            super(overpassDownloadSource);
            this.setLayout(new BorderLayout());
            String string = I18n.tr("Build an Overpass query using the Overpass Turbo Query Wizard tool", new Object[0]);
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    new OverpassQueryWizardDialog(this).showDialog();
                }
            };
            JButton jButton = new JButton(I18n.tr("Query Wizard", new Object[0]));
            jButton.setToolTipText(string);
            jButton.addActionListener(abstractAction);
            this.overpassQuery = new JosmTextArea("/*\n" + I18n.tr("Place your Overpass query below or generate one using the Overpass Turbo Query Wizard", new Object[0]) + "\n*/", 8, 80);
            this.overpassQuery.setFont(GuiHelper.getMonospacedFont(this.overpassQuery));
            this.overpassQuery.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    overpassQuery.selectAll();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                }
            });
            this.overpassQueryList = new OverpassQueryList(this, this.overpassQuery);
            this.overpassQueryList.setPreferredSize(new Dimension(350, 300));
            EditSnippetAction editSnippetAction = new EditSnippetAction();
            RemoveSnippetAction removeSnippetAction = new RemoveSnippetAction();
            this.overpassQueryList.addSelectionListener(editSnippetAction);
            this.overpassQueryList.addSelectionListener(removeSnippetAction);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)new JLabel(I18n.tr("Your saved queries:", new Object[0])), GBC.eol().insets(2).anchor(10));
            jPanel.add((Component)this.overpassQueryList, GBC.eol().fill(1));
            jPanel.add((Component)new JButton(new AddSnippetAction()), GBC.std().fill(2));
            jPanel.add((Component)new JButton(editSnippetAction), GBC.std().fill(2));
            jPanel.add((Component)new JButton(removeSnippetAction), GBC.std().fill(2));
            jPanel.setVisible(OVERPASS_QUERY_LIST_OPENED.get());
            JScrollPane jScrollPane = new JScrollPane(this.overpassQuery);
            BasicArrowButton basicArrowButton = new BasicArrowButton(jPanel.isVisible() ? 3 : 7);
            basicArrowButton.setToolTipText(I18n.tr("Show/hide Overpass snippet list", new Object[0]));
            basicArrowButton.addActionListener(actionEvent -> {
                if (jPanel.isVisible()) {
                    jPanel.setVisible(false);
                    basicArrowButton.setDirection(7);
                    OVERPASS_QUERY_LIST_OPENED.put(Boolean.FALSE);
                } else {
                    jPanel.setVisible(true);
                    basicArrowButton.setDirection(3);
                    OVERPASS_QUERY_LIST_OPENED.put(Boolean.TRUE);
                }
            });
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jScrollPane, "Center");
            jPanel2.add((Component)basicArrowButton, "East");
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            jPanel3.add((Component)new JLabel(I18n.tr("Overpass query:", new Object[0])), GBC.eol().insets(5, 1, 5, 1).anchor(18));
            jPanel3.add((Component)new JLabel(), GBC.eol().fill(3));
            jPanel3.add((Component)jButton, GBC.eol().anchor(10));
            jPanel3.add((Component)new JLabel(), GBC.eol().fill(3));
            this.add((Component)jPanel3, "West");
            this.add((Component)jPanel2, "Center");
            this.add((Component)jPanel, "East");
            this.setMinimumSize(new Dimension(450, 240));
        }

        @Override
        public OverpassDownloadData getData() {
            String string = this.overpassQuery.getText();
            Consumer<Collection<Object>> consumer = collection -> {
                boolean bl;
                boolean bl2 = bl = collection.size() == 1 && collection.contains("No data found in this area.");
                if (collection.isEmpty() || bl) {
                    this.overpassQueryList.saveHistoricItem(string);
                }
            };
            return new OverpassDownloadData(string, consumer);
        }

        @Override
        public void rememberSettings() {
        }

        @Override
        public void restoreSettings() {
        }

        @Override
        public boolean checkDownload(DownloadSettings downloadSettings) {
            String string = this.getData().getQuery();
            if (!downloadSettings.getDownloadBounds().isPresent() && string.contains("{{bbox}}")) {
                JOptionPane.showMessageDialog(this.getParent(), I18n.tr("Please select a download area first.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
                return false;
            }
            if (string.matches("(/\\*(\\*[^/]|[^\\*/])*\\*/|\\s)*")) {
                boolean bl = ConditionalOptionPaneUtil.showConfirmationDialog("download.overpass.fix.emptytoall", this, I18n.tr("You entered an empty query. Do you want to download all data in this area instead?", new Object[0]), I18n.tr("Download all data?", new Object[0]), 0, 3, 0);
                if (bl) {
                    String string2 = "[out:xml]; \n" + string + "\n(\n    node({{bbox}});\n<;\n);\n(._;>;);out meta;";
                    this.overpassQuery.setText(string2);
                } else {
                    return false;
                }
            }
            return true;
        }

        public void setOverpassQuery(String string) {
            this.overpassQuery.setText(string);
        }

        @Override
        public Icon getIcon() {
            return ImageProvider.get("download-overpass");
        }

        @Override
        public String getSimpleName() {
            return SIMPLE_NAME;
        }

        @Override
        public DownloadSourceSizingPolicy getSizingPolicy() {
            return new DownloadSourceSizingPolicy.AdjustableDownloadSizePolicy(PANEL_SIZE_PROPERTY);
        }

        private class EditSnippetAction
        extends AbstractAction
        implements ListSelectionListener {
            EditSnippetAction() {
                this.putValue("SmallIcon", ImageProvider.get(OverpassDownloadSourcePanel.ACTION_IMG_SUBDIR, "edit"));
                this.putValue("ShortDescription", I18n.tr("Edit selected snippet", new Object[0]));
                this.checkEnabled();
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OverpassDownloadSourcePanel.this.overpassQueryList.editSelectedItem();
            }

            void checkEnabled() {
                this.setEnabled(OverpassDownloadSourcePanel.this.overpassQueryList.getSelectedItem().isPresent());
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                this.checkEnabled();
            }
        }

        private class RemoveSnippetAction
        extends AbstractAction
        implements ListSelectionListener {
            RemoveSnippetAction() {
                this.putValue("SmallIcon", ImageProvider.get(OverpassDownloadSourcePanel.ACTION_IMG_SUBDIR, "delete"));
                this.putValue("ShortDescription", I18n.tr("Delete selected snippet", new Object[0]));
                this.checkEnabled();
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OverpassDownloadSourcePanel.this.overpassQueryList.removeSelectedItem();
            }

            void checkEnabled() {
                this.setEnabled(OverpassDownloadSourcePanel.this.overpassQueryList.getSelectedItem().isPresent());
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                this.checkEnabled();
            }
        }

        private class AddSnippetAction
        extends AbstractAction {
            AddSnippetAction() {
                this.putValue("SmallIcon", ImageProvider.get(OverpassDownloadSourcePanel.ACTION_IMG_SUBDIR, "add"));
                this.putValue("ShortDescription", I18n.tr("Add new snippet", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OverpassDownloadSourcePanel.this.overpassQueryList.createNewItem();
            }
        }
    }
}

