/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.history.DiffTableModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.TagTableModel;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;
import org.openstreetmap.josm.gui.history.VersionTableModel;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.ChangeNotifier;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class HistoryBrowserModel
extends ChangeNotifier
implements MainLayerManager.ActiveLayerChangeListener,
DataSetListener {
    private History history;
    private HistoryOsmPrimitive reference;
    private HistoryOsmPrimitive current;
    private HistoryOsmPrimitive latest;
    private final VersionTableModel versionTableModel = new VersionTableModel(this);
    private final TagTableModel currentTagTableModel = new TagTableModel(this, PointInTimeType.CURRENT_POINT_IN_TIME);
    private final TagTableModel referenceTagTableModel = new TagTableModel(this, PointInTimeType.REFERENCE_POINT_IN_TIME);
    private final DiffTableModel currentRelationMemberTableModel;
    private final DiffTableModel referenceRelationMemberTableModel;
    private final DiffTableModel referenceNodeListTableModel = new DiffTableModel();
    private final DiffTableModel currentNodeListTableModel = new DiffTableModel();

    public HistoryBrowserModel() {
        OsmDataLayer osmDataLayer;
        this.currentRelationMemberTableModel = new DiffTableModel();
        this.referenceRelationMemberTableModel = new DiffTableModel();
        if (Main.main != null && (osmDataLayer = MainApplication.getLayerManager().getEditLayer()) != null) {
            osmDataLayer.data.addDataSetListener(this);
        }
        MainApplication.getLayerManager().addActiveLayerChangeListener(this);
    }

    public HistoryBrowserModel(History history) {
        this();
        CheckParameterUtil.ensureParameterNotNull(history, "history");
        this.setHistory(history);
    }

    public History getHistory() {
        return this.history;
    }

    private boolean canShowAsLatest(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null) {
            return false;
        }
        if (osmPrimitive.isNew() || !osmPrimitive.isUsable()) {
            return false;
        }
        try {
            HistoryOsmPrimitive.forOsmPrimitive(osmPrimitive);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.trace(illegalArgumentException);
            return false;
        }
        if (this.history == null) {
            return false;
        }
        if (this.history.getByVersion(osmPrimitive.getVersion()) != null) {
            return osmPrimitive.isModified();
        }
        return this.history.getLatest().getVersion() <= (long)osmPrimitive.getVersion();
    }

    public void setHistory(History history) {
        this.history = history;
        if (history.getNumVersions() > 0) {
            OsmPrimitive osmPrimitive;
            HistoryOsmPrimitive historyOsmPrimitive = null;
            OsmDataLayer osmDataLayer = MainApplication.getLayerManager().getEditLayer();
            if (osmDataLayer != null && this.canShowAsLatest(osmPrimitive = osmDataLayer.data.getPrimitiveById(history.getId(), history.getType()))) {
                historyOsmPrimitive = new HistoryPrimitiveBuilder().build(osmPrimitive);
            }
            if (historyOsmPrimitive == null) {
                this.current = history.getLatest();
                int n = history.getNumVersions() - 2;
                this.reference = n < 0 ? history.getEarliest() : history.get(n);
            } else {
                this.reference = history.getLatest();
                this.current = historyOsmPrimitive;
            }
            this.setLatest(historyOsmPrimitive);
        }
        this.initTagTableModels();
        this.fireModelChange();
    }

    private void fireModelChange() {
        this.initNodeListTableModels();
        this.initMemberListTableModels();
        this.fireStateChanged();
        this.versionTableModel.fireTableDataChanged();
    }

    public VersionTableModel getVersionTableModel() {
        return this.versionTableModel;
    }

    private void initTagTableModels() {
        this.currentTagTableModel.initKeyList();
        this.referenceTagTableModel.initKeyList();
    }

    private void initNodeListTableModels() {
        if (this.current == null || this.current.getType() != OsmPrimitiveType.WAY || this.reference == null || this.reference.getType() != OsmPrimitiveType.WAY) {
            return;
        }
        TwoColumnDiff twoColumnDiff = new TwoColumnDiff(((HistoryWay)this.reference).getNodes().toArray(), ((HistoryWay)this.current).getNodes().toArray());
        this.referenceNodeListTableModel.setRows(twoColumnDiff.referenceDiff, twoColumnDiff.referenceReversed);
        this.currentNodeListTableModel.setRows(twoColumnDiff.currentDiff, false);
    }

    private void initMemberListTableModels() {
        if (this.current == null || this.current.getType() != OsmPrimitiveType.RELATION || this.reference == null || this.reference.getType() != OsmPrimitiveType.RELATION) {
            return;
        }
        TwoColumnDiff twoColumnDiff = new TwoColumnDiff(((HistoryRelation)this.reference).getMembers().toArray(), ((HistoryRelation)this.current).getMembers().toArray());
        this.referenceRelationMemberTableModel.setRows(twoColumnDiff.referenceDiff, twoColumnDiff.referenceReversed);
        this.currentRelationMemberTableModel.setRows(twoColumnDiff.currentDiff, false);
    }

    public TagTableModel getTagTableModel(PointInTimeType pointInTimeType) {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.currentTagTableModel;
        }
        return this.referenceTagTableModel;
    }

    public DiffTableModel getNodeListTableModel(PointInTimeType pointInTimeType) {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.currentNodeListTableModel;
        }
        return this.referenceNodeListTableModel;
    }

    public DiffTableModel getRelationMemberTableModel(PointInTimeType pointInTimeType) {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.currentRelationMemberTableModel;
        }
        return this.referenceRelationMemberTableModel;
    }

    public void setReferencePointInTime(HistoryOsmPrimitive historyOsmPrimitive) {
        CheckParameterUtil.ensureParameterNotNull(historyOsmPrimitive, "reference");
        if (this.history == null) {
            throw new IllegalStateException(I18n.tr("History not initialized yet. Failed to set reference primitive.", new Object[0]));
        }
        if (historyOsmPrimitive.getId() != this.history.getId()) {
            throw new IllegalArgumentException(I18n.tr("Failed to set reference. Reference ID {0} does not match history ID {1}.", historyOsmPrimitive.getId(), this.history.getId()));
        }
        if (this.history.getByVersion(historyOsmPrimitive.getVersion()) == null) {
            throw new IllegalArgumentException(I18n.tr("Failed to set reference. Reference version {0} not available in history.", historyOsmPrimitive.getVersion()));
        }
        this.reference = historyOsmPrimitive;
        this.initTagTableModels();
        this.initNodeListTableModels();
        this.initMemberListTableModels();
        this.fireStateChanged();
    }

    public void setCurrentPointInTime(HistoryOsmPrimitive historyOsmPrimitive) {
        CheckParameterUtil.ensureParameterNotNull(historyOsmPrimitive, "current");
        if (this.history == null) {
            throw new IllegalStateException(I18n.tr("History not initialized yet. Failed to set current primitive.", new Object[0]));
        }
        if (historyOsmPrimitive.getId() != this.history.getId()) {
            throw new IllegalArgumentException(I18n.tr("Failed to set reference. Reference ID {0} does not match history ID {1}.", historyOsmPrimitive.getId(), this.history.getId()));
        }
        if (this.history.getByVersion(historyOsmPrimitive.getVersion()) == null) {
            throw new IllegalArgumentException(I18n.tr("Failed to set current primitive. Current version {0} not available in history.", historyOsmPrimitive.getVersion()));
        }
        this.current = historyOsmPrimitive;
        this.initTagTableModels();
        this.initNodeListTableModels();
        this.initMemberListTableModels();
        this.fireStateChanged();
    }

    public HistoryOsmPrimitive getCurrentPointInTime() {
        return this.getPointInTime(PointInTimeType.CURRENT_POINT_IN_TIME);
    }

    public HistoryOsmPrimitive getReferencePointInTime() {
        return this.getPointInTime(PointInTimeType.REFERENCE_POINT_IN_TIME);
    }

    public HistoryOsmPrimitive getPointInTime(PointInTimeType pointInTimeType) {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "type");
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.current;
        }
        if (pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
            return this.reference;
        }
        return null;
    }

    public boolean isLatest(HistoryOsmPrimitive historyOsmPrimitive) {
        return historyOsmPrimitive != null && historyOsmPrimitive == this.latest;
    }

    public void setReferencePointInTime(int n) {
        if (this.history == null) {
            return;
        }
        if (n == this.history.getNumVersions()) {
            if (this.latest != null) {
                this.setReferencePointInTime(this.latest);
            }
            return;
        }
        if (n < 0 || n > this.history.getNumVersions()) {
            return;
        }
        this.setReferencePointInTime(this.history.get(n));
    }

    public void setCurrentPointInTime(int n) {
        if (this.history == null) {
            return;
        }
        if (n == this.history.getNumVersions()) {
            if (this.latest != null) {
                this.setCurrentPointInTime(this.latest);
            }
            return;
        }
        if (n < 0 || n > this.history.getNumVersions()) {
            return;
        }
        this.setCurrentPointInTime(this.history.get(n));
    }

    public boolean isReferencePointInTime(int n) {
        if (this.history == null) {
            return false;
        }
        if (n == this.history.getNumVersions()) {
            return this.latest == this.reference;
        }
        if (n < 0 || n > this.history.getNumVersions()) {
            return false;
        }
        return this.history.get(n) == this.reference;
    }

    public boolean isCurrentPointInTime(int n) {
        if (this.history == null) {
            return false;
        }
        if (n == this.history.getNumVersions()) {
            return this.latest == this.current;
        }
        if (n < 0 || n > this.history.getNumVersions()) {
            return false;
        }
        return this.history.get(n) == this.current;
    }

    public HistoryOsmPrimitive getPrimitive(int n) {
        if (this.history == null) {
            return null;
        }
        return this.isLatest(n) ? this.latest : this.history.get(n);
    }

    public boolean isLatest(int n) {
        return n >= this.history.getNumVersions();
    }

    public HistoryOsmPrimitive getLatest() {
        return this.latest;
    }

    public Set<String> getKeySet() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.current != null) {
            hashSet.addAll(this.current.getTags().keySet());
        }
        if (this.reference != null) {
            hashSet.addAll(this.reference.getTags().keySet());
        }
        return hashSet;
    }

    protected void setLatest(HistoryOsmPrimitive historyOsmPrimitive) {
        if (historyOsmPrimitive == null) {
            if (this.current == this.latest) {
                HistoryOsmPrimitive historyOsmPrimitive2 = this.current = this.history != null ? this.history.getLatest() : null;
            }
            if (this.reference == this.latest) {
                this.reference = this.history != null ? this.history.getLatest() : null;
            }
            this.latest = null;
        } else {
            if (this.current == this.latest) {
                this.current = historyOsmPrimitive;
            }
            if (this.reference == this.latest) {
                this.reference = historyOsmPrimitive;
            }
            this.latest = historyOsmPrimitive;
        }
        this.fireModelChange();
    }

    public void unlinkAsListener() {
        OsmDataLayer osmDataLayer = MainApplication.getLayerManager().getEditLayer();
        if (osmDataLayer != null) {
            osmDataLayer.data.removeDataSetListener(this);
        }
        MainApplication.getLayerManager().removeActiveLayerChangeListener(this);
    }

    @Override
    public void nodeMoved(NodeMovedEvent nodeMovedEvent) {
        Node node = nodeMovedEvent.getNode();
        if (!node.isNew() && node.getId() == this.history.getId()) {
            this.setLatest(new HistoryPrimitiveBuilder().build(node));
        }
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent primitivesAddedEvent) {
        for (OsmPrimitive osmPrimitive : primitivesAddedEvent.getPrimitives()) {
            if (!this.canShowAsLatest(osmPrimitive)) continue;
            this.setLatest(new HistoryPrimitiveBuilder().build(osmPrimitive));
        }
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent primitivesRemovedEvent) {
        for (OsmPrimitive osmPrimitive : primitivesRemovedEvent.getPrimitives()) {
            if (osmPrimitive.isNew() || osmPrimitive.getId() != this.history.getId()) continue;
            this.setLatest(null);
        }
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent relationMembersChangedEvent) {
        Relation relation = relationMembersChangedEvent.getRelation();
        if (!relation.isNew() && relation.getId() == this.history.getId()) {
            this.setLatest(new HistoryPrimitiveBuilder().build(relation));
        }
    }

    @Override
    public void tagsChanged(TagsChangedEvent tagsChangedEvent) {
        OsmPrimitive osmPrimitive = tagsChangedEvent.getPrimitive();
        if (!osmPrimitive.isNew() && osmPrimitive.getId() == this.history.getId()) {
            this.setLatest(new HistoryPrimitiveBuilder().build(osmPrimitive));
        }
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent wayNodesChangedEvent) {
        Way way = wayNodesChangedEvent.getChangedWay();
        if (!way.isNew() && way.getId() == this.history.getId()) {
            this.setLatest(new HistoryPrimitiveBuilder().build(way));
        }
    }

    @Override
    public void dataChanged(DataChangedEvent dataChangedEvent) {
        if (this.history == null) {
            return;
        }
        OsmPrimitive osmPrimitive = dataChangedEvent.getDataset().getPrimitiveById(this.history.getId(), this.history.getType());
        HistoryOsmPrimitive historyOsmPrimitive = this.canShowAsLatest(osmPrimitive) ? new HistoryPrimitiveBuilder().build(osmPrimitive) : null;
        this.setLatest(historyOsmPrimitive);
        this.fireModelChange();
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent activeLayerChangeEvent) {
        Layer layer;
        Layer layer2 = activeLayerChangeEvent.getPreviousActiveLayer();
        if (layer2 instanceof OsmDataLayer) {
            layer = (OsmDataLayer)layer2;
            layer.data.removeDataSetListener(this);
        }
        if (!((layer = activeLayerChangeEvent.getSource().getActiveLayer()) instanceof OsmDataLayer)) {
            this.latest = null;
            this.fireModelChange();
            return;
        }
        Layer layer3 = layer;
        layer3.data.addDataSetListener(this);
        OsmPrimitive osmPrimitive = this.history != null ? layer3.data.getPrimitiveById(this.history.getId(), this.history.getType()) : null;
        HistoryOsmPrimitive historyOsmPrimitive = this.canShowAsLatest(osmPrimitive) ? new HistoryPrimitiveBuilder().build(osmPrimitive) : null;
        this.setLatest(historyOsmPrimitive);
        this.fireModelChange();
    }

    static class HistoryPrimitiveBuilder
    extends AbstractVisitor {
        private HistoryOsmPrimitive clone;

        HistoryPrimitiveBuilder() {
        }

        @Override
        public void visit(Node node) {
            this.clone = new HistoryNode(node.getId(), node.getVersion(), node.isVisible(), HistoryPrimitiveBuilder.getCurrentUser(), 0L, null, node.getCoor(), false);
            this.clone.setTags(node.getKeys());
        }

        @Override
        public void visit(Relation relation) {
            this.clone = new HistoryRelation(relation.getId(), (long)relation.getVersion(), relation.isVisible(), HistoryPrimitiveBuilder.getCurrentUser(), 0L, null, false);
            this.clone.setTags(relation.getKeys());
            HistoryRelation historyRelation = (HistoryRelation)this.clone;
            for (RelationMember relationMember : relation.getMembers()) {
                historyRelation.addMember(new RelationMemberData(relationMember.getRole(), relationMember.getType(), relationMember.getUniqueId()));
            }
        }

        @Override
        public void visit(Way way) {
            this.clone = new HistoryWay(way.getId(), (long)way.getVersion(), way.isVisible(), HistoryPrimitiveBuilder.getCurrentUser(), 0L, null, false);
            this.clone.setTags(way.getKeys());
            for (Node node : way.getNodes()) {
                ((HistoryWay)this.clone).addNode(node.getUniqueId());
            }
        }

        private static User getCurrentUser() {
            UserInfo userInfo = JosmUserIdentityManager.getInstance().getUserInfo();
            return userInfo == null ? User.getAnonymous() : User.createOsmUser(userInfo.getId(), userInfo.getDisplayName());
        }

        HistoryOsmPrimitive build(OsmPrimitive osmPrimitive) {
            osmPrimitive.accept(this);
            return this.clone;
        }
    }
}

