/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.layer.NoteLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.NoteReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public class NoteImporter
extends FileImporter {
    private static final ExtensionFileFilter FILE_FILTER = ExtensionFileFilter.newFilterWithArchiveExtensions("osn", "osn", I18n.tr("Note Files", new Object[0]), true);

    public NoteImporter() {
        super(FILE_FILTER);
    }

    @Override
    public void importData(File file, ProgressMonitor progressMonitor) throws IOException {
        if (Logging.isDebugEnabled()) {
            Logging.debug("importing notes file {0}", file.getAbsolutePath());
        }
        try (InputStream inputStream = Compression.getUncompressedFileInputStream(file);){
            NoteLayer noteLayer = this.loadLayer(inputStream, file, file.getName(), progressMonitor);
            if (!MainApplication.getLayerManager().containsLayer(noteLayer)) {
                MainApplication.getLayerManager().addLayer(noteLayer);
            }
        }
        catch (SAXException sAXException) {
            Logging.error("error opening up notes file");
            Logging.error(sAXException);
            throw new IOException(sAXException.getMessage(), sAXException);
        }
    }

    public NoteLayer loadLayer(InputStream inputStream, File file, String string, ProgressMonitor progressMonitor) throws SAXException, IOException {
        NoteLayer noteLayer;
        List<Note> list = new NoteReader(inputStream).parse();
        List<NoteLayer> list2 = null;
        if (MainApplication.getMap() != null) {
            list2 = MainApplication.getLayerManager().getLayersOfType(NoteLayer.class);
        }
        if (list2 != null && !list2.isEmpty()) {
            noteLayer = list2.get(0);
            noteLayer.getNoteData().addNotes(list);
        } else {
            noteLayer = new NoteLayer(list, file != null ? file.getName() : I18n.tr("Notes", new Object[0]));
        }
        return noteLayer;
    }
}

