/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.text.ParseException;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.gui.layer.geoimage.Timezone;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

public final class Offset {
    static final Offset ZERO = new Offset(0L);
    private final long milliseconds;

    private Offset(long l) {
        this.milliseconds = l;
    }

    static Offset milliseconds(long l) {
        return new Offset(l);
    }

    static Offset seconds(long l) {
        return new Offset(1000L * l);
    }

    long getMilliseconds() {
        return this.milliseconds;
    }

    long getSeconds() {
        return this.milliseconds / 1000L;
    }

    String formatOffset() {
        if (this.milliseconds % 1000L == 0L) {
            return Long.toString(this.milliseconds / 1000L);
        }
        if (this.milliseconds % 100L == 0L) {
            return String.format(Locale.ENGLISH, "%.1f", (double)this.milliseconds / 1000.0);
        }
        return String.format(Locale.ENGLISH, "%.3f", (double)this.milliseconds / 1000.0);
    }

    static Offset parseOffset(String string) throws ParseException {
        String string2 = I18n.tr("Error while parsing offset.\nExpected format: {0}", "number");
        if (!string.isEmpty()) {
            try {
                if (string.startsWith("+")) {
                    string = string.substring(1);
                }
                return Offset.milliseconds(Math.round(Double.parseDouble(string) * 1000.0));
            }
            catch (NumberFormatException numberFormatException) {
                throw (ParseException)new ParseException(string2, 0).initCause(numberFormatException);
            }
        }
        return ZERO;
    }

    int getDayOffset() {
        return (int)Math.round((double)this.getMilliseconds() / (double)TimeUnit.DAYS.toMillis(1L));
    }

    Offset withoutDayOffset() {
        return Offset.milliseconds(this.getMilliseconds() - TimeUnit.DAYS.toMillis(this.getDayOffset()));
    }

    Pair<Timezone, Offset> splitOutTimezone() {
        double d = (double)this.withoutDayOffset().getSeconds() / (double)TimeUnit.HOURS.toSeconds(1L);
        double d2 = (double)Math.round(d * 2.0) / 2.0;
        long l = Math.round((double)this.getMilliseconds() - d2 * (double)TimeUnit.HOURS.toMillis(1L));
        return Pair.create(new Timezone(d2), Offset.milliseconds(l));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Offset)) {
            return false;
        }
        Offset offset = (Offset)object;
        return this.milliseconds == offset.milliseconds;
    }

    public int hashCode() {
        return Objects.hash(this.milliseconds);
    }
}

