/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.loader.MapPaintStyleLoader;
import org.openstreetmap.josm.tools.Logging;

public interface StyleSetting {
    public void addMenuEntry(JMenu var1);

    public Object getValue();

    public static class BooleanStyleSetting
    implements StyleSetting {
        public final StyleSource parentStyle;
        public final String prefKey;
        public final String label;
        public final boolean def;

        public BooleanStyleSetting(StyleSource styleSource, String string, String string2, boolean bl) {
            this.parentStyle = styleSource;
            this.prefKey = string;
            this.label = string2;
            this.def = bl;
        }

        @Override
        public void addMenuEntry(JMenu jMenu) {
            final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
            AbstractAction abstractAction = new AbstractAction(this.label){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.setValue(jCheckBoxMenuItem.isSelected());
                    MainApplication.worker.submit(new MapPaintStyleLoader(Arrays.asList(parentStyle)));
                }
            };
            jCheckBoxMenuItem.setAction(abstractAction);
            jCheckBoxMenuItem.setSelected((Boolean)this.getValue());
            jMenu.add(jCheckBoxMenuItem);
        }

        public static BooleanStyleSetting create(Cascade cascade, StyleSource styleSource, String string) {
            String string2 = cascade.get("label", null, String.class);
            if (string2 == null) {
                Logging.warn("property 'label' required for boolean style setting");
                return null;
            }
            Boolean bl = cascade.get("default", null, Boolean.class);
            if (bl == null) {
                Logging.warn("property 'default' required for boolean style setting");
                return null;
            }
            String string3 = styleSource.url + ":boolean:" + string;
            return new BooleanStyleSetting(styleSource, string3, string2, bl);
        }

        @Override
        public Object getValue() {
            String string = Main.pref.get(this.prefKey, null);
            if (string == null) {
                return this.def;
            }
            return Boolean.valueOf(string);
        }

        public void setValue(Object object) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException();
            }
            boolean bl = (Boolean)object;
            if (bl == this.def) {
                Main.pref.put(this.prefKey, null);
            } else {
                Main.pref.put(this.prefKey, bl);
            }
        }
    }
}

