/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ButtonColumn
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor,
ActionListener {
    private final Action action;
    private final JButton renderButton;
    private final JButton editButton;
    private Object editorValue;
    private String buttonName;

    public ButtonColumn() {
        this(null);
    }

    public ButtonColumn(Action action, String string) {
        this(action);
        this.buttonName = string;
    }

    public ButtonColumn(Action action) {
        this.action = action;
        this.renderButton = new JButton();
        this.editButton = new JButton();
        this.editButton.setFocusPainted(false);
        this.editButton.addActionListener(this);
        this.editButton.setBorder(new LineBorder(Color.BLUE));
    }

    @Override
    public Object getCellEditorValue() {
        return this.editorValue;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.action.actionPerformed(actionEvent);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.editorValue = object;
        if (this.buttonName != null) {
            this.editButton.setText(this.buttonName);
            this.editButton.setIcon(null);
        } else if (object == null) {
            this.editButton.setText("");
            this.editButton.setIcon(null);
        } else if (object instanceof Icon) {
            this.editButton.setText("");
            this.editButton.setIcon((Icon)object);
        } else {
            this.editButton.setText(object.toString());
            this.editButton.setIcon(null);
        }
        this.editorValue = object;
        return this.editButton;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            this.renderButton.setForeground(jTable.getSelectionForeground());
            this.renderButton.setBackground(jTable.getSelectionBackground());
        } else {
            this.renderButton.setForeground(jTable.getForeground());
            this.renderButton.setBackground(UIManager.getColor("Button.background"));
        }
        this.renderButton.setFocusPainted(bl2);
        if (this.buttonName != null) {
            this.renderButton.setText(this.buttonName);
            this.renderButton.setIcon(null);
        } else if (object == null) {
            this.renderButton.setText("");
            this.renderButton.setIcon(null);
        } else if (object instanceof Icon) {
            this.renderButton.setText("");
            this.renderButton.setIcon((Icon)object);
        } else {
            this.renderButton.setText(object.toString());
            this.renderButton.setIcon(null);
        }
        return this.renderButton;
    }
}

