/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.gui.widgets.AbstractIdTextField;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class OsmIdTextField
extends AbstractIdTextField<OsmIdValidator> {
    public OsmIdTextField() {
        super(OsmIdValidator.class);
    }

    public void setType(OsmPrimitiveType osmPrimitiveType) {
        ((OsmIdValidator)this.validator).type = osmPrimitiveType;
    }

    public final List<PrimitiveId> getIds() {
        return new ArrayList<PrimitiveId>(((OsmIdValidator)this.validator).ids);
    }

    @Override
    public boolean readIds() {
        return ((OsmIdValidator)this.validator).readOsmIds();
    }

    public static class OsmIdValidator
    extends AbstractTextComponentValidator {
        private final List<PrimitiveId> ids = new ArrayList<PrimitiveId>();
        private OsmPrimitiveType type;

        public OsmIdValidator(JTextComponent jTextComponent) {
            super(jTextComponent, false);
        }

        @Override
        public boolean isValid() {
            return this.readOsmIds();
        }

        @Override
        public void validate() {
            if (!this.isValid()) {
                this.feedbackInvalid(I18n.tr("The current value is not a valid OSM ID. Please enter an integer value > 0", new Object[0]));
            } else {
                this.feedbackValid(I18n.tr("Please enter an integer value > 0", new Object[0]));
            }
        }

        public boolean readOsmIds() {
            String string = this.getComponent().getText();
            if (string == null || string.trim().isEmpty()) {
                return false;
            }
            this.ids.clear();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",.+/ \t\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                char c = string2.charAt(0);
                if (c == 'v') continue;
                try {
                    this.ids.addAll(SimplePrimitiveId.multipleFromString(string2));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        Logging.trace(illegalArgumentException);
                        long l = Long.parseLong(string2);
                        if (l <= 0L) {
                            return false;
                        }
                        if (this.type == OsmPrimitiveType.NODE) {
                            this.ids.add(new SimplePrimitiveId(l, OsmPrimitiveType.NODE));
                            continue;
                        }
                        if (this.type == OsmPrimitiveType.WAY || this.type == OsmPrimitiveType.CLOSEDWAY) {
                            this.ids.add(new SimplePrimitiveId(l, OsmPrimitiveType.WAY));
                            continue;
                        }
                        if (this.type == OsmPrimitiveType.RELATION || this.type == OsmPrimitiveType.MULTIPOLYGON) {
                            this.ids.add(new SimplePrimitiveId(l, OsmPrimitiveType.RELATION));
                            continue;
                        }
                        return false;
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        Logging.trace(illegalArgumentException2);
                        return false;
                    }
                }
            }
            return true;
        }
    }
}

