/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Capabilities {
    private final Map<String, Map<String, String>> capabilities = new HashMap<String, Map<String, String>>();
    private final List<String> imageryBlacklist = new ArrayList<String>();

    public boolean isDefined(String string, String string2) {
        if (!this.capabilities.containsKey(string)) {
            return false;
        }
        Map<String, String> map = this.capabilities.get(string);
        if (map == null) {
            return false;
        }
        return map.get(string2) != null;
    }

    public String get(String string, String string2) {
        if (!this.capabilities.containsKey(string)) {
            return null;
        }
        Map<String, String> map = this.capabilities.get(string);
        if (map == null) {
            return null;
        }
        return map.get(string2);
    }

    public Double getDouble(String string, String string2) {
        String string3 = this.get(string, string2);
        if (string3 == null) {
            return null;
        }
        return Double.valueOf(string3);
    }

    public Long getLong(String string, String string2) {
        String string3 = this.get(string, string2);
        if (string3 == null) {
            return null;
        }
        return Long.valueOf(string3);
    }

    public void put(String string, String string2, String string3) {
        if ("blacklist".equals(string)) {
            if ("regex".equals(string2)) {
                this.imageryBlacklist.add(string3);
            }
        } else {
            if (!this.capabilities.containsKey(string)) {
                this.capabilities.put(string, new HashMap());
            }
            this.capabilities.get(string).put(string2, string3);
        }
    }

    public final void clear() {
        this.capabilities.clear();
        this.imageryBlacklist.clear();
    }

    public boolean supportsVersion(String string) {
        String string2 = this.get("version", "minimum");
        String string3 = this.get("version", "maximum");
        return string2 != null && string3 != null && string2.compareTo(string) <= 0 && string3.compareTo(string) >= 0;
    }

    private static void warnIllegalValue(String string, String string2, Object object) {
        Logging.warn(I18n.tr("Illegal value of attribute ''{0}'' of element ''{1}'' in server capabilities. Got ''{2}''", string, string2, object));
    }

    public int getMaxChangesetSize() {
        String string = this.get("changesets", "maximum_elements");
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                if (n > 0) {
                    return n;
                }
                Capabilities.warnIllegalValue("changesets", "maximum_elements", n);
            }
            catch (NumberFormatException numberFormatException) {
                Capabilities.warnIllegalValue("changesets", "maximum_elements", string);
            }
        }
        return -1;
    }

    public long getMaxWayNodes() {
        String string = this.get("waynodes", "maximum");
        if (string != null) {
            try {
                long l = Long.parseLong(string);
                if (l > 0L) {
                    return l;
                }
                Capabilities.warnIllegalValue("waynodes", "maximum", l);
            }
            catch (NumberFormatException numberFormatException) {
                Capabilities.warnIllegalValue("waynodes", "maximum", string);
            }
        }
        return -1L;
    }

    public boolean isOnImageryBlacklist(String string) {
        if (string != null && this.imageryBlacklist != null) {
            for (String string2 : this.imageryBlacklist) {
                if (!string.matches(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getImageryBlacklist() {
        return Collections.unmodifiableList(this.imageryBlacklist);
    }

    public static final class CapabilitiesParser
    extends DefaultHandler {
        private Capabilities capabilities;

        @Override
        public void startDocument() {
            this.capabilities = new Capabilities();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.capabilities.put(string3, attributes.getQName(i), attributes.getValue(i));
            }
        }

        public Capabilities getCapabilities() {
            return this.capabilities;
        }

        public static Capabilities parse(InputSource inputSource) throws SAXException, IOException, ParserConfigurationException {
            CapabilitiesParser capabilitiesParser = new CapabilitiesParser();
            Utils.parseSafeSAX(inputSource, capabilitiesParser);
            return capabilitiesParser.getCapabilities();
        }
    }
}

