/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.audio;

import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.openstreetmap.josm.io.audio.AudioException;
import org.openstreetmap.josm.io.audio.AudioListener;
import org.openstreetmap.josm.io.audio.AudioPlayer;
import org.openstreetmap.josm.io.audio.SoundPlayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

class JavaSoundPlayer
implements SoundPlayer {
    private static int chunk = 4000;
    private AudioInputStream audioInputStream;
    private SourceDataLine audioOutputLine;
    private final double leadIn;
    private final double calibration;
    private double bytesPerSecond;
    private final byte[] abData = new byte[chunk];
    private double position;
    private double speed = 1.0;
    private final ListenerList<AudioListener> listeners = ListenerList.create();

    JavaSoundPlayer(double d, double d2) {
        this.leadIn = d;
        this.calibration = d2;
    }

    @Override
    public void play(AudioPlayer.Execute execute, AudioPlayer.State state, URL uRL) throws AudioException, IOException {
        URL uRL2 = execute.url();
        double d = execute.offset();
        this.speed = execute.speed();
        if (uRL != uRL2 || state != AudioPlayer.State.PAUSED || d != 0.0) {
            if (this.audioInputStream != null) {
                Utils.close(this.audioInputStream);
            }
            this.listeners.fireEvent(audioListener -> audioListener.playing(uRL2));
            try {
                this.audioInputStream = AudioSystem.getAudioInputStream(uRL2);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                throw new AudioException(unsupportedAudioFileException);
            }
            AudioFormat audioFormat = this.audioInputStream.getFormat();
            this.position = 0.0;
            double d2 = (d -= this.leadIn) * this.calibration;
            this.bytesPerSecond = audioFormat.getFrameRate() * (float)audioFormat.getFrameSize();
            if (this.speed * this.bytesPerSecond > 256000.0) {
                this.speed = 256000.0 / this.bytesPerSecond;
            }
            if (d2 > 0.0) {
                long l;
                long l2;
                for (l = (long)(d2 * this.bytesPerSecond); l > (long)chunk; l -= l2) {
                    l2 = this.audioInputStream.skip(chunk);
                    if (l2 > 0L) continue;
                    throw new IOException(I18n.tr("This is after the end of the recording", new Object[0]));
                }
                while (l > 0L) {
                    long l3 = this.audioInputStream.skip(l);
                    l -= l3;
                    if (l3 != 0L) continue;
                    Logging.warn("Unable to skip bytes from audio input stream");
                    l = 0L;
                }
                this.position = d;
            }
            if (this.audioOutputLine != null) {
                this.audioOutputLine.close();
            }
            audioFormat = new AudioFormat(audioFormat.getEncoding(), audioFormat.getSampleRate() * (float)(this.speed * this.calibration), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate() * (float)(this.speed * this.calibration), audioFormat.isBigEndian());
            try {
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
                this.audioOutputLine = (SourceDataLine)AudioSystem.getLine(info);
                this.audioOutputLine.open(audioFormat);
                this.audioOutputLine.start();
            }
            catch (LineUnavailableException lineUnavailableException) {
                throw new AudioException(lineUnavailableException);
            }
        }
    }

    @Override
    public void pause(AudioPlayer.Execute execute, AudioPlayer.State state, URL uRL) throws AudioException, IOException {
    }

    @Override
    public boolean playing(AudioPlayer.Execute execute) throws AudioException, IOException, InterruptedException {
        while (true) {
            int n = 0;
            if (this.audioInputStream != null) {
                n = this.audioInputStream.read(this.abData, 0, this.abData.length);
                this.position += (double)n / this.bytesPerSecond;
            }
            execute.possiblyInterrupt();
            if (n < 0 || this.audioInputStream == null || this.audioOutputLine == null) break;
            this.audioOutputLine.write(this.abData, 0, n);
            execute.possiblyInterrupt();
        }
        if (this.audioOutputLine != null) {
            this.audioOutputLine.drain();
            this.audioOutputLine.close();
        }
        this.audioOutputLine = null;
        Utils.close(this.audioInputStream);
        this.audioInputStream = null;
        this.speed = 0.0;
        return true;
    }

    @Override
    public double position() {
        return this.position;
    }

    @Override
    public double speed() {
        return this.speed;
    }

    @Override
    public void addAudioListener(AudioListener audioListener) {
        this.listeners.addWeakListener(audioListener);
    }
}

