/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.tools.Logging;

public class PluginClassLoader
extends URLClassLoader {
    Collection<PluginClassLoader> dependencies;

    public PluginClassLoader(URL[] uRLArray, ClassLoader classLoader, Collection<PluginClassLoader> collection) {
        super(uRLArray, classLoader);
        this.dependencies = collection == null ? new ArrayList<PluginClassLoader>() : new ArrayList<PluginClassLoader>(collection);
    }

    public void addDependency(PluginClassLoader pluginClassLoader) {
        this.dependencies.add(pluginClassLoader);
    }

    @Override
    protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        for (PluginClassLoader pluginClassLoader : this.dependencies) {
            try {
                Class<?> clazz = pluginClassLoader.loadClass(string, bl);
                if (clazz == null) continue;
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logging.trace("Plugin class not found in {0}: {1}", pluginClassLoader, classNotFoundException.getMessage());
            }
        }
        Class<?> clazz = super.loadClass(string, bl);
        if (clazz != null) {
            return clazz;
        }
        throw new ClassNotFoundException(string);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

