/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlParsingException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class XmlObjectParser
implements Iterable<Object> {
    public static final String lang = LanguageInfo.getLanguageCodeXML();
    private final Map<String, Entry> mapping = new HashMap<String, Entry>();
    private final DefaultHandler parser;
    private final List<Object> queue = new LinkedList<Object>();
    private Iterator<Object> queueIterator;

    public XmlObjectParser() {
        this.parser = new Parser();
    }

    private Iterable<Object> start(Reader reader, ContentHandler contentHandler) throws SAXException, IOException {
        try {
            XMLReader xMLReader = Utils.newSafeSAXParser().getXMLReader();
            xMLReader.setContentHandler(contentHandler);
            try {
                xMLReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (SAXException sAXException) {
                Logging.log(Logging.LEVEL_ERROR, "Cannot disable 'load-external-dtd' feature:", sAXException);
            }
            xMLReader.parse(new InputSource(reader));
            this.queueIterator = this.queue.iterator();
            return this;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JosmRuntimeException(parserConfigurationException);
        }
    }

    public Iterable<Object> start(Reader reader) throws SAXException {
        try {
            return this.start(reader, this.parser);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    /*
     * Exception decompiling
     */
    public Iterable<Object> startWithValidation(Reader var1_1, String var2_2, String var3_3) throws SAXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void map(String string, Class<?> clazz) {
        this.mapping.put(string, new Entry(clazz, false, false));
    }

    public void mapOnStart(String string, Class<?> clazz) {
        this.mapping.put(string, new Entry(clazz, true, false));
    }

    public void mapBoth(String string, Class<?> clazz) {
        this.mapping.put(string, new Entry(clazz, false, true));
    }

    public Object next() {
        return this.queueIterator.next();
    }

    public boolean hasNext() {
        return this.queueIterator.hasNext();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.queue.iterator();
    }

    private static class Entry {
        private final Class<?> klass;
        private final boolean onStart;
        private final boolean both;
        private final Map<String, Field> fields = new HashMap<String, Field>();
        private final Map<String, Method> methods = new HashMap<String, Method>();

        Entry(Class<?> clazz, boolean bl, boolean bl2) {
            this.klass = clazz;
            this.onStart = bl;
            this.both = bl2;
        }

        Field getField(String string) {
            if (this.fields.containsKey(string)) {
                return this.fields.get(string);
            }
            try {
                Field field = this.klass.getField(string);
                this.fields.put(string, field);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Logging.trace(noSuchFieldException);
                this.fields.put(string, null);
                return null;
            }
        }

        Method getMethod(String string) {
            if (this.methods.containsKey(string)) {
                return this.methods.get(string);
            }
            for (Method method : this.klass.getMethods()) {
                if (!method.getName().equals(string) || method.getParameterTypes().length != 1) continue;
                this.methods.put(string, method);
                return method;
            }
            this.methods.put(string, null);
            return null;
        }
    }

    private class Parser
    extends DefaultHandler {
        private final Stack<Object> current = new Stack();
        private StringBuilder characters = new StringBuilder(64);
        private Locator locator;

        private Parser() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(Exception exception) throws XmlParsingException {
            throw new XmlParsingException(exception).rememberLocation(this.locator);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (XmlObjectParser.this.mapping.containsKey(string3)) {
                Class clazz = ((Entry)XmlObjectParser.this.mapping.get(string3)).klass;
                try {
                    this.current.push(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    this.throwException(reflectiveOperationException);
                }
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.setValue((Entry)XmlObjectParser.this.mapping.get(string3), attributes.getQName(i), attributes.getValue(i));
                }
                if (((Entry)XmlObjectParser.this.mapping.get(string3)).onStart) {
                    this.report();
                }
                if (((Entry)XmlObjectParser.this.mapping.get(string3)).both) {
                    XmlObjectParser.this.queue.add(this.current.peek());
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (XmlObjectParser.this.mapping.containsKey(string3) && !((Entry)XmlObjectParser.this.mapping.get(string3)).onStart) {
                this.report();
            } else if (XmlObjectParser.this.mapping.containsKey(string3) && this.characters != null && !this.current.isEmpty()) {
                this.setValue((Entry)XmlObjectParser.this.mapping.get(string3), string3, this.characters.toString().trim());
                this.characters = new StringBuilder(64);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            this.characters.append(cArray, n, n2);
        }

        private void report() {
            XmlObjectParser.this.queue.add(this.current.pop());
            this.characters = new StringBuilder(64);
        }

        private Object getValueForClass(Class<?> clazz, String string) {
            if (clazz == Boolean.TYPE) {
                return this.parseBoolean(string);
            }
            if (clazz == Integer.TYPE || clazz == Long.TYPE) {
                return Long.valueOf(string);
            }
            if (clazz == Float.TYPE || clazz == Double.TYPE) {
                return Double.valueOf(string);
            }
            return string;
        }

        private void setValue(Entry entry, String string, String string2) throws SAXException {
            CheckParameterUtil.ensureParameterNotNull(entry, "entry");
            if ("class".equals(string) || "default".equals(string) || "throw".equals(string) || "new".equals(string) || "null".equals(string)) {
                string = string + '_';
            }
            try {
                Object object = this.current.peek();
                Field field = entry.getField(string);
                if (field == null && string.startsWith(lang)) {
                    field = entry.getField("locale_" + string.substring(lang.length()));
                }
                if (field != null && Modifier.isPublic(field.getModifiers()) && (String.class.equals(field.getType()) || Boolean.TYPE.equals(field.getType()))) {
                    field.set(object, this.getValueForClass(field.getType(), string2));
                } else {
                    if (string.startsWith(lang)) {
                        int n = lang.length();
                        string = "set" + string.substring(n, n + 1).toUpperCase(Locale.ENGLISH) + string.substring(n + 1);
                    } else {
                        string = "set" + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
                    }
                    Method method = entry.getMethod(string);
                    if (method != null) {
                        method.invoke(object, this.getValueForClass(method.getParameterTypes()[0], string2));
                    }
                }
            }
            catch (IllegalArgumentException | ReflectiveOperationException exception) {
                Logging.error(exception);
                this.throwException(exception);
            }
        }

        private boolean parseBoolean(String string) {
            return string != null && !"0".equals(string) && !string.startsWith("off") && !string.startsWith("false") && !string.startsWith("no");
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            this.throwException(sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.throwException(sAXParseException);
        }
    }

    private static class AddNamespaceFilter
    extends XMLFilterImpl {
        private final String namespace;

        AddNamespaceFilter(String string) {
            this.namespace = string;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("".equals(string)) {
                super.startElement(this.namespace, string2, string3, attributes);
            } else {
                super.startElement(string, string2, string3, attributes);
            }
        }
    }
}

