/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.JavadocFieldReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.jdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class Javadoc
extends ASTNode {
    public JavadocSingleNameReference[] paramReferences;
    public JavadocSingleTypeReference[] paramTypeParameters;
    public TypeReference[] exceptionReferences;
    public JavadocReturnStatement returnStatement;
    public Expression[] seeReferences;
    public long[] inheritedPositions = null;
    public JavadocSingleNameReference[] invalidParameters;
    public long valuePositions = -1L;

    public Javadoc(int n, int n2) {
        this.sourceStart = n;
        this.sourceEnd = n2;
        this.bits |= 0x10000;
    }

    boolean canBeSeen(int n, int n2) {
        if (n2 < 0) {
            return true;
        }
        switch (n2 & 7) {
            case 1: {
                return true;
            }
            case 4: {
                return n != 1;
            }
            case 0: {
                return n == 0 || n == 2;
            }
            case 2: {
                return n == 2;
            }
        }
        return true;
    }

    public ASTNode getNodeStartingAt(int n) {
        int n2 = 0;
        if (this.paramReferences != null) {
            for (JavadocSingleNameReference expression2 : this.paramReferences) {
                if (expression2.sourceStart != n) continue;
                return expression2;
            }
        }
        if (this.invalidParameters != null) {
            for (JavadocSingleNameReference javadocSingleNameReference : this.invalidParameters) {
                if (javadocSingleNameReference.sourceStart != n) continue;
                return javadocSingleNameReference;
            }
        }
        if (this.paramTypeParameters != null) {
            for (JavadocSingleTypeReference javadocSingleTypeReference : this.paramTypeParameters) {
                if (javadocSingleTypeReference.sourceStart != n) continue;
                return javadocSingleTypeReference;
            }
        }
        if (this.exceptionReferences != null) {
            for (TypeReference typeReference : this.exceptionReferences) {
                if (typeReference.sourceStart != n) continue;
                return typeReference;
            }
        }
        if (this.seeReferences != null) {
            n2 = this.seeReferences.length;
            for (int i = 0; i < n2; ++i) {
                int n3;
                int n4;
                Expression expression;
                Expression expression2 = this.seeReferences[i];
                if (expression2.sourceStart == n) {
                    return expression2;
                }
                if (expression2 instanceof JavadocAllocationExpression) {
                    expression = (JavadocAllocationExpression)this.seeReferences[i];
                    if (expression.binding == null || !expression.binding.isValidBinding() || expression.arguments == null) continue;
                    n4 = expression.arguments.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        if (expression.arguments[n3].sourceStart != n) continue;
                        return expression.arguments[n3];
                    }
                    continue;
                }
                if (!(expression2 instanceof JavadocMessageSend)) continue;
                expression = (JavadocMessageSend)this.seeReferences[i];
                if (((JavadocMessageSend)expression).binding == null || !((JavadocMessageSend)expression).binding.isValidBinding() || ((JavadocMessageSend)expression).arguments == null) continue;
                n4 = ((JavadocMessageSend)expression).arguments.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    if (((JavadocMessageSend)expression).arguments[n3].sourceStart != n) continue;
                    return ((JavadocMessageSend)expression).arguments[n3];
                }
            }
        }
        return null;
    }

    @Override
    public StringBuffer print(int n, StringBuffer stringBuffer) {
        int n2;
        int n3;
        Javadoc.printIndent(n, stringBuffer).append("/**\n");
        if (this.paramReferences != null) {
            n3 = this.paramReferences.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Javadoc.printIndent(n + 1, stringBuffer).append(" * @param ");
                this.paramReferences[n2].print(n, stringBuffer).append('\n');
            }
        }
        if (this.paramTypeParameters != null) {
            n3 = this.paramTypeParameters.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Javadoc.printIndent(n + 1, stringBuffer).append(" * @param <");
                this.paramTypeParameters[n2].print(n, stringBuffer).append(">\n");
            }
        }
        if (this.returnStatement != null) {
            Javadoc.printIndent(n + 1, stringBuffer).append(" * @");
            this.returnStatement.print(n, stringBuffer).append('\n');
        }
        if (this.exceptionReferences != null) {
            n3 = this.exceptionReferences.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Javadoc.printIndent(n + 1, stringBuffer).append(" * @throws ");
                this.exceptionReferences[n2].print(n, stringBuffer).append('\n');
            }
        }
        if (this.seeReferences != null) {
            n3 = this.seeReferences.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Javadoc.printIndent(n + 1, stringBuffer).append(" * @see ");
                this.seeReferences[n2].print(n, stringBuffer).append('\n');
            }
        }
        Javadoc.printIndent(n, stringBuffer).append(" */\n");
        return stringBuffer;
    }

    public void resolve(ClassScope classScope) {
        int n;
        int n2;
        int n3;
        int n4;
        if ((this.bits & 0x10000) == 0) {
            return;
        }
        if (this.inheritedPositions != null) {
            n4 = this.inheritedPositions.length;
            for (n3 = 0; n3 < n4; ++n3) {
                int n5 = (int)(this.inheritedPositions[n3] >>> 32);
                int n6 = (int)this.inheritedPositions[n3];
                classScope.problemReporter().javadocUnexpectedTag(n5, n6);
            }
        }
        n4 = this.paramReferences == null ? 0 : this.paramReferences.length;
        for (n3 = 0; n3 < n4; ++n3) {
            JavadocSingleNameReference javadocSingleNameReference = this.paramReferences[n3];
            classScope.problemReporter().javadocUnexpectedTag(javadocSingleNameReference.tagSourceStart, javadocSingleNameReference.tagSourceEnd);
        }
        this.resolveTypeParameterTags(classScope, true);
        if (this.returnStatement != null) {
            classScope.problemReporter().javadocUnexpectedTag(this.returnStatement.sourceStart, this.returnStatement.sourceEnd);
        }
        n3 = this.exceptionReferences == null ? 0 : this.exceptionReferences.length;
        for (n2 = 0; n2 < n3; ++n2) {
            int n7;
            int n8;
            TypeReference typeReference;
            TypeReference typeReference2 = this.exceptionReferences[n2];
            if (typeReference2 instanceof JavadocSingleTypeReference) {
                typeReference = (JavadocSingleTypeReference)typeReference2;
                n8 = typeReference.tagSourceStart;
                n7 = typeReference.tagSourceEnd;
            } else if (typeReference2 instanceof JavadocQualifiedTypeReference) {
                typeReference = (JavadocQualifiedTypeReference)typeReference2;
                n8 = ((JavadocQualifiedTypeReference)typeReference).tagSourceStart;
                n7 = ((JavadocQualifiedTypeReference)typeReference).tagSourceEnd;
            } else {
                n8 = typeReference2.sourceStart;
                n7 = typeReference2.sourceEnd;
            }
            classScope.problemReporter().javadocUnexpectedTag(n8, n7);
        }
        n2 = this.seeReferences == null ? 0 : this.seeReferences.length;
        for (n = 0; n < n2; ++n) {
            this.resolveReference(this.seeReferences[n], classScope);
        }
        int n9 = n = classScope.compilerOptions().sourceLevel >= 0x310000L ? 1 : 0;
        if (n == 0 && this.valuePositions != -1L) {
            classScope.problemReporter().javadocUnexpectedTag((int)(this.valuePositions >>> 32), (int)this.valuePositions);
        }
    }

    public void resolve(CompilationUnitScope compilationUnitScope) {
        if ((this.bits & 0x10000) == 0) {
            return;
        }
    }

    public void resolve(MethodScope methodScope) {
        boolean bl;
        int n;
        if ((this.bits & 0x10000) == 0) {
            return;
        }
        AbstractMethodDeclaration abstractMethodDeclaration = methodScope.referenceMethod();
        boolean bl2 = abstractMethodDeclaration == null || abstractMethodDeclaration.binding == null ? false : !abstractMethodDeclaration.binding.isStatic() && (abstractMethodDeclaration.binding.modifiers & 0x30000000) != 0;
        int n2 = this.seeReferences == null ? 0 : this.seeReferences.length;
        boolean bl3 = false;
        for (n = 0; n < n2; n += 1) {
            MethodBinding methodBinding;
            ReferenceBinding referenceBinding;
            TypeBinding typeBinding;
            Expression expression;
            this.resolveReference(this.seeReferences[n], methodScope);
            if (abstractMethodDeclaration == null || bl3) continue;
            if (!abstractMethodDeclaration.isConstructor()) {
                if (!bl2 || !(this.seeReferences[n] instanceof JavadocMessageSend)) continue;
                expression = (JavadocMessageSend)this.seeReferences[n];
                if (((JavadocMessageSend)expression).binding == null || !((JavadocMessageSend)expression).binding.isValidBinding() || !(((JavadocMessageSend)expression).actualReceiverType instanceof ReferenceBinding) || (typeBinding = abstractMethodDeclaration.binding.declaringClass.findSuperTypeOriginatingFrom(referenceBinding = (ReferenceBinding)((JavadocMessageSend)expression).actualReceiverType)) == null || !TypeBinding.notEquals(typeBinding.original(), abstractMethodDeclaration.binding.declaringClass) || !CharOperation.equals(((JavadocMessageSend)expression).selector, abstractMethodDeclaration.selector) || !methodScope.environment().methodVerifier().doesMethodOverride(abstractMethodDeclaration.binding, ((JavadocMessageSend)expression).binding.original())) continue;
                bl3 = true;
                continue;
            }
            if (!(this.seeReferences[n] instanceof JavadocAllocationExpression)) continue;
            expression = (JavadocAllocationExpression)this.seeReferences[n];
            if (expression.binding == null || !expression.binding.isValidBinding() || (typeBinding = (ReferenceBinding)abstractMethodDeclaration.binding.declaringClass.findSuperTypeOriginatingFrom(referenceBinding = (ReferenceBinding)expression.resolvedType.original())) == null || !TypeBinding.notEquals(typeBinding.original(), abstractMethodDeclaration.binding.declaringClass) || !(methodBinding = methodScope.getConstructor((ReferenceBinding)typeBinding, abstractMethodDeclaration.binding.parameters, (InvocationSite)((Object)expression))).isValidBinding() || methodBinding.original() != expression.binding.original()) continue;
            MethodBinding methodBinding2 = abstractMethodDeclaration.binding;
            if (methodScope.compilerOptions().sourceLevel >= 0x340000L && methodBinding2.typeVariables != Binding.NO_TYPE_VARIABLES) {
                methodBinding2 = methodBinding2.asRawMethod(methodScope.environment());
            }
            if (!methodBinding.areParametersEqual(methodBinding2)) continue;
            bl3 = true;
        }
        if (!bl3 && abstractMethodDeclaration != null && abstractMethodDeclaration.annotations != null) {
            n = abstractMethodDeclaration.annotations.length;
            for (int i = 0; i < n && !bl3; i += 1) {
                bl3 = (abstractMethodDeclaration.binding.tagBits & 0x2000000000000L) != 0L;
            }
        }
        int n3 = n = abstractMethodDeclaration == null || (!bl2 || this.inheritedPositions == null) && !bl3 && (abstractMethodDeclaration.binding.declaringClass == null || !abstractMethodDeclaration.binding.declaringClass.isLocalType()) ? 1 : 0;
        if (!bl2 && this.inheritedPositions != null) {
            int n4 = this.inheritedPositions.length;
            for (int i = 0; i < n4; ++i) {
                int n5 = (int)(this.inheritedPositions[i] >>> 32);
                int n6 = (int)this.inheritedPositions[i];
                methodScope.problemReporter().javadocUnexpectedTag(n5, n6);
            }
        }
        CompilerOptions compilerOptions = methodScope.compilerOptions();
        this.resolveParamTags(methodScope, n != 0, compilerOptions.reportUnusedParameterIncludeDocCommentReference);
        this.resolveTypeParameterTags(methodScope, n != 0 && compilerOptions.reportMissingJavadocTagsMethodTypeParameters);
        if (this.returnStatement == null) {
            if (n && abstractMethodDeclaration != null && abstractMethodDeclaration.isMethod()) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)abstractMethodDeclaration;
                if (methodDeclaration.binding.returnType != TypeBinding.VOID) {
                    methodScope.problemReporter().javadocMissingReturnTag(methodDeclaration.returnType.sourceStart, methodDeclaration.returnType.sourceEnd, abstractMethodDeclaration.binding.modifiers);
                }
            }
        } else {
            this.returnStatement.resolve(methodScope);
        }
        this.resolveThrowsTags(methodScope, n != 0);
        boolean bl4 = bl = compilerOptions.sourceLevel >= 0x310000L;
        if (!bl && abstractMethodDeclaration != null && this.valuePositions != -1L) {
            methodScope.problemReporter().javadocUnexpectedTag((int)(this.valuePositions >>> 32), (int)this.valuePositions);
        }
        int n7 = this.invalidParameters == null ? 0 : this.invalidParameters.length;
        for (int i = 0; i < n7; ++i) {
            this.invalidParameters[i].resolve(methodScope, false, false);
        }
    }

    private void resolveReference(Expression expression, Scope scope) {
        Object object;
        int n = scope.referenceContext().compilationResult().problemCount;
        switch (scope.kind) {
            case 2: {
                expression.resolveType((MethodScope)scope);
                break;
            }
            case 3: {
                expression.resolveType((ClassScope)scope);
            }
        }
        boolean bl = scope.referenceContext().compilationResult().problemCount > n;
        boolean bl2 = scope.compilerOptions().sourceLevel >= 0x310000L;
        int n2 = -1;
        if (expression instanceof JavadocFieldReference) {
            ReferenceBinding referenceBinding;
            JavadocFieldReference javadocFieldReference = (JavadocFieldReference)expression;
            if (javadocFieldReference.methodBinding != null) {
                if (javadocFieldReference.tagValue == 10) {
                    if (n2 == -1) {
                        n2 = scope.getDeclarationModifiers();
                    }
                    scope.problemReporter().javadocInvalidValueReference(javadocFieldReference.sourceStart, javadocFieldReference.sourceEnd, n2);
                } else if (javadocFieldReference.actualReceiverType != null) {
                    if (scope.enclosingSourceType().isCompatibleWith(javadocFieldReference.actualReceiverType)) {
                        javadocFieldReference.bits |= 0x4000;
                    }
                    javadocFieldReference.methodBinding = CharOperation.equals((referenceBinding = (ReferenceBinding)javadocFieldReference.actualReceiverType).sourceName(), javadocFieldReference.token) ? scope.getConstructor(referenceBinding, Binding.NO_TYPES, javadocFieldReference) : scope.findMethod(referenceBinding, javadocFieldReference.token, Binding.NO_TYPES, javadocFieldReference, false);
                }
            } else if (bl2 && javadocFieldReference.binding != null && javadocFieldReference.binding.isValidBinding() && javadocFieldReference.tagValue == 10 && !javadocFieldReference.binding.isStatic()) {
                if (n2 == -1) {
                    n2 = scope.getDeclarationModifiers();
                }
                scope.problemReporter().javadocInvalidValueReference(javadocFieldReference.sourceStart, javadocFieldReference.sourceEnd, n2);
            }
            if (!bl && javadocFieldReference.binding != null && javadocFieldReference.binding.isValidBinding() && javadocFieldReference.actualReceiverType instanceof ReferenceBinding) {
                referenceBinding = (ReferenceBinding)javadocFieldReference.actualReceiverType;
                this.verifyTypeReference(javadocFieldReference, javadocFieldReference.receiver, scope, bl2, referenceBinding, javadocFieldReference.binding.modifiers);
            }
            return;
        }
        if (!bl && (expression instanceof JavadocSingleTypeReference || expression instanceof JavadocQualifiedTypeReference) && expression.resolvedType instanceof ReferenceBinding) {
            object = (ReferenceBinding)expression.resolvedType;
            this.verifyTypeReference(expression, expression, scope, bl2, (ReferenceBinding)object, ((ReferenceBinding)object).modifiers);
        }
        if (expression instanceof JavadocMessageSend) {
            object = (JavadocMessageSend)expression;
            if (bl2 && ((JavadocMessageSend)object).tagValue == 10) {
                if (n2 == -1) {
                    n2 = scope.getDeclarationModifiers();
                }
                scope.problemReporter().javadocInvalidValueReference(((JavadocMessageSend)object).sourceStart, ((JavadocMessageSend)object).sourceEnd, n2);
            }
            if (!bl && ((JavadocMessageSend)object).binding != null && ((JavadocMessageSend)object).binding.isValidBinding() && ((JavadocMessageSend)object).actualReceiverType instanceof ReferenceBinding) {
                ReferenceBinding referenceBinding = (ReferenceBinding)((JavadocMessageSend)object).actualReceiverType;
                this.verifyTypeReference((Expression)object, ((JavadocMessageSend)object).receiver, scope, bl2, referenceBinding, ((JavadocMessageSend)object).binding.modifiers);
            }
        } else if (expression instanceof JavadocAllocationExpression) {
            object = (JavadocAllocationExpression)expression;
            if (bl2 && ((JavadocAllocationExpression)object).tagValue == 10) {
                if (n2 == -1) {
                    n2 = scope.getDeclarationModifiers();
                }
                scope.problemReporter().javadocInvalidValueReference(((JavadocAllocationExpression)object).sourceStart, ((JavadocAllocationExpression)object).sourceEnd, n2);
            }
            if (!bl && ((JavadocAllocationExpression)object).binding != null && ((JavadocAllocationExpression)object).binding.isValidBinding() && ((JavadocAllocationExpression)object).resolvedType instanceof ReferenceBinding) {
                ReferenceBinding referenceBinding = (ReferenceBinding)((JavadocAllocationExpression)object).resolvedType;
                this.verifyTypeReference((Expression)object, ((JavadocAllocationExpression)object).type, scope, bl2, referenceBinding, ((JavadocAllocationExpression)object).binding.modifiers);
            }
        } else if (expression instanceof JavadocSingleTypeReference && expression.resolvedType != null && expression.resolvedType.isTypeVariable()) {
            scope.problemReporter().javadocInvalidReference(expression.sourceStart, expression.sourceEnd);
        }
    }

    private void resolveParamTags(MethodScope methodScope, boolean bl, boolean bl2) {
        block9: {
            int n;
            boolean bl3;
            Statement statement;
            int n2;
            int n3;
            int n4;
            AbstractMethodDeclaration abstractMethodDeclaration;
            block8: {
                abstractMethodDeclaration = methodScope.referenceMethod();
                int n5 = n4 = this.paramReferences == null ? 0 : this.paramReferences.length;
                if (abstractMethodDeclaration == null) {
                    for (int i = 0; i < n4; ++i) {
                        JavadocSingleNameReference javadocSingleNameReference = this.paramReferences[i];
                        methodScope.problemReporter().javadocUnexpectedTag(javadocSingleNameReference.tagSourceStart, javadocSingleNameReference.tagSourceEnd);
                    }
                    return;
                }
                int n6 = n3 = abstractMethodDeclaration.arguments == null ? 0 : abstractMethodDeclaration.arguments.length;
                if (n4 != 0) break block8;
                if (!bl) break block9;
                for (int i = 0; i < n3; ++i) {
                    Argument argument = abstractMethodDeclaration.arguments[i];
                    methodScope.problemReporter().javadocMissingParamTag(argument.name, argument.sourceStart, argument.sourceEnd, abstractMethodDeclaration.binding.modifiers);
                }
                break block9;
            }
            LocalVariableBinding[] localVariableBindingArray = new LocalVariableBinding[n4];
            int n7 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                statement = this.paramReferences[n2];
                statement.resolve(methodScope, true, bl2);
                if (statement.binding == null || !statement.binding.isValidBinding()) continue;
                bl3 = false;
                for (n = 0; n < n7 && !bl3; ++n) {
                    if (localVariableBindingArray[n] != statement.binding) continue;
                    methodScope.problemReporter().javadocDuplicatedParamTag(statement.token, statement.sourceStart, statement.sourceEnd, abstractMethodDeclaration.binding.modifiers);
                    bl3 = true;
                }
                if (bl3) continue;
                localVariableBindingArray[n7++] = (LocalVariableBinding)statement.binding;
            }
            if (bl) {
                for (n2 = 0; n2 < n3; ++n2) {
                    statement = abstractMethodDeclaration.arguments[n2];
                    bl3 = false;
                    for (n = 0; n < n7 && !bl3; ++n) {
                        LocalVariableBinding localVariableBinding = localVariableBindingArray[n];
                        if (((Argument)statement).binding != localVariableBinding) continue;
                        bl3 = true;
                    }
                    if (bl3) continue;
                    methodScope.problemReporter().javadocMissingParamTag(((Argument)statement).name, ((Argument)statement).sourceStart, ((Argument)statement).sourceEnd, abstractMethodDeclaration.binding.modifiers);
                }
            }
        }
    }

    private void resolveTypeParameterTags(Scope scope, boolean bl) {
        block17: {
            int n;
            TypeVariableBinding[] typeVariableBindingArray;
            int n2;
            TypeVariableBinding[] typeVariableBindingArray2;
            TypeParameter[] typeParameterArray;
            int n3;
            block18: {
                n3 = this.paramTypeParameters == null ? 0 : this.paramTypeParameters.length;
                typeParameterArray = null;
                typeVariableBindingArray2 = null;
                n2 = -1;
                switch (scope.kind) {
                    case 2: {
                        AbstractMethodDeclaration abstractMethodDeclaration = ((MethodScope)scope).referenceMethod();
                        if (abstractMethodDeclaration == null) {
                            for (int i = 0; i < n3; ++i) {
                                JavadocSingleTypeReference javadocSingleTypeReference = this.paramTypeParameters[i];
                                scope.problemReporter().javadocUnexpectedTag(javadocSingleTypeReference.tagSourceStart, javadocSingleTypeReference.tagSourceEnd);
                            }
                            return;
                        }
                        typeParameterArray = abstractMethodDeclaration.typeParameters();
                        typeVariableBindingArray2 = abstractMethodDeclaration.binding.typeVariables;
                        n2 = abstractMethodDeclaration.binding.modifiers;
                        break;
                    }
                    case 3: {
                        typeVariableBindingArray = ((ClassScope)scope).referenceContext;
                        typeParameterArray = typeVariableBindingArray.typeParameters;
                        typeVariableBindingArray2 = typeVariableBindingArray.binding.typeVariables;
                        n2 = typeVariableBindingArray.binding.modifiers;
                    }
                }
                if (typeVariableBindingArray2 == null || typeVariableBindingArray2.length == 0) {
                    for (int i = 0; i < n3; ++i) {
                        typeVariableBindingArray = this.paramTypeParameters[i];
                        scope.problemReporter().javadocUnexpectedTag(typeVariableBindingArray.tagSourceStart, typeVariableBindingArray.tagSourceEnd);
                    }
                    return;
                }
                if (typeParameterArray == null) break block17;
                bl = bl && scope.compilerOptions().sourceLevel >= 0x310000L;
                n = typeParameterArray.length;
                if (n3 != 0) break block18;
                if (!bl) break block17;
                int n4 = n;
                for (int i = 0; i < n4; ++i) {
                    scope.problemReporter().javadocMissingParamTag(typeParameterArray[i].name, typeParameterArray[i].sourceStart, typeParameterArray[i].sourceEnd, n2);
                }
                break block17;
            }
            if (typeVariableBindingArray2.length == n) {
                int n5;
                Statement statement;
                int n6;
                typeVariableBindingArray = new TypeVariableBinding[n3];
                for (n6 = 0; n6 < n3; ++n6) {
                    statement = this.paramTypeParameters[n6];
                    TypeBinding typeBinding = statement.internalResolveType(scope, 0);
                    if (typeBinding == null || !typeBinding.isValidBinding()) continue;
                    if (typeBinding.isTypeVariable()) {
                        if (scope.compilerOptions().reportUnusedParameterIncludeDocCommentReference) {
                            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)typeBinding;
                            typeVariableBinding.modifiers |= 0x8000000;
                        }
                        n5 = 0;
                        for (int i = 0; i < n6 && n5 == 0; ++i) {
                            if (!TypeBinding.equalsEquals(typeVariableBindingArray[i], statement.resolvedType)) continue;
                            scope.problemReporter().javadocDuplicatedParamTag(statement.token, statement.sourceStart, statement.sourceEnd, n2);
                            n5 = 1;
                        }
                        if (n5 != 0) continue;
                        typeVariableBindingArray[n6] = (TypeVariableBinding)statement.resolvedType;
                        continue;
                    }
                    scope.problemReporter().javadocUndeclaredParamTagName(statement.token, statement.sourceStart, statement.sourceEnd, n2);
                }
                for (n6 = 0; n6 < n; ++n6) {
                    statement = typeParameterArray[n6];
                    boolean bl2 = false;
                    for (n5 = 0; n5 < n3 && !bl2; ++n5) {
                        if (!TypeBinding.equalsEquals(((TypeParameter)statement).binding, typeVariableBindingArray[n5])) continue;
                        bl2 = true;
                        typeVariableBindingArray[n5] = null;
                    }
                    if (bl2 || !bl) continue;
                    scope.problemReporter().javadocMissingParamTag(((TypeParameter)statement).name, ((TypeParameter)statement).sourceStart, ((TypeParameter)statement).sourceEnd, n2);
                }
                for (n6 = 0; n6 < n3; ++n6) {
                    if (typeVariableBindingArray[n6] == null) continue;
                    statement = this.paramTypeParameters[n6];
                    scope.problemReporter().javadocUndeclaredParamTagName(statement.token, statement.sourceStart, statement.sourceEnd, n2);
                }
            }
        }
    }

    private void resolveThrowsTags(MethodScope methodScope, boolean bl) {
        block15: {
            TypeBinding typeBinding;
            int n;
            Object object;
            int n2;
            int n3;
            int n4;
            int n5;
            AbstractMethodDeclaration abstractMethodDeclaration;
            block14: {
                abstractMethodDeclaration = methodScope.referenceMethod();
                int n6 = n5 = this.exceptionReferences == null ? 0 : this.exceptionReferences.length;
                if (abstractMethodDeclaration == null) {
                    for (int i = 0; i < n5; ++i) {
                        TypeReference typeReference = this.exceptionReferences[i];
                        int n7 = typeReference.sourceStart;
                        int n8 = typeReference.sourceEnd;
                        if (typeReference instanceof JavadocQualifiedTypeReference) {
                            n7 = ((JavadocQualifiedTypeReference)typeReference).tagSourceStart;
                            n8 = ((JavadocQualifiedTypeReference)typeReference).tagSourceEnd;
                        } else if (typeReference instanceof JavadocSingleTypeReference) {
                            n7 = ((JavadocSingleTypeReference)typeReference).tagSourceStart;
                            n8 = ((JavadocSingleTypeReference)typeReference).tagSourceEnd;
                        }
                        methodScope.problemReporter().javadocUnexpectedTag(n7, n8);
                    }
                    return;
                }
                n4 = abstractMethodDeclaration.binding == null ? 0 : abstractMethodDeclaration.binding.thrownExceptions.length;
                int n9 = n3 = abstractMethodDeclaration.thrownExceptions == null ? 0 : abstractMethodDeclaration.thrownExceptions.length;
                if (n5 != 0) break block14;
                if (!bl) break block15;
                for (int i = 0; i < n4; ++i) {
                    int n10;
                    ReferenceBinding referenceBinding = abstractMethodDeclaration.binding.thrownExceptions[i];
                    if (referenceBinding == null || !referenceBinding.isValidBinding()) continue;
                    for (n10 = i; n10 < n3 && TypeBinding.notEquals(referenceBinding, abstractMethodDeclaration.thrownExceptions[n10].resolvedType); ++n10) {
                    }
                    if (n10 >= n3) continue;
                    methodScope.problemReporter().javadocMissingThrowsTag(abstractMethodDeclaration.thrownExceptions[n10], abstractMethodDeclaration.binding.modifiers);
                }
                break block15;
            }
            int n11 = 0;
            TypeReference[] typeReferenceArray = new TypeReference[n5];
            for (n2 = 0; n2 < n5; ++n2) {
                object = this.exceptionReferences[n2];
                ((Expression)object).resolve(methodScope);
                TypeBinding typeBinding2 = ((TypeReference)object).resolvedType;
                if (typeBinding2 == null || !typeBinding2.isValidBinding() || !typeBinding2.isClass()) continue;
                typeReferenceArray[n11++] = object;
            }
            for (n2 = 0; n2 < n4; ++n2) {
                object = abstractMethodDeclaration.binding.thrownExceptions[n2];
                if (object != null) {
                    object = (ReferenceBinding)((TypeBinding)object).erasure();
                }
                boolean bl2 = false;
                for (n = 0; n < n11 && !bl2; ++n) {
                    if (typeReferenceArray[n] == null || !TypeBinding.equalsEquals((TypeBinding)object, typeBinding = typeReferenceArray[n].resolvedType)) continue;
                    bl2 = true;
                    typeReferenceArray[n] = null;
                }
                if (bl2 || !bl || object == null || !((Binding)object).isValidBinding()) continue;
                for (n = n2; n < n3 && TypeBinding.notEquals((TypeBinding)object, abstractMethodDeclaration.thrownExceptions[n].resolvedType); ++n) {
                }
                if (n >= n3) continue;
                methodScope.problemReporter().javadocMissingThrowsTag(abstractMethodDeclaration.thrownExceptions[n], abstractMethodDeclaration.binding.modifiers);
            }
            for (n2 = 0; n2 < n11; ++n2) {
                object = typeReferenceArray[n2];
                if (object == null) continue;
                boolean bl3 = false;
                for (n = 0; n < n3 && !bl3; ++n) {
                    typeBinding = abstractMethodDeclaration.thrownExceptions[n].resolvedType;
                    if (typeBinding == null) continue;
                    bl3 = ((TypeReference)object).resolvedType.isCompatibleWith(typeBinding);
                }
                if (bl3 || ((TypeReference)object).resolvedType.isUncheckedException(false)) continue;
                methodScope.problemReporter().javadocInvalidThrowsClassName((TypeReference)object, abstractMethodDeclaration.binding.modifiers);
            }
        }
    }

    private void verifyTypeReference(Expression expression, Expression expression2, Scope scope, boolean bl, ReferenceBinding referenceBinding, int n) {
        if (referenceBinding.isValidBinding()) {
            int n2 = -1;
            if (!this.canBeSeen(scope.problemReporter().options.reportInvalidJavadocTagsVisibility, n)) {
                scope.problemReporter().javadocHiddenReference(expression2.sourceStart, expression.sourceEnd, scope, n);
                return;
            }
            if (expression != expression2 && !this.canBeSeen(scope.problemReporter().options.reportInvalidJavadocTagsVisibility, referenceBinding.modifiers)) {
                scope.problemReporter().javadocHiddenReference(expression2.sourceStart, expression2.sourceEnd, scope, referenceBinding.modifiers);
                return;
            }
            if (referenceBinding.isMemberType()) {
                int n3;
                ReferenceBinding referenceBinding2 = referenceBinding;
                int n4 = referenceBinding2.fPackage.compoundName.length;
                int n5 = referenceBinding.depth();
                int n6 = n5 + n4;
                char[][] cArrayArray = new char[n6 + 1][];
                cArrayArray[n6] = referenceBinding2.sourceName;
                while (referenceBinding2.enclosingType() != null) {
                    referenceBinding2 = referenceBinding2.enclosingType();
                    cArrayArray[--n6] = referenceBinding2.sourceName;
                }
                int n7 = n4;
                while (--n7 >= 0) {
                    cArrayArray[--n6] = referenceBinding2.fPackage.compoundName[n7];
                }
                ClassScope classScope = scope.classScope();
                if (classScope.parent.kind != 4 || !CharOperation.equals(referenceBinding2.sourceName, classScope.referenceContext.name)) {
                    classScope = classScope.outerMostClassScope();
                    if (expression2 instanceof JavadocSingleTypeReference && (!bl && n5 == 1 || TypeBinding.notEquals(referenceBinding2, classScope.referenceContext.binding))) {
                        boolean bl2 = false;
                        if (bl) {
                            CompilationUnitScope compilationUnitScope = classScope.compilationUnitScope();
                            ImportBinding[] importBindingArray = compilationUnitScope.imports;
                            n3 = importBindingArray == null ? 0 : importBindingArray.length;
                            block2: for (int i = 0; i < n3; ++i) {
                                char[][] cArray = importBindingArray[i].compoundName;
                                int n8 = cArray.length;
                                if ((!importBindingArray[i].onDemand || n8 != cArrayArray.length - 1) && n8 != cArrayArray.length) continue;
                                int n9 = n8;
                                while (--n9 >= 0 && CharOperation.equals(importBindingArray[i].compoundName[n9], cArrayArray[n9])) {
                                    if (n9 != 0) continue;
                                    bl2 = true;
                                    ImportReference importReference = importBindingArray[i].reference;
                                    if (importReference == null) break block2;
                                    importReference.bits |= 2;
                                    break block2;
                                }
                            }
                            if (!bl2) {
                                if (n2 == -1) {
                                    n2 = scope.getDeclarationModifiers();
                                }
                                scope.problemReporter().javadocInvalidMemberTypeQualification(expression2.sourceStart, expression2.sourceEnd, n2);
                            }
                        } else {
                            if (n2 == -1) {
                                n2 = scope.getDeclarationModifiers();
                            }
                            scope.problemReporter().javadocInvalidMemberTypeQualification(expression2.sourceStart, expression2.sourceEnd, n2);
                            return;
                        }
                    }
                }
                if (expression2 instanceof JavadocQualifiedTypeReference && !scope.isDefinedInSameUnit(referenceBinding)) {
                    char[][] cArray = ((JavadocQualifiedTypeReference)expression2).getTypeName();
                    int n10 = 0;
                    if (classScope.getCurrentPackage() == referenceBinding.getPackage() && cArray.length < cArrayArray.length) {
                        n10 = referenceBinding.fPackage.compoundName.length;
                    }
                    boolean bl3 = true;
                    if (cArray.length == cArrayArray.length - n10) {
                        for (n3 = 0; n3 < cArray.length; ++n3) {
                            if (CharOperation.equals(cArray[n3], cArrayArray[n3 + n10])) continue;
                            bl3 = false;
                            break;
                        }
                    } else {
                        bl3 = false;
                    }
                    if (!bl3) {
                        if (n2 == -1) {
                            n2 = scope.getDeclarationModifiers();
                        }
                        scope.problemReporter().javadocInvalidMemberTypeQualification(expression2.sourceStart, expression2.sourceEnd, n2);
                        return;
                    }
                }
            }
            if (scope.referenceCompilationUnit().isPackageInfo() && expression2 instanceof JavadocSingleTypeReference && referenceBinding.fPackage.compoundName.length > 0) {
                scope.problemReporter().javadocInvalidReference(expression2.sourceStart, expression2.sourceEnd);
                return;
            }
        }
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            if (this.paramReferences != null) {
                n2 = this.paramReferences.length;
                for (n = 0; n < n2; ++n) {
                    this.paramReferences[n].traverse(aSTVisitor, blockScope);
                }
            }
            if (this.paramTypeParameters != null) {
                n2 = this.paramTypeParameters.length;
                for (n = 0; n < n2; ++n) {
                    this.paramTypeParameters[n].traverse(aSTVisitor, blockScope);
                }
            }
            if (this.returnStatement != null) {
                this.returnStatement.traverse(aSTVisitor, blockScope);
            }
            if (this.exceptionReferences != null) {
                n2 = this.exceptionReferences.length;
                for (n = 0; n < n2; ++n) {
                    this.exceptionReferences[n].traverse(aSTVisitor, blockScope);
                }
            }
            if (this.seeReferences != null) {
                n2 = this.seeReferences.length;
                for (n = 0; n < n2; ++n) {
                    this.seeReferences[n].traverse(aSTVisitor, blockScope);
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n;
            int n2;
            if (this.paramReferences != null) {
                n2 = this.paramReferences.length;
                for (n = 0; n < n2; ++n) {
                    this.paramReferences[n].traverse(aSTVisitor, classScope);
                }
            }
            if (this.paramTypeParameters != null) {
                n2 = this.paramTypeParameters.length;
                for (n = 0; n < n2; ++n) {
                    this.paramTypeParameters[n].traverse(aSTVisitor, classScope);
                }
            }
            if (this.returnStatement != null) {
                this.returnStatement.traverse(aSTVisitor, classScope);
            }
            if (this.exceptionReferences != null) {
                n2 = this.exceptionReferences.length;
                for (n = 0; n < n2; ++n) {
                    this.exceptionReferences[n].traverse(aSTVisitor, classScope);
                }
            }
            if (this.seeReferences != null) {
                n2 = this.seeReferences.length;
                for (n = 0; n < n2; ++n) {
                    this.seeReferences[n].traverse(aSTVisitor, classScope);
                }
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

