/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_in extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Waktu Afrika Tengah",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Waktu Standar Moskwa",
               "MSK",
               "Waktu Musim Panas Moskwa",
               "MSD",
               "Waktu Moskwa",
               "MT",
            };
        final String[] Japan = new String[] {
               "Waktu Standar Jepang",
               "JST",
               "Waktu Musim Panas Jepang",
               "JDT",
               "Waktu Jepang",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Waktu Standar Pakistan",
               "PKT",
               "Waktu Musim Panas Pakistan",
               "PKST",
               "Waktu Pakistan",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Waktu Standar Taipei",
               "CST",
               "Waktu Musim Panas Taipei",
               "CDT",
               "Waktu Taipei",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Waktu Standar Hovd",
               "HOVT",
               "Waktu Musim Panas Hovd",
               "HOVST",
               "Waktu Hovd",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Waktu Standar Magadan",
               "MAGT",
               "Waktu Musim Panas Magadan",
               "MAGST",
               "Waktu Magadan",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Waktu Standar Barat Tengah Australia",
               "ACWST",
               "Waktu Musim Panas Barat Tengah Australia",
               "ACWDT",
               "Waktu Barat Tengah Australia",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Waktu Standar Eropa Tengah",
               "CET",
               "Waktu Musim Panas Eropa Tengah",
               "CEST",
               "Waktu Eropa Tengah",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Waktu Standar Sakhalin",
               "SAKT",
               "Waktu Musim Panas Sakhalin",
               "SAKST",
               "Waktu Sakhalin",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Waktu Standar Paraguay",
               "PYT",
               "Waktu Musim Panas Paraguay",
               "PYST",
               "Waktu Paraguay",
               "PYT",
            };
        final String[] Acre = new String[] {
               "Waktu Standar Acre",
               "ACT",
               "Waktu Musim Panas Acre",
               "ACST",
               "Waktu Acre",
               "ACT",
            };
        final String[] Malaysia = new String[] {
               "Waktu Malaysia",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Waktu Standar Timur",
               "EST",
               "Waktu Musim Panas Timur",
               "EDT",
               "Waktu Timur",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Waktu Standar Lord Howe",
               "LHST",
               "Waktu Musim Panas Lord Howe",
               "LHDT",
               "Waktu Lord Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Waktu Standar Selandia Baru",
               "NZST",
               "Waktu Musim Panas Selandia Baru",
               "NZDT",
               "Waktu Selandia Baru",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Waktu Samudera Hindia",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Waktu Standar Yakutsk",
               "YAKT",
               "Waktu Musim Panas Yakutsk",
               "YAKST",
               "Waktu Yakutsk",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Waktu Standar Mauritius",
               "MUT",
               "Waktu Musim Panas Mauritius",
               "MUST",
               "Waktu Mauritius",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Waktu Afrika Timur",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Waktu Timor Leste",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Waktu Kepulauan Solomon",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Waktu Kosrae",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Waktu Kep. Marshall",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Waktu Standar Eropa Timur",
               "EET",
               "Waktu Musim Panas Eropa Timur",
               "EEST",
               "Waktu Eropa Timur",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Waktu Standar Newfoundland",
               "NST",
               "Waktu Musim Panas Newfoundland",
               "NDT",
               "Waktu Newfoundland",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Waktu Afganistan",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Waktu Standar Hong Kong",
               "HKT",
               "Waktu Musim Panas Hong Kong",
               "HKST",
               "Waktu Hong Kong",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Waktu Standar Argentina Bagian Barat",
               "ART",
               "Waktu Musim Panas Argentina Bagian Barat",
               "ARST",
               "Waktu Argentina Bagian Barat",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Waktu Standar Atlantik",
               "AST",
               "Waktu Musim Panas Atlantik",
               "ADT",
               "Waktu Atlantik",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Waktu Ponape",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Waktu Bolivia",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Waktu Standar Saint Pierre dan Miquelon",
               "PMST",
               "Waktu Musim Panas Saint Pierre dan Miquelon",
               "PMDT",
               "Waktu Saint Pierre dan Miquelon",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Waktu Indochina",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Waktu Standar Yekaterinburg",
               "YEKT",
               "Waktu Musim Panas Yekaterinburg",
               "YEKST",
               "Waktu Yekaterinburg",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Waktu Maladewa",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Waktu Tahiti",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Waktu Standar Israel",
               "IST",
               "Waktu Musim Panas Israel",
               "IDT",
               "Waktu Israel",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Waktu Indonesia Tengah",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Waktu Wallis dan Futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Waktu Standar Afrika Selatan",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Waktu Syowa",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Waktu Kep. Line",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Waktu Standar Uzbekistan",
               "UZT",
               "Waktu Musim Panas Uzbekistan",
               "UZST",
               "Waktu Uzbekistan",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Waktu Standar Omsk",
               "OMST",
               "Waktu Musim Panas Omsk",
               "OMSST",
               "Waktu Omsk",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Waktu Seychelles",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Waktu Standar Uruguay",
               "UYT",
               "Waktu Musim Panas Uruguay",
               "UYST",
               "Waktu Uruguay",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Waktu Nepal",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Waktu Standar Ulan Bator",
               "ULAT",
               "Waktu Musim Panas Ulan Bator",
               "ULAST",
               "Waktu Ulan Bator",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Waktu Standar Tengah",
               "CST",
               "Waktu Musim Panas Tengah",
               "CDT",
               "Waktu Tengah",
               "CT",
            };
        final String[] Truk = new String[] {
               "Waktu Chuuk",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Waktu Niue",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Waktu Kepulauan Wake",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Waktu Standar Kepulauan Falkland",
               "FKT",
               "Waktu Musim Panas Kepulauan Falkland",
               "FKST",
               "Waktu Kepulauan Falkland",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Waktu Standar Vanuatu",
               "VUT",
               "Waktu Musim Panas Vanuatu",
               "VUST",
               "Waktu Vanuatu",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Waktu Standar Novosibirsk",
               "NOVT",
               "Waktu Musim Panas Novosibirsk",
               "NOVST",
               "Waktu Novosibirsk",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Waktu Standar Singapura",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Waktu Standar Azores",
               "AZOT",
               "Waktu Musim Panas Azores",
               "AZOST",
               "Waktu Azores",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Waktu Standar Apia",
               "WSST",
               "Waktu Musim Panas Apia",
               "WSDT",
               "Waktu Apia",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Waktu Bhutan",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Waktu Suriname",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Waktu Nauru",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Waktu Standar Krasnoyarsk",
               "KRAT",
               "Waktu Musim Panas Krasnoyarsk",
               "KRAST",
               "Waktu Krasnoyarsk",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Waktu Kazakhstan Barat",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Waktu Myanmar",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Waktu Pulau Natal",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Waktu Standar Amazon",
               "AMT",
               "Waktu Musim Panas Amazon",
               "AMST",
               "Waktu Amazon",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Waktu Kazakhstan Timur",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Waktu Standar Fiji",
               "FJT",
               "Waktu Musim Panas Fiji",
               "FJST",
               "Waktu Fiji",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Waktu Reunion",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Waktu Kepulauan Cocos",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Waktu Standar Chatham",
               "CHAST",
               "Waktu Musim Panas Chatham",
               "CHADT",
               "Waktu Chatham",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Waktu Vostok",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Waktu Standar Argentina",
               "ART",
               "Waktu Musim Panas Argentina",
               "ARST",
               "Waktu Argentina",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Waktu Gambier",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Waktu Standar Petropavlovsk-Kamchatsky",
               "PETT",
               "Waktu Musim Panas Petropavlovsk-Kamchatski",
               "PETST",
               "Waktu Petropavlovsk-Kamchatsky",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Waktu Tuvalu",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Waktu Galapagos",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Waktu Kepulauan Macquarie",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Waktu Venezuela",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Waktu Standar Hawaii-Aleutian",
               "HAST",
               "Waktu Musim Panas Hawaii-Aleutian",
               "HADT",
               "Waktu Hawaii-Aleutian",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Waktu Standar Tengah Australia",
               "ACST",
               "Waktu Musim Panas Tengah Australia",
               "ACDT",
               "Waktu Tengah Australia",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Waktu Standar Pasifik",
               "PST",
               "Waktu Musim Panas Pasifik",
               "PDT",
               "Waktu Pasifik",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Waktu Kepulauan Phoenix",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Waktu Standar Turkmenistan",
               "TMT",
               "Waktu Musim Panas Turkmenistan",
               "TMST",
               "Waktu Turkmenistan",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Waktu Standar Eropa Barat",
               "WET",
               "Waktu Musim Panas Eropa Barat",
               "WEST",
               "Waktu Eropa Barat",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Waktu Standar Tanjung Verde",
               "CVT",
               "Waktu Musim Panas Tanjung Verde",
               "CVST",
               "Waktu Tanjung Verde",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Waktu Kepulauan Norfolk",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Waktu Guyana",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Waktu Pitcairn",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Waktu Rothera",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Waktu Standar Samoa",
               "SST",
               "Waktu Musim Panas Samoa",
               "SDT",
               "Waktu Samoa",
               "ST",
            };
        final String[] Palau = new String[] {
               "Waktu Palau",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Waktu Eropa Timur Jauh",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Waktu Standar Azerbaijan",
               "AZT",
               "Waktu Musim Panas Azerbaijan",
               "AZST",
               "Waktu Azerbaijan",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Waktu Mawson",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Waktu Standar Pasifik Meksiko",
               "MST",
               "Waktu Musim Panas Pasifik Meksiko",
               "MDT",
               "Waktu Pasifik Meksiko",
               "MT",
            };
        final String[] Davis = new String[] {
               "Waktu Davis",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Waktu Standar Kuba",
               "CST",
               "Waktu Musim Panas Kuba",
               "CDT",
               "Waktu Kuba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Waktu Standar Afrika Barat",
               "WAT",
               "Waktu Musim Panas Afrika Barat",
               "WAST",
               "Waktu Afrika Barat",
               "WAT",
            };
        final String[] GMT = new String[] {
               "Waktu Rata-rata Greenwich",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Waktu Standar Filipina",
               "PHT",
               "Waktu Musim Panas Filipina",
               "PHST",
               "Waktu Filipina",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Waktu Wilayah Selatan dan Antarktika Prancis",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Waktu Georgia Selatan",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Waktu Standar Kaledonia Baru",
               "NCT",
               "Waktu Musim Panas Kaledonia Baru",
               "NCST",
               "Waktu Kaledonia Baru",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Waktu Brunei Darussalam",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Waktu Standar Iran",
               "IRST",
               "Waktu Musim Panas Iran",
               "IRDT",
               "Waktu Iran",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Waktu Standar Pulau Paskah",
               "EAST",
               "Waktu Musim Panas Pulau Paskah",
               "EASST",
               "Waktu Pulau Paskah",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Waktu Standar Meksiko Barat Laut",
               "PST",
               "Waktu Musim Panas Meksiko Barat Laut",
               "PDT",
               "Waktu Meksiko Barat Laut",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Waktu Dumont-d\u2019Urville",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Waktu Tajikistan",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Waktu Standar Tonga",
               "TOT",
               "Waktu Musim Panas Tonga",
               "TOST",
               "Waktu Tonga",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Waktu Standar Bangladesh",
               "BDT",
               "Waktu Musim Panas Bangladesh",
               "BDST",
               "Waktu Bangladesh",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Waktu Standar Peru",
               "PET",
               "Waktu Musim Panas Peru",
               "PEST",
               "Waktu Peru",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Waktu Standar Greenland Barat",
               "WGT",
               "Waktu Musim Panas Greenland Barat",
               "WGST",
               "Waktu Greenland Barat",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Waktu Ekuador",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Waktu Standar Greenland Timur",
               "EGT",
               "Waktu Musim Panas Greenland Timur",
               "EGST",
               "Waktu Greenland Timur",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Waktu Gulf",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Waktu Indonesia Timur",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Waktu Standar Korea",
               "KST",
               "Waktu Musim Panas Korea",
               "KDT",
               "Waktu Korea",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Waktu Standar Barat Australia",
               "AWST",
               "Waktu Musim Panas Barat Australia",
               "AWDT",
               "Waktu Barat Australia",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Waktu Kirghizia",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Waktu Indonesia Barat",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Waktu Standar Timur Australia",
               "AEST",
               "Waktu Musim Panas Timur Australia",
               "AEDT",
               "Waktu Timur Australia",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Waktu Guyana Prancis",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Waktu Standar Kolombia",
               "COT",
               "Waktu Musim Panas Kolombia",
               "COST",
               "Waktu Kolombia",
               "COT",
            };
        final String[] Chile = new String[] {
               "Waktu Standar Cile",
               "CLT",
               "Waktu Musim Panas Cile",
               "CLST",
               "Waktu Cile",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Waktu Kep. Gilbert",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Waktu Standar Pegunungan",
               "MST",
               "Waktu Musim Panas Pegunungan",
               "MDT",
               "Waktu Pegunungan",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Waktu Marquesas",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Waktu Standar Arab",
               "AST",
               "Waktu Musim Panas Arab",
               "ADT",
               "Waktu Arab",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Waktu Standar Alaska",
               "AKST",
               "Waktu Musim Panas Alaska",
               "AKDT",
               "Waktu Alaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Waktu Standar Vladivostok",
               "VLAT",
               "Waktu Musim Panas Vladivostok",
               "VLAST",
               "Waktu Vladivostok",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Waktu Chamorro",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Waktu Standar Irkutsk",
               "IRKT",
               "Waktu Musim Panas Irkutsk",
               "IRKST",
               "Waktu Irkutsk",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Waktu Standar Georgia",
               "GET",
               "Waktu Musim Panas Georgia",
               "GEST",
               "Waktu Georgia",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Waktu Tokelau",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Waktu Papua Nugini",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Waktu Standar Fernando de Noronha",
               "FNT",
               "Waktu Musim Panas Fernando de Noronha",
               "FNST",
               "Waktu Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Waktu Standar Choibalsan",
               "CHOT",
               "Waktu Musim Panas Choibalsan",
               "CHOST",
               "Waktu Choibalsan",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Waktu Standar Brasil",
               "BRT",
               "Waktu Musim Panas Brasil",
               "BRST",
               "Waktu Brasil",
               "BRT",
            };
        final String[] China = new String[] {
               "Waktu Standar Tiongkok",
               "CST",
               "Waktu Terang Tiongkok",
               "CDT",
               "Waktu Tiongkok",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Waktu Standar Armenia",
               "AMT",
               "Waktu Musim Panas Armenia",
               "AMST",
               "Waktu Armenia",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Waktu Standar Samara",
               "SAMT",
               "Waktu Musim Panas Samara",
               "SAMST",
               "Waktu Samara",
               "SAMT",
            };
        final String[] India = new String[] {
               "Waktu India",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Waktu Standar Kep. Cook",
               "CKT",
               "Waktu Tengah Musim Panas Kep. Cook",
               "CKHST",
               "Waktu Kep. Cook",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Waktu Rata-rata Greenwich",
                    "GMT",
                    "Waktu Musim Panas Inggris",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Waktu Rata-rata Greenwich",
                    "GMT",
                    "Waktu Standar Irlandia",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
