/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_nb extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "sentralafrikansk tid",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "normaltid for Moskva",
               "MSK",
               "sommertid for Moskva",
               "MSD",
               "tidssone for Moskva",
               "MT",
            };
        final String[] Japan = new String[] {
               "japansk normaltid",
               "JST",
               "japansk sommertid",
               "JDT",
               "japansk tid",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "pakistansk normaltid",
               "PKT",
               "pakistansk sommertid",
               "PKST",
               "pakistansk tid",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "normaltid for Taipei",
               "CST",
               "sommertid for Taipei",
               "CDT",
               "tidssone for Taipei",
               "CT",
            };
        final String[] Hovd = new String[] {
               "normaltid for Khovd",
               "HOVT",
               "sommertid for Khovd",
               "HOVST",
               "tidssone for Khovd",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "normaltid for Magadan",
               "MAGT",
               "sommertid for Magadan",
               "MAGST",
               "tidssone for Magadan",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "vest-sentralaustralsk normaltid",
               "ACWST",
               "vest-sentralaustralsk sommertid",
               "ACWDT",
               "vest-sentralaustralsk tid",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "sentraleuropeisk normaltid",
               "CET",
               "sentraleuropeisk sommertid",
               "CEST",
               "sentraleuropeisk tid",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "normaltid for Sakhalin",
               "SAKT",
               "sommertid for Sakhalin",
               "SAKST",
               "tidssone for Sakhalin",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "paraguayansk normaltid",
               "PYT",
               "paraguayansk sommertid",
               "PYST",
               "paraguayansk tid",
               "PYT",
            };
        final String[] Acre = new String[] {
               "Acre normaltid",
               "ACT",
               "Acre sommertid",
               "ACST",
               "Acre-tid",
               "ACT",
            };
        final String[] Malaysia = new String[] {
               "malaysisk tid",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "normaltid for den nordamerikanske \u00f8stkysten",
               "EST",
               "sommertid for den nordamerikanske \u00f8stkysten",
               "EDT",
               "tidssone for den nordamerikanske \u00f8stkysten",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "normaltid for Lord Howe-\u00f8ya",
               "LHST",
               "sommertid for Lord Howe-\u00f8ya",
               "LHDT",
               "tidssone for Lord Howe-\u00f8ya",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "newzealandsk normaltid",
               "NZST",
               "newzealandsk sommertid",
               "NZDT",
               "newzealandsk tid",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "tidssone for Indiahavet",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "normaltid for Jakutsk",
               "YAKT",
               "sommertid for Jakutsk",
               "YAKST",
               "tidssone for Jakutsk",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "mauritisk normaltid",
               "MUT",
               "mauritisk sommertid",
               "MUST",
               "mauritisk tid",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u00f8stafrikansk tid",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "\u00f8sttimoresisk tid",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "tidssone for Salomon\u00f8yene",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "tidssone for Kosrae",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "tidssone for Marshall\u00f8yene",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u00f8steuropeisk normaltid",
               "EET",
               "\u00f8steuropeisk sommertid",
               "EEST",
               "\u00f8steuropeisk tid",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "normaltid for Newfoundland",
               "NST",
               "sommertid for Newfoundland",
               "NDT",
               "tidssone for Newfoundland",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "afghansk tid",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "normaltid for Hongkong",
               "HKT",
               "sommertid for Hongkong",
               "HKST",
               "tidssone for Hongkong",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "vestargentinsk normaltid",
               "ART",
               "vestargentinsk sommertid",
               "ARST",
               "vestargentinsk tid",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "atlanterhavskystlig standardtid",
               "AST",
               "atlanterhavskystlig sommertid",
               "ADT",
               "atlanterhavskystlig tid",
               "AT",
            };
        final String[] Ponape = new String[] {
               "tidssone for Pohnpei",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "boliviansk tid",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "normaltid for Saint-Pierre-et-Miquelon",
               "PMST",
               "sommertid for Saint-Pierre-et-Miquelon",
               "PMDT",
               "tidssone for Saint-Pierre-et-Miquelon",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "indokinesisk tid",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "normaltid for Jekaterinburg",
               "YEKT",
               "sommertid for Jekaterinburg",
               "YEKST",
               "tidssone for Jekaterinburg",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "maldivisk tid",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "tahitisk tid",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "israelsk normaltid",
               "IST",
               "israelsk sommertid",
               "IDT",
               "israelsk tid",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "sentralindonesisk tid",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "tidssone for Wallis- og Futuna\u00f8yene",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "s\u00f8rafrikansk tid",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "tidssone for Syowa",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "tidssone for Linje\u00f8yene",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "usbekisk normaltid",
               "UZT",
               "usbekisk sommertid",
               "UZST",
               "usbekisk tid",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "normaltid for Omsk",
               "OMST",
               "sommertid for Omsk",
               "OMSST",
               "tidssone for Omsk",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "seychellisk tid",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "uruguayansk normaltid",
               "UYT",
               "uruguayansk sommertid",
               "UYST",
               "uruguayansk tid",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "nepalsk tid",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "normaltid for Ulan Bator",
               "ULAT",
               "sommertid for Ulan Bator",
               "ULAST",
               "tidssone for Ulan Bator",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "normaltid for det sentrale Nord-Amerika",
               "CST",
               "sommertid for det sentrale Nord-Amerika",
               "CDT",
               "tidssone for det sentrale Nord-Amerika",
               "CT",
            };
        final String[] Truk = new String[] {
               "tidssone for Chuuk\u00f8yene",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "tidssone for Niue",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "tidssone for Wake Island",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "normaltid for Falklands\u00f8yene",
               "FKT",
               "sommertid for Falklands\u00f8yene",
               "FKST",
               "tidssone for Falklands\u00f8yene",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "vanuatisk normaltid",
               "VUT",
               "vanuatisk sommertid",
               "VUST",
               "vanuatisk tid",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "normaltid for Novosibirsk",
               "NOVT",
               "sommertid for Novosibirsk",
               "NOVST",
               "tidssone for Novosibirsk",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "singaporsk tid",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "asorisk normaltid",
               "AZOT",
               "asorisk sommertid",
               "AZOST",
               "asorisk tid",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "normaltid for Apia",
               "WSST",
               "sommertid for Apia",
               "WSDT",
               "tidssone for Apia",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "bhutansk tid",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "surinamsk tid",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "naurisk tid",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "normaltid for Krasnojarsk",
               "KRAT",
               "sommertid for Krasnojarsk",
               "KRAST",
               "tidssone for Krasnojarsk",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "vestkasakhstansk tid",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "myanmarsk tid",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "tidssone for Christmas\u00f8ya",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "normaltid for Amazonas",
               "AMT",
               "sommertid for Amazonas",
               "AMST",
               "tidssone for Amazonas",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u00f8stkasakhstansk tid",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "fijiansk normaltid",
               "FJT",
               "fijiansk sommertid",
               "FJST",
               "fijiansk tid",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "tidssone for R\u00e9union",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "tidssone for Kokos\u00f8yene",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "normaltid for Chatham",
               "CHAST",
               "sommertid for Chatham",
               "CHADT",
               "tidssone for Chatham",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "tidssone for Vostok",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "argentinsk normaltid",
               "ART",
               "argentinsk sommertid",
               "ARST",
               "argentinsk tid",
               "ART",
            };
        final String[] Gambier = new String[] {
               "tidssone for Gambier",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Russisk (Petropavlovsk-Kamtsjatskij) normaltid",
               "PETT",
               "Russisk (Petropavlovsk-Kamtsjatskij) sommertid",
               "PETST",
               "Russisk (Petropavlovsk-Kamtsjatskij) tid",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "tuvalsk tid",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "tidssone for Gal\u00e1pagos\u00f8yene",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "tidssone for Macquarie\u00f8ya",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "venezuelansk tid",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "normaltid for Hawaii og Aleutene",
               "HAST",
               "sommertid for Hawaii og Aleutene",
               "HADT",
               "tidssone for Hawaii og Aleutene",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "sentralaustralsk normaltid",
               "ACST",
               "sentralaustralsk sommertid",
               "ACDT",
               "sentralaustralsk tid",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "normaltid for den nordamerikanske Stillehavskysten",
               "PST",
               "sommertid for den nordamerikanske Stillehavskysten",
               "PDT",
               "tidssone for den nordamerikanske Stillehavskysten",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "tidssone for Phoenix\u00f8yene",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "turkmensk normaltid",
               "TMT",
               "turkmensk sommertid",
               "TMST",
               "turkmensk tid",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "vesteuropeisk normaltid",
               "WET",
               "vesteuropeisk sommertid",
               "WEST",
               "vesteuropeisk tid",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "normaltid for Kapp Verde",
               "CVT",
               "sommertid for Kapp Verde",
               "CVST",
               "tidssone for Kapp Verde",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "tidssone for Norfolk\u00f8ya",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "guyansk tid",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "tidssone for Pitcairn",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "tidssone for Rothera",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "samoansk normaltid",
               "SST",
               "samoansk sommertid",
               "SDT",
               "samoansk tid",
               "ST",
            };
        final String[] Palau = new String[] {
               "palauisk tid",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "fjern-\u00f8steuropeisk tid",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "aserbajdsjansk normaltid",
               "AZT",
               "aserbajdsjansk sommertid",
               "AZST",
               "aserbajdsjansk tid",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "tidssone for Mawson",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "normaltid for den meksikanske Stillehavskysten",
               "MST",
               "sommertid for den meksikanske Stillehavskysten",
               "MDT",
               "tidssone for den meksikanske Stillehavskysten",
               "MT",
            };
        final String[] Davis = new String[] {
               "tidssone for Davis",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "cubansk normaltid",
               "CST",
               "cubansk sommertid",
               "CDT",
               "cubansk tid",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "vestafrikansk normaltid",
               "WAT",
               "vestafrikansk sommertid",
               "WAST",
               "vestafrikansk tid",
               "WAT",
            };
        final String[] GMT = new String[] {
               "Greenwich middeltid",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "filippinsk normaltid",
               "PHT",
               "filippinsk sommertid",
               "PHST",
               "filippinsk tid",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "tidssone for De franske s\u00f8rterritorier",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "tidssone for S\u00f8r-Georgia",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "kaledonsk normaltid",
               "NCT",
               "kaledonsk sommertid",
               "NCST",
               "kaledonsk tid",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "tidssone for Brunei Darussalam",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "iransk normaltid",
               "IRST",
               "iransk sommertid",
               "IRDT",
               "iransk tid",
               "IRT",
            };
        final String[] Easter = new String[] {
               "normaltid for P\u00e5ske\u00f8ya",
               "EAST",
               "sommertid for P\u00e5ske\u00f8ya",
               "EASST",
               "tidssone for P\u00e5ske\u00f8ya",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "normaltid for nordvestlige Mexico",
               "PST",
               "sommertid for nordvestlige Mexico",
               "PDT",
               "tidssone for nordvestlige Mexico",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "tidssone for Dumont d\u2019Urville",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "tadsjikisk tid",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "tongansk normaltid",
               "TOT",
               "tongansk sommertid",
               "TOST",
               "tongansk tid",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "bangladeshisk normaltid",
               "BDT",
               "bangladeshisk sommertid",
               "BDST",
               "bangladeshisk tid",
               "BDT",
            };
        final String[] Peru = new String[] {
               "peruansk normaltid",
               "PET",
               "peruansk sommertid",
               "PEST",
               "peruansk tid",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "vestgr\u00f8nlandsk normaltid",
               "WGT",
               "vestgr\u00f8nlandsk sommertid",
               "WGST",
               "vestgr\u00f8nlandsk tid",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "ecuadoriansk tid",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u00f8stgr\u00f8nlandsk normaltid",
               "EGT",
               "\u00f8stgr\u00f8nlandsk sommertid",
               "EGST",
               "\u00f8stgr\u00f8nlandsk tid",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "tidssone for Persiabukta",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u00f8stindonesisk tid",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "koreansk normaltid",
               "KST",
               "koreansk sommertid",
               "KDT",
               "koreansk tid",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "vestaustralsk normaltid",
               "AWST",
               "vestaustralsk sommertid",
               "AWDT",
               "vestaustralsk tid",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "kirgisisk tid",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "vestindonesisk tid",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "\u00f8staustralsk normaltid",
               "AEST",
               "\u00f8staustralsk sommertid",
               "AEDT",
               "\u00f8staustralsk tid",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "tidssone for Fransk Guyana",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "colombiansk normaltid",
               "COT",
               "colombiansk sommertid",
               "COST",
               "colombiansk tid",
               "COT",
            };
        final String[] Chile = new String[] {
               "chilensk normaltid",
               "CLT",
               "chilensk sommertid",
               "CLST",
               "chilensk tid",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "tidssone for Gilbert\u00f8yene",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "normaltid for Rocky Mountains (USA)",
               "MST",
               "sommertid for Rocky Mountains (USA)",
               "MDT",
               "tidssone for Rocky Mountains (USA)",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "tidssone for Marquesas\u00f8yene",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "arabisk standardtid",
               "AST",
               "arabisk sommertid",
               "ADT",
               "arabisk tid",
               "AT",
            };
        final String[] Alaska = new String[] {
               "alaskisk normaltid",
               "AKST",
               "alaskisk sommertid",
               "AKDT",
               "alaskisk tid",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "normaltid for Vladivostok",
               "VLAT",
               "sommertid for Vladivostok",
               "VLAST",
               "tidssone for Vladivostok",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "tidssone for Chamorro",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "normaltid for Irkutsk",
               "IRKT",
               "sommertid for Irkutsk",
               "IRKST",
               "tidssone for Irkutsk",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "georgisk normaltid",
               "GET",
               "georgisk sommertid",
               "GEST",
               "georgisk tid",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "tidssone for Tokelau",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "papuansk tid",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "normaltid for Fernando de Noronha",
               "FNT",
               "sommertid for Fernando de Noronha",
               "FNST",
               "tidssone for Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "normaltid for Tsjojbalsan",
               "CHOT",
               "sommertid for Tsjojbalsan",
               "CHOST",
               "tidssone for Tsjojbalsan",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "normaltid for Brasilia",
               "BRT",
               "sommertid for Brasilia",
               "BRST",
               "tidssone for Brasilia",
               "BRT",
            };
        final String[] China = new String[] {
               "kinesisk normaltid",
               "CST",
               "kinesisk sommertid",
               "CDT",
               "kinesisk tid",
               "CT",
            };
        final String[] Armenia = new String[] {
               "armensk normaltid",
               "AMT",
               "armensk sommertid",
               "AMST",
               "armensk tid",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Russisk (Samara) normaltid",
               "SAMT",
               "Russisk (Samara) sommertid",
               "SAMST",
               "Russisk (Samara) tid",
               "SAMT",
            };
        final String[] India = new String[] {
               "indisk tid",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "normaltid for Cook\u00f8yene",
               "CKT",
               "halv sommertid for Cook\u00f8yene",
               "CKHST",
               "tidssone for Cook\u00f8yene",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Greenwich middeltid",
                    "GMT",
                    "britisk sommertid",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich middeltid",
                    "GMT",
                    "irsk sommertid",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
