/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.modules.appui.about;

import com.sun.tools.visualvm.uisupport.UISupport;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class TextViewerComponent
extends JTextArea
implements MouseListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("com.sun.tools.visualvm.modules.appui.about.Bundle");
    private static final String CUT_STRING = messages.getString("TextViewerComponent_CutString");
    private static final String COPY_STRING = messages.getString("TextViewerComponent_CopyString");
    private static final String PASTE_STRING = messages.getString("TextViewerComponent_PasteString");
    private static final String DELETE_STRING = messages.getString("TextViewerComponent_DeleteString");
    private static final String SELECT_ALL_STRING = messages.getString("TextViewerComponent_SelectAllString");
    private ActionListener popupListener;
    private JMenuItem itemCopy;
    private JMenuItem itemCut;
    private JMenuItem itemDelete;
    private JMenuItem itemPaste;
    private JMenuItem itemSelectAll;
    private JPopupMenu popupMenu;
    private boolean showPopup = true;

    public TextViewerComponent() {
        this.setEditable(false);
        this.setOpaque(true);
        this.setAutoscrolls(true);
        this.setFont(new Font("Monospaced", 0, UIManager.getFont("Label.font").getSize()));
        this.setBackground(UISupport.getDefaultBackground());
        this.addMouseListener(this);
    }

    public TextViewerComponent(String text) {
        this();
        this.setText(text);
    }

    public void setShowPopup(boolean showPopup) {
        this.showPopup = showPopup;
    }

    public boolean getShowPopup() {
        return this.showPopup;
    }

    public void deleteSelection() {
        try {
            this.getDocument().remove(this.getSelectionStart(), this.getSelectionEnd() - this.getSelectionStart());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void mouseClicked(MouseEvent e) {
        JPopupMenu popup;
        if (e.getModifiers() == 4 && this.isEnabled() && this.isFocusable() && this.showPopup && (popup = this.getPopupMenu()) != null) {
            this.updatePopupMenu();
            if (!this.hasFocus()) {
                this.requestFocus();
            }
            popup.show(this, e.getX(), e.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void paste() {
        try {
            this.replaceSelection(Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this).getTransferData(DataFlavor.stringFlavor).toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = this.createPopupMenu();
        }
        return this.popupMenu;
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        this.popupListener = this.createPopupListener();
        this.itemCut = new JMenuItem(CUT_STRING);
        this.itemCopy = new JMenuItem(COPY_STRING);
        this.itemPaste = new JMenuItem(PASTE_STRING);
        this.itemDelete = new JMenuItem(DELETE_STRING);
        this.itemSelectAll = new JMenuItem(SELECT_ALL_STRING);
        this.itemCut.addActionListener(this.popupListener);
        this.itemCopy.addActionListener(this.popupListener);
        this.itemPaste.addActionListener(this.popupListener);
        this.itemDelete.addActionListener(this.popupListener);
        this.itemSelectAll.addActionListener(this.popupListener);
        popup.add(this.itemCut);
        popup.add(this.itemCopy);
        popup.add(this.itemPaste);
        popup.add(this.itemDelete);
        popup.addSeparator();
        popup.add(this.itemSelectAll);
        return popup;
    }

    protected void updatePopupMenu() {
        this.itemCut.setEnabled(this.isEditable() && this.getSelectedText() != null);
        this.itemCopy.setEnabled(this.getSelectedText() != null);
        try {
            Transferable clipboardContent = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
            this.itemPaste.setEnabled(this.isEditable() && clipboardContent != null && clipboardContent.isDataFlavorSupported(DataFlavor.stringFlavor));
        }
        catch (Exception e) {
            this.itemPaste.setEnabled(false);
        }
        if (this.isEditable()) {
            this.itemDelete.setVisible(true);
            this.itemDelete.setEnabled(this.getSelectedText() != null);
        } else {
            this.itemDelete.setVisible(false);
        }
    }

    private ActionListener createPopupListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == TextViewerComponent.this.itemCut) {
                    TextViewerComponent.this.cut();
                } else if (e.getSource() == TextViewerComponent.this.itemCopy) {
                    TextViewerComponent.this.copy();
                } else if (e.getSource() == TextViewerComponent.this.itemPaste) {
                    TextViewerComponent.this.paste();
                } else if (e.getSource() == TextViewerComponent.this.itemDelete) {
                    TextViewerComponent.this.deleteSelection();
                } else if (e.getSource() == TextViewerComponent.this.itemSelectAll) {
                    TextViewerComponent.this.selectAll();
                }
            }
        };
    }
}

