/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.Exceptions;

public final class ChangeSupport {
    private static final Logger LOG = Logger.getLogger(ChangeSupport.class.getName());
    final List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private final Object source;

    public ChangeSupport(Object object) {
        this.source = object;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        if (LOG.isLoggable(Level.FINE) && this.listeners.contains(changeListener)) {
            LOG.log(Level.FINE, "diagnostics for #167491", new IllegalStateException("Added " + changeListener + " multiply"));
        }
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        this.listeners.remove(changeListener);
    }

    public void fireChange() {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.fireChange(new ChangeEvent(this.source));
    }

    private void fireChange(ChangeEvent changeEvent) {
        assert (changeEvent != null);
        for (ChangeListener changeListener : this.listeners) {
            try {
                changeListener.stateChanged(changeEvent);
            }
            catch (RuntimeException runtimeException) {
                Exceptions.printStackTrace(runtimeException);
            }
        }
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }
}

