/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import groovy.lang.Closure;
import java.util.Map;
import org.gradle.api.artifacts.ClientModule;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.ModuleFactoryDelegate;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.notations.ProjectDependencyFactory;
import org.gradle.internal.typeconversion.NotationParser;

public class DefaultDependencyFactory
implements DependencyFactory {
    private final NotationParser<Object, Dependency> dependencyNotationParser;
    private final NotationParser<Object, ClientModule> clientModuleNotationParser;
    private final ProjectDependencyFactory projectDependencyFactory;

    public DefaultDependencyFactory(NotationParser<Object, Dependency> dependencyNotationParser, NotationParser<Object, ClientModule> clientModuleNotationParser, ProjectDependencyFactory projectDependencyFactory) {
        this.dependencyNotationParser = dependencyNotationParser;
        this.clientModuleNotationParser = clientModuleNotationParser;
        this.projectDependencyFactory = projectDependencyFactory;
    }

    public Dependency createDependency(Object dependencyNotation) {
        return (Dependency)this.dependencyNotationParser.parseNotation(dependencyNotation);
    }

    public ClientModule createModule(Object dependencyNotation, Closure configureClosure) {
        ClientModule clientModule = (ClientModule)this.clientModuleNotationParser.parseNotation(dependencyNotation);
        if (configureClosure != null) {
            this.configureModule(clientModule, configureClosure);
        }
        return clientModule;
    }

    public ProjectDependency createProjectDependencyFromMap(ProjectFinder projectFinder, Map<? extends String, ? extends Object> map) {
        return this.projectDependencyFactory.createFromMap(projectFinder, map);
    }

    private void configureModule(ClientModule clientModule, Closure configureClosure) {
        ModuleFactoryDelegate moduleFactoryDelegate = new ModuleFactoryDelegate(clientModule, this);
        moduleFactoryDelegate.prepareDelegation(configureClosure);
        configureClosure.call();
    }
}

