/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.api.Named;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupportedImmutableTypes {
    public static final List<Class<?>> SCALAR_TYPES = ImmutableList.of(Boolean.class, Boolean.TYPE, Character.class, Character.TYPE, Byte.class, Byte.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Float.class, Float.TYPE, (Object[])new Class[]{Long.class, Long.TYPE, Double.class, Double.TYPE, BigInteger.class, BigDecimal.class, AtomicBoolean.class, AtomicInteger.class, AtomicLong.class, String.class, File.class});

    static boolean isScalarType(Class<?> modelType) {
        return SCALAR_TYPES.contains(modelType) || modelType.isEnum();
    }

    static boolean isSupportedInterface(Class<?> clazz) {
        return Named.class.isAssignableFrom(clazz) && clazz.isInterface();
    }

    public static void describeTo(StringBuilder sb) {
        sb.append("   - primitive types (byte, boolean, char, short, int, long, float, double) and their wrapped types (Byte, ...)\n");
        sb.append("   - an enum\n");
        sb.append("   - an instance of String\n");
        sb.append("   - an instance of File\n");
        sb.append("   - an instance of BigInteger, BigDecimal, AtomicInteger, AtomicBoolean or AtomicLong\n");
        sb.append("   - an interface extending Named\n");
        sb.append("   - an array of the above\n");
    }

    public static <T> boolean isSupportedImmutableType(Class<T> clazz) {
        if (clazz.isArray()) {
            return SupportedImmutableTypes.isSupportedImmutableType(clazz.getComponentType());
        }
        if (SupportedImmutableTypes.isScalarType(clazz)) {
            return true;
        }
        return SupportedImmutableTypes.isSupportedInterface(clazz);
    }
}

