/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui.midi;

import common.MidiTrackEvent;
import dguitar.gui.midi.MidiEventPanelItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MidiEventPanel
extends JPanel {
    int maxTracks;
    int maxEvents;
    private static int LM = 80;
    private static int TM = 15;
    private static int W = 30;
    private static int H = 16;
    private Vector Items;
    private ActionListener Listener;
    private Font labelFont;

    public MidiEventPanel(ActionListener listener) {
        this.setLayout(null);
        this.maxTracks = -1;
        this.maxEvents = -1;
        this.Listener = listener;
        this.labelFont = new Font("MS Sans Serif", 0, 10);
    }

    private int calculateY(int track) {
        return TM + track * H;
    }

    private int calculateX(int event) {
        return LM + event * W;
    }

    private void locate(Component C, MidiTrackEvent MTE) {
        int y = this.calculateY(MTE.getTrack());
        int x = this.calculateX(MTE.getEvent());
        C.setBounds(x + 6, y + 1, W, H - 2);
    }

    private void addLabel(String s, int x, int y, int w, int h) {
        JLabel JL = new JLabel(s);
        JL.setFont(this.labelFont);
        JL.setBounds(x, y, w + 1, h + 1);
        JL.setVisible(true);
        JL.setHorizontalAlignment(0);
        JL.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.add(JL);
    }

    public void setMidiTrackEvents(Vector V) {
        this.maxTracks = 0;
        this.maxEvents = 0;
        this.Items = new Vector(0, 1);
        int i = 0;
        while (i < V.size()) {
            MidiTrackEvent MTE = (MidiTrackEvent)V.get(i);
            if (MTE.getEvent() == 0) {
                if (MTE.getTrack() == 0) {
                    this.addLabel("Track \\ Event", 0, 0, LM, TM);
                }
                this.addLabel("" + MTE.getTrack(), 0, this.calculateY(MTE.getTrack()), LM, H);
            }
            this.maxTracks = Math.max(this.maxTracks, MTE.getTrack());
            this.maxEvents = Math.max(this.maxEvents, MTE.getEvent());
            MidiEventPanelItem item = new MidiEventPanelItem(MTE, i, false, this.Listener);
            this.locate(item.JC, MTE);
            this.add(item.JC);
            this.Items.add(item);
            ++i;
        }
        i = 0;
        while (i <= this.maxEvents) {
            this.addLabel("" + i, this.calculateX(i), 0, W, TM);
            ++i;
        }
    }

    public Dimension getMinimumSize() {
        Dimension dim = new Dimension(250, 50);
        if (this.maxTracks >= 0) {
            dim.height = 2 * TM + H * (this.maxTracks + 1) + 2;
        }
        if (this.maxEvents >= 0) {
            dim.width = LM + W * (this.maxEvents + 1);
        }
        return dim;
    }

    public void setSelected(MidiTrackEvent mte, boolean b) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.Items.size()) {
            MidiEventPanelItem item = (MidiEventPanelItem)this.Items.get(i);
            if (item.MTE.equals(mte)) {
                found = true;
                item.setSelected(b);
            }
            ++i;
        }
    }

    public MidiTrackEvent getMidiTrackEventAt(int index) {
        MidiTrackEvent res = null;
        if (index >= 0 && index <= this.Items.size()) {
            MidiEventPanelItem item = (MidiEventPanelItem)this.Items.get(index);
            res = item.MTE;
        }
        return res;
    }

    public int getIndexFor(JCheckBox jc) {
        boolean found = false;
        int res = -1;
        int i = 0;
        while (!found && i < this.Items.size()) {
            MidiEventPanelItem item = (MidiEventPanelItem)this.Items.get(i);
            if (item.JC.equals(jc)) {
                found = true;
                res = i;
            }
            ++i;
        }
        return res;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

