/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.image;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.fibs.geotag.Settings;
import org.fibs.geotag.exif.Exiftool;
import org.fibs.geotag.util.FileUtil;

public enum FileTypes {
    UNKOWN,
    JPEG,
    RAW_READ_ONLY,
    RAW_READ_WRITE,
    TIFF,
    XMP,
    CUSTOM_FILE_WITH_XMP;


    public static FileTypes fileType(File file) {
        if (FileTypes.isJpegFile(file)) {
            return JPEG;
        }
        if (FileTypes.isReadWriteRawFile(file)) {
            return RAW_READ_WRITE;
        }
        if (FileTypes.isReadOnlyRawFile(file)) {
            return RAW_READ_ONLY;
        }
        if (FileTypes.isTiffFile(file)) {
            return TIFF;
        }
        if (FileTypes.isXmpFile(file)) {
            return XMP;
        }
        if (FileTypes.isCustomFileWithXmpFile(file)) {
            return CUSTOM_FILE_WITH_XMP;
        }
        return UNKOWN;
    }

    private static boolean isJpegFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String extension = FileUtil.getExtension(file);
        return extension != null && (extension.equals("jpeg") || extension.equals("jpg") || extension.equals("thm"));
    }

    private static boolean isTiffFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String extension = FileUtil.getExtension(file);
        return extension != null && (extension.equals("tif") || extension.equals("tiff"));
    }

    private static boolean isReadWriteRawFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String extension = FileUtil.getExtension(file);
        if (extension != null) {
            if (extension.equals("cr2") || extension.equals("dng") || extension.equals("erf") || extension.equals("mef") || extension.equals("mrw") || extension.equals("nef") || extension.equals("orf") || extension.equals("pef") || extension.equals("raw") || extension.equals("crw")) {
                return true;
            }
            if (extension.equals("rw2") && Exiftool.getVersion() != null && Exiftool.getVersion().compareTo("7.73") >= 0) {
                return true;
            }
            if (extension.equals("nrw") && Exiftool.getVersion() != null && Exiftool.getVersion().compareTo("7.90") >= 0) {
                return true;
            }
            if (extension.equals("srw") && Exiftool.getVersion() != null && Exiftool.getVersion().compareTo("8.13") >= 0) {
                return true;
            }
        }
        return false;
    }

    private static boolean isReadOnlyRawFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String extension = FileUtil.getExtension(file);
        return extension != null && (extension.equals("arw") || extension.equals("dcr") || extension.equals("raf") || extension.equals("sr2") || extension.equals("srf") || extension.equals("x3f"));
    }

    private static boolean isXmpFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String extension = FileUtil.getExtension(file);
        return extension != null && extension.equals("xmp");
    }

    private static boolean isCustomFileWithXmpFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String extension = FileUtil.getExtension(file);
        List<String> fileTypes = FileTypes.getFileTypesSupportedByXmp();
        for (String fileType : fileTypes) {
            if (!fileType.toLowerCase().equals(extension)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getFileTypesSupportedByXmp() {
        ArrayList<String> fileTypesSupportedByXmp = new ArrayList<String>();
        String fileTypesSetting = Settings.get(Settings.SETTING.FILE_TYPES_SUPPORTED_BY_XMP, "");
        StringTokenizer tokenizer = new StringTokenizer(fileTypesSetting, " ,.");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            fileTypesSupportedByXmp.add(token);
        }
        return fileTypesSupportedByXmp;
    }
}

