/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.CU;
import javajs.util.P3;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.PolygonFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class Ras3DReader
extends PolygonFileReader {
    private String pmeshError;
    private String type;
    private boolean asQuads;
    private int nPolygons;
    Map<String, Integer> htVertices;

    Ras3DReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.init2PR(sg, br);
    }

    protected void init2PR(SurfaceGenerator sg, BufferedReader br) {
        this.init2PFR(sg, br);
        String fileName = (String)((Object[])sg.getReaderData())[0];
        if (fileName == null) {
            return;
        }
        this.type = "ras3d";
        this.setHeader();
    }

    protected void setHeader() {
        this.jvxlFileHeaderBuffer.append(this.type + " file format\nvertices and triangles only\n");
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    @Override
    void getSurfaceData() throws Exception {
        if (this.readVerticesAndPolygons()) {
            Logger.info(this.type + " file contains " + this.nVertices + " vertices and " + this.nPolygons + " polygons for " + this.nTriangles + " triangles");
        } else {
            Logger.error(this.params.fileName + ": " + (this.pmeshError == null ? "Error reading pmesh data " : this.pmeshError));
        }
    }

    protected boolean readVerticesAndPolygons() {
        block3: {
            try {
                if (this.readVertices()) {
                    return true;
                }
            }
            catch (Exception e) {
                if (this.pmeshError != null) break block3;
                this.pmeshError = this.type + " ERROR: " + e;
            }
        }
        return false;
    }

    private boolean readVertices() throws Exception {
        this.htVertices = new Hashtable<String, Integer>();
        int[] v0 = new int[3];
        int[] v1 = new int[3];
        int c0 = 0;
        int c1 = 0;
        if (this.rd().indexOf("DSSR") >= 0) {
            this.asQuads = true;
        }
        while (this.rd() != null) {
            while (!this.line.equals("1")) {
                this.rd();
            }
            this.rd();
            String[] tokens = this.getTokens();
            v0[0] = this.getPoint(tokens, 0);
            v0[1] = this.getPoint(tokens, 3);
            v0[2] = this.getPoint(tokens, 6);
            ++this.nTriangles;
            c0 = CU.colorTriadToFFRGB(this.parseFloatStr(tokens[9]), this.parseFloatStr(tokens[10]), this.parseFloatStr(tokens[11]));
            if (this.asQuads) {
                if (this.nTriangles % 2 == 1) {
                    int[] v2 = v1;
                    v1 = v0;
                    v0 = v2;
                    int c2 = c1;
                    c1 = c0;
                    c0 = c2;
                    continue;
                }
                this.addTriangleCheck(v0[0], v0[1], v0[2], 6, 0, false, c0);
                this.addTriangleCheck(v1[0], v1[1], v1[2], 3, 0, false, c1);
            } else {
                this.addTriangleCheck(v0[0], v0[1], v0[2], 7, 0, false, c0);
            }
            ++this.nPolygons;
        }
        return true;
    }

    private int getPoint(String[] tokens, int i) {
        String key = tokens[i] + ";" + tokens[i + 1] + ";" + tokens[i + 2];
        Integer v = this.htVertices.get(key);
        if (v == null) {
            this.addVertexCopy(P3.new3(this.parseFloatStr(tokens[i]), this.parseFloatStr(tokens[i + 1]), this.parseFloatStr(tokens[i + 2])), 0.0f, this.nVertices, false);
            v = this.nVertices++;
            this.htVertices.put(key, v);
        }
        return v;
    }
}

