/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.Action;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionChangeListener;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MainPanel;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapFrameListener;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.preferences.ToolbarPreferences;
import org.openstreetmap.josm.io.FileWatcher;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.PlatformHookOsx;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.PlatformHookWindows;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public abstract class Main {
    private static final String JOSM_WEBSITE = "https://josm.openstreetmap.de";
    private static final String OSM_WEBSITE = "https://www.openstreetmap.org";
    public static Component parent;
    public static volatile Main main;
    @Deprecated
    public static ExecutorService worker;
    public static final Preferences pref;
    @Deprecated
    public static MapFrame map;
    @Deprecated
    public static volatile ToolbarPreferences toolbar;
    public final UndoRedoHandler undoRedo = MainApplication.undoRedo;
    @Deprecated
    public MainMenu menu;
    @Deprecated
    public MainPanel panel;
    public static final FileWatcher fileWatcher;
    private static final Map<String, Throwable> NETWORK_ERRORS;
    private static final Set<OnlineResource> OFFLINE_RESOURCES;
    @Deprecated
    public static int logLevel;
    public static volatile PlatformHook platform;
    private static volatile InitStatusListener initListener;
    private static volatile Projection proj;
    private static final List<WeakReference<ProjectionChangeListener>> listeners;

    @Deprecated
    public static boolean isDisplayingMapView() {
        return MainApplication.isDisplayingMapView();
    }

    @Deprecated
    public static final Collection<String> getLastErrorAndWarnings() {
        return Logging.getLastErrorAndWarnings();
    }

    @Deprecated
    public static void clearLastErrorAndWarnings() {
        Logging.clearLastErrorAndWarnings();
    }

    @Deprecated
    public static void error(String string) {
        Logging.error(string);
    }

    @Deprecated
    public static void warn(String string) {
        Logging.warn(string);
    }

    @Deprecated
    public static void info(String string) {
        Logging.info(string);
    }

    @Deprecated
    public static void debug(String string) {
        Logging.debug(string);
    }

    @Deprecated
    public static void trace(String string) {
        Logging.trace(string);
    }

    @Deprecated
    public static boolean isDebugEnabled() {
        return Logging.isDebugEnabled();
    }

    @Deprecated
    public static boolean isTraceEnabled() {
        return Logging.isTraceEnabled();
    }

    @Deprecated
    public static void error(String string, Object ... objectArray) {
        Logging.error(string, objectArray);
    }

    @Deprecated
    public static void warn(String string, Object ... objectArray) {
        Logging.warn(string, objectArray);
    }

    @Deprecated
    public static void info(String string, Object ... objectArray) {
        Logging.info(string, objectArray);
    }

    @Deprecated
    public static void debug(String string, Object ... objectArray) {
        Logging.debug(string, objectArray);
    }

    @Deprecated
    public static void trace(String string, Object ... objectArray) {
        Logging.trace(string, objectArray);
    }

    @Deprecated
    public static void error(Throwable throwable) {
        Logging.error(throwable);
    }

    @Deprecated
    public static void warn(Throwable throwable) {
        Logging.warn(throwable);
    }

    @Deprecated
    public static void debug(Throwable throwable) {
        Logging.debug(throwable);
    }

    @Deprecated
    public static void trace(Throwable throwable) {
        Logging.trace(throwable);
    }

    @Deprecated
    public static void error(Throwable throwable, boolean bl) {
        if (bl) {
            Logging.log(Logging.LEVEL_ERROR, throwable);
        } else {
            Logging.logWithStackTrace(Logging.LEVEL_ERROR, throwable);
        }
    }

    @Deprecated
    public static void error(Throwable throwable, String string) {
        Logging.log(Logging.LEVEL_ERROR, string, throwable);
    }

    @Deprecated
    public static void warn(Throwable throwable, boolean bl) {
        if (bl) {
            Logging.log(Logging.LEVEL_WARN, throwable);
        } else {
            Logging.logWithStackTrace(Logging.LEVEL_WARN, throwable);
        }
    }

    @Deprecated
    public static void warn(Throwable throwable, String string) {
        Logging.log(Logging.LEVEL_WARN, string, throwable);
    }

    @Deprecated
    public static String getErrorMessage(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        return Logging.getErrorMessage(throwable);
    }

    public static void setInitStatusListener(InitStatusListener initStatusListener) {
        CheckParameterUtil.ensureParameterNotNull(initStatusListener);
        initListener = initStatusListener;
    }

    protected Main() {
        Main.setInstance(this);
    }

    private static void setInstance(Main main) {
        Main.main = main;
    }

    public void initialize() {
        Main.runInitializationTasks(this.beforeInitializationTasks());
        try {
            ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), Utils.newThreadFactory("main-init-%d", 5));
            for (Future future : executorService.invokeAll(this.parallelInitializationTasks())) {
                future.get();
            }
            this.asynchronousRunnableTasks().forEach(executorService::submit);
            this.asynchronousCallableTasks().forEach(executorService::submit);
            executorService.shutdown();
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new JosmRuntimeException(exception);
        }
        Main.runInitializationTasks(this.afterInitializationTasks());
    }

    private static void runInitializationTasks(List<InitializationTask> list) {
        for (InitializationTask initializationTask : list) {
            try {
                initializationTask.call();
            }
            catch (JosmRuntimeException josmRuntimeException) {
                BugReport.intercept(josmRuntimeException).warn();
            }
        }
    }

    protected List<InitializationTask> beforeInitializationTasks() {
        return Collections.emptyList();
    }

    protected Collection<InitializationTask> parallelInitializationTasks() {
        return Collections.emptyList();
    }

    protected List<Callable<?>> asynchronousCallableTasks() {
        return Collections.emptyList();
    }

    protected List<Runnable> asynchronousRunnableTasks() {
        return Collections.emptyList();
    }

    protected List<InitializationTask> afterInitializationTasks() {
        return Collections.emptyList();
    }

    @Deprecated
    public static MainLayerManager getLayerManager() {
        return MainApplication.getLayerManager();
    }

    public Collection<OsmPrimitive> getInProgressSelection() {
        return Collections.emptyList();
    }

    public DataSet getEditDataSet() {
        return null;
    }

    @Deprecated
    public static void registerActionShortcut(JosmAction josmAction) {
        MainApplication.registerActionShortcut(josmAction);
    }

    @Deprecated
    public static void registerActionShortcut(Action action, Shortcut shortcut) {
        MainApplication.registerActionShortcut(action, shortcut);
    }

    @Deprecated
    public static void unregisterShortcut(Shortcut shortcut) {
        MainApplication.unregisterShortcut(shortcut);
    }

    @Deprecated
    public static void unregisterActionShortcut(JosmAction josmAction) {
        MainApplication.unregisterActionShortcut(josmAction);
    }

    @Deprecated
    public static void unregisterActionShortcut(Action action, Shortcut shortcut) {
        MainApplication.unregisterActionShortcut(action, shortcut);
    }

    @Deprecated
    public static Action getRegisteredActionShortcut(Shortcut shortcut) {
        return MainApplication.getRegisteredActionShortcut(shortcut);
    }

    public static void preConstructorInit() {
        try {
            CoordinateFormat.setCoordinateFormat(CoordinateFormat.valueOf(pref.get("coordinates")));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.trace(illegalArgumentException);
            CoordinateFormat.setCoordinateFormat(CoordinateFormat.DECIMAL_DEGREES);
        }
    }

    public static boolean exitJosm(boolean bl, int n) {
        if (main != null) {
            main.shutdown();
        }
        if (bl) {
            System.exit(n);
        }
        return true;
    }

    protected void shutdown() {
        if (!GraphicsEnvironment.isHeadless()) {
            ImageProvider.shutdown(false);
            JCSCacheManager.shutdown();
        }
        try {
            pref.saveDefaults();
        }
        catch (IOException iOException) {
            Logging.log(Logging.LEVEL_WARN, I18n.tr("Failed to save default preferences.", new Object[0]), iOException);
        }
        if (!GraphicsEnvironment.isHeadless()) {
            ImageProvider.shutdown(true);
        }
    }

    public static void determinePlatformHook() {
        String string = System.getProperty("os.name");
        if (string == null) {
            Logging.warn("Your operating system has no name, so I'm guessing its some kind of *nix.");
            platform = new PlatformHookUnixoid();
        } else if (string.toLowerCase(Locale.ENGLISH).startsWith("windows")) {
            platform = new PlatformHookWindows();
        } else if ("Linux".equals(string) || "Solaris".equals(string) || "SunOS".equals(string) || "AIX".equals(string) || "FreeBSD".equals(string) || "NetBSD".equals(string) || "OpenBSD".equals(string)) {
            platform = new PlatformHookUnixoid();
        } else if (string.toLowerCase(Locale.ENGLISH).startsWith("mac os x")) {
            platform = new PlatformHookOsx();
        } else {
            Logging.warn("I don't know your operating system '" + string + "', so I'm guessing its some kind of *nix.");
            platform = new PlatformHookUnixoid();
        }
    }

    public static Projection getProjection() {
        return proj;
    }

    public static void setProjection(Projection projection) {
        CheckParameterUtil.ensureParameterNotNull(projection);
        Projection projection2 = proj;
        Bounds bounds = main != null ? main.getRealBounds() : null;
        proj = projection;
        Main.fireProjectionChanged(projection2, proj, bounds);
    }

    protected Bounds getRealBounds() {
        return null;
    }

    protected void restoreOldBounds(Bounds bounds) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void fireProjectionChanged(Projection projection, Projection projection2, Bounds bounds) {
        if (!(projection2 == null ^ projection == null) && (projection2 == null || projection == null || Objects.equals(projection2.toCode(), projection.toCode()))) return;
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            Iterator<WeakReference<ProjectionChangeListener>> iterator = listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference<ProjectionChangeListener> weakReference = iterator.next();
                ProjectionChangeListener projectionChangeListener = (ProjectionChangeListener)weakReference.get();
                if (projectionChangeListener == null) {
                    iterator.remove();
                    continue;
                }
                projectionChangeListener.projectionChanged(projection, projection2);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (projection2 == null || bounds == null || main == null) return;
            main.restoreOldBounds(bounds);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addProjectionChangeListener(ProjectionChangeListener projectionChangeListener) {
        if (projectionChangeListener == null) {
            return;
        }
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            for (WeakReference<ProjectionChangeListener> weakReference : listeners) {
                if (weakReference.get() != projectionChangeListener) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            listeners.add(new WeakReference<ProjectionChangeListener>(projectionChangeListener));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeProjectionChangeListener(ProjectionChangeListener projectionChangeListener) {
        if (projectionChangeListener == null) {
            return;
        }
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            listeners.removeIf(weakReference -> weakReference.get() == null || weakReference.get() == projectionChangeListener);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Deprecated
    public static boolean addAndFireMapFrameListener(MapFrameListener mapFrameListener) {
        return MainApplication.addAndFireMapFrameListener(mapFrameListener);
    }

    @Deprecated
    public static boolean addMapFrameListener(MapFrameListener mapFrameListener) {
        return MainApplication.addMapFrameListener(mapFrameListener);
    }

    @Deprecated
    public static boolean removeMapFrameListener(MapFrameListener mapFrameListener) {
        return MainApplication.removeMapFrameListener(mapFrameListener);
    }

    public static Throwable addNetworkError(URL uRL, Throwable throwable) {
        if (uRL != null && throwable != null) {
            Throwable throwable2 = Main.addNetworkError(uRL.toExternalForm(), throwable);
            if (throwable2 != null) {
                Logging.warn("Already here " + throwable2);
            }
            return throwable2;
        }
        return null;
    }

    public static Throwable addNetworkError(String string, Throwable throwable) {
        if (string != null && throwable != null) {
            return NETWORK_ERRORS.put(string, throwable);
        }
        return null;
    }

    public static Map<String, Throwable> getNetworkErrors() {
        return new HashMap<String, Throwable>(NETWORK_ERRORS);
    }

    public static void clearNetworkErrors() {
        NETWORK_ERRORS.clear();
    }

    public static String getJOSMWebsite() {
        if (pref != null) {
            return pref.get("josm.url", JOSM_WEBSITE);
        }
        return JOSM_WEBSITE;
    }

    public static String getXMLBase() {
        return "http://josm.openstreetmap.de";
    }

    public static String getOSMWebsite() {
        if (pref != null) {
            return pref.get("osm.url", OSM_WEBSITE);
        }
        return OSM_WEBSITE;
    }

    private static String getOSMWebsiteDependingOnSelectedApi() {
        String string = OsmApi.getOsmApi().getServerUrl();
        if ("https://api.openstreetmap.org/api".equals(string)) {
            return Main.getOSMWebsite();
        }
        return string.replaceAll("/api$", "");
    }

    public static String getBaseBrowseUrl() {
        if (pref != null) {
            return pref.get("osm-browse.url", Main.getOSMWebsiteDependingOnSelectedApi());
        }
        return Main.getOSMWebsiteDependingOnSelectedApi();
    }

    public static String getBaseUserUrl() {
        if (pref != null) {
            return pref.get("osm-user.url", Main.getOSMWebsiteDependingOnSelectedApi() + "/user");
        }
        return Main.getOSMWebsiteDependingOnSelectedApi() + "/user";
    }

    public static boolean isPlatformOsx() {
        return platform instanceof PlatformHookOsx;
    }

    public static boolean isPlatformWindows() {
        return platform instanceof PlatformHookWindows;
    }

    public static boolean isOffline(OnlineResource onlineResource) {
        return OFFLINE_RESOURCES.contains((Object)onlineResource) || OFFLINE_RESOURCES.contains((Object)OnlineResource.ALL);
    }

    public static boolean setOffline(OnlineResource onlineResource) {
        return OFFLINE_RESOURCES.add(onlineResource);
    }

    public static boolean setOnline(OnlineResource onlineResource) {
        return OFFLINE_RESOURCES.remove((Object)onlineResource);
    }

    public static Set<OnlineResource> getOfflineResources() {
        return EnumSet.copyOf(OFFLINE_RESOURCES);
    }

    static {
        pref = new Preferences();
        fileWatcher = new FileWatcher();
        NETWORK_ERRORS = new HashMap<String, Throwable>();
        OFFLINE_RESOURCES = EnumSet.noneOf(OnlineResource.class);
        logLevel = 3;
        listeners = new ArrayList<WeakReference<ProjectionChangeListener>>();
    }

    public static interface WindowSwitchListener {
        public void toOtherApplication();

        public void fromOtherApplication();
    }

    protected static final class InitializationTask
    implements Callable<Void> {
        private final String name;
        private final Runnable task;

        public InitializationTask(String string, Runnable runnable) {
            this.name = string;
            this.task = runnable;
        }

        @Override
        public Void call() {
            Object object = null;
            if (initListener != null) {
                object = initListener.updateStatus(this.name);
            }
            this.task.run();
            if (initListener != null) {
                initListener.finish(object);
            }
            return null;
        }
    }

    public static interface InitStatusListener {
        public Object updateStatus(String var1);

        public void finish(Object var1);
    }
}

