/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UserCancelException;
import org.openstreetmap.josm.tools.Utils;

public class UnGlueAction
extends JosmAction {
    private transient Node selectedNode;
    private transient Way selectedWay;
    private transient Set<Node> selectedNodes;

    public UnGlueAction() {
        super(I18n.tr("UnGlue Ways", new Object[0]), "unglueways", I18n.tr("Duplicate nodes that are used by multiple ways.", new Object[0]), Shortcut.registerShortcut("tools:unglue", I18n.tr("Tool: {0}", I18n.tr("UnGlue Ways", new Object[0])), 71, 5003), true);
        this.putValue("help", HelpUtil.ht("/Action/UnGlue"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.unglue(actionEvent);
        }
        catch (UserCancelException userCancelException) {
            Logging.trace(userCancelException);
        }
        finally {
            this.cleanup();
        }
    }

    protected void unglue(ActionEvent actionEvent) throws UserCancelException {
        Collection<OsmPrimitive> collection = this.getLayerManager().getEditDataSet().getSelected();
        String string = null;
        int n = Notification.TIME_DEFAULT;
        if (this.checkSelectionOneNodeAtMostOneWay(collection)) {
            this.checkAndConfirmOutlyingUnglue();
            int n2 = 0;
            for (Way way : this.selectedNode.getParentWays()) {
                if (!way.isUsable() || way.getNodesCount() < 1) continue;
                ++n2;
            }
            if (n2 < 2) {
                boolean bl = false;
                if (n2 == 1) {
                    bl = this.unglueSelfCrossingWay();
                }
                if (!bl) {
                    if (this.checkForUnglueNode(collection)) {
                        this.unglueOneNodeAtMostOneWay(actionEvent);
                    } else {
                        n = Notification.TIME_SHORT;
                        string = I18n.tr("This node is not glued to anything else.", new Object[0]);
                    }
                }
            } else {
                this.unglueWays();
            }
        } else if (this.checkSelectionOneWayAnyNodes(collection)) {
            this.checkAndConfirmOutlyingUnglue();
            HashSet<Node> hashSet = new HashSet<Node>();
            for (Node node : this.selectedNodes) {
                int n3 = 0;
                for (Way way : node.getParentWays()) {
                    if (!way.isUsable()) continue;
                    ++n3;
                }
                if (n3 < 2) continue;
                hashSet.add(node);
            }
            if (hashSet.isEmpty()) {
                string = collection.size() > 1 ? I18n.tr("None of these nodes are glued to anything else.", new Object[0]) : I18n.tr("None of this way''s nodes are glued to anything else.", new Object[0]);
            } else {
                this.selectedNodes = hashSet;
                this.unglueOneWayAnyNodes();
            }
        } else {
            n = Notification.TIME_VERY_LONG;
            string = I18n.tr("The current selection cannot be used for unglueing.", new Object[0]) + '\n' + '\n' + I18n.tr("Select either:", new Object[0]) + '\n' + I18n.tr("* One tagged node, or", new Object[0]) + '\n' + I18n.tr("* One node that is used by more than one way, or", new Object[0]) + '\n' + I18n.tr("* One node that is used by more than one way and one of those ways, or", new Object[0]) + '\n' + I18n.tr("* One way that has one or more nodes that are used by more than one way, or", new Object[0]) + '\n' + I18n.tr("* One way and one or more of its nodes that are used by more than one way.", new Object[0]) + '\n' + '\n' + I18n.tr("Note: If a way is selected, this way will get fresh copies of the unglued\nnodes and the new nodes will be selected. Otherwise, all ways will get their\nown copy and all nodes will be selected.", new Object[0]);
        }
        if (string != null) {
            new Notification(string).setIcon(0).setDuration(n).show();
        }
    }

    private void cleanup() {
        this.selectedNode = null;
        this.selectedWay = null;
        this.selectedNodes = null;
    }

    private void unglueOneNodeAtMostOneWay(ActionEvent actionEvent) {
        PropertiesMembershipDialog propertiesMembershipDialog;
        try {
            propertiesMembershipDialog = PropertiesMembershipDialog.showIfNecessary(Collections.singleton(this.selectedNode), true);
        }
        catch (UserCancelException userCancelException) {
            Logging.trace(userCancelException);
            return;
        }
        Node node = new Node(this.selectedNode, true);
        LinkedList<Command> linkedList = new LinkedList<Command>();
        linkedList.add(new AddCommand(node));
        if (propertiesMembershipDialog != null) {
            propertiesMembershipDialog.update(this.selectedNode, Collections.singletonList(node), linkedList);
        }
        MapView mapView = MainApplication.getMap().mapView;
        if (actionEvent.getSource() instanceof JPanel) {
            node.setCoor(mapView.getLatLon(mapView.lastMEvent.getX(), mapView.lastMEvent.getY()));
        }
        MainApplication.undoRedo.add(new SequenceCommand(I18n.tr("Unglued Node", new Object[0]), linkedList));
        this.getLayerManager().getEditDataSet().setSelected(node);
        mapView.repaint();
    }

    private boolean checkForUnglueNode(Collection<? extends OsmPrimitive> collection) {
        if (collection.size() != 1) {
            return false;
        }
        OsmPrimitive osmPrimitive = (OsmPrimitive)collection.toArray()[0];
        if (!(osmPrimitive instanceof Node)) {
            return false;
        }
        if (((Node)osmPrimitive).getParentWays().isEmpty()) {
            return false;
        }
        this.selectedNode = (Node)osmPrimitive;
        return this.selectedNode.isTagged();
    }

    private boolean checkSelectionOneNodeAtMostOneWay(Collection<? extends OsmPrimitive> collection) {
        int n = collection.size();
        if (n < 1 || n > 2) {
            return false;
        }
        this.selectedNode = null;
        this.selectedWay = null;
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive instanceof Node) {
                this.selectedNode = (Node)osmPrimitive;
                if (n != 1 && this.selectedWay == null) continue;
                return n == 1 || this.selectedWay.containsNode(this.selectedNode);
            }
            if (!(osmPrimitive instanceof Way)) continue;
            this.selectedWay = (Way)osmPrimitive;
            if (n != 2 || this.selectedNode == null) continue;
            return this.selectedWay.containsNode(this.selectedNode);
        }
        return false;
    }

    private boolean checkSelectionOneWayAnyNodes(Collection<? extends OsmPrimitive> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        this.selectedWay = null;
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Way)) continue;
            if (this.selectedWay != null) {
                return false;
            }
            this.selectedWay = (Way)osmPrimitive;
        }
        if (this.selectedWay == null) {
            return false;
        }
        this.selectedNodes = new HashSet<Node>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Node)) continue;
            Node node = (Node)osmPrimitive;
            if (!this.selectedWay.containsNode(node)) {
                return false;
            }
            this.selectedNodes.add(node);
        }
        if (this.selectedNodes.isEmpty()) {
            this.selectedNodes.addAll(this.selectedWay.getNodes());
        }
        return true;
    }

    private static Way modifyWay(Node node, Way way, List<Command> list, List<Node> list2) {
        Node node2 = new Node(node, true);
        list2.add(node2);
        list.add(new AddCommand(node2));
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node3 : way.getNodes()) {
            if (node == node3) {
                node3 = node2;
            }
            arrayList.add(node3);
        }
        Way way2 = new Way(way);
        way2.setNodes(arrayList);
        return way2;
    }

    private static void fixRelations(Node node, Collection<Command> collection, List<Node> list, boolean bl) {
        for (Relation relation : OsmPrimitive.getFilteredList(node.getReferrers(), Relation.class)) {
            if (relation.isDeleted()) continue;
            Relation relation2 = null;
            HashMap<String, Integer> hashMap = null;
            int n = 0;
            for (RelationMember relationMember : relation.getMembers()) {
                if (relationMember.isNode() && relationMember.getMember() == node) {
                    if (relation2 == null) {
                        relation2 = new Relation(relation);
                        hashMap = new HashMap<String, Integer>();
                    }
                    if (hashMap != null) {
                        hashMap.put(relationMember.getRole(), n);
                    }
                }
                ++n;
            }
            if (relation2 == null) continue;
            if (hashMap != null) {
                for (Map.Entry entry : hashMap.entrySet()) {
                    for (Node node2 : list) {
                        relation2.addMember((Integer)entry.getValue() + 1, new RelationMember((String)entry.getKey(), node2));
                    }
                    if (!bl) continue;
                    relation2.removeMember((Integer)entry.getValue());
                }
            }
            collection.add(new ChangeCommand(relation, relation2));
        }
    }

    private void unglueWays() {
        PropertiesMembershipDialog propertiesMembershipDialog;
        try {
            propertiesMembershipDialog = PropertiesMembershipDialog.showIfNecessary(Collections.singleton(this.selectedNode), false);
        }
        catch (UserCancelException userCancelException) {
            Logging.trace(userCancelException);
            return;
        }
        LinkedList<Command> linkedList = new LinkedList<Command>();
        LinkedList<Node> linkedList2 = new LinkedList<Node>();
        if (this.selectedWay == null) {
            Way way = null;
            LinkedList<Way> linkedList3 = new LinkedList<Way>();
            for (OsmPrimitive osmPrimitive : this.selectedNode.getReferrers()) {
                if (!osmPrimitive.isUsable() || !(osmPrimitive instanceof Way)) continue;
                Way way2 = (Way)osmPrimitive;
                if (way == null && !way2.isFirstLastNode(this.selectedNode)) {
                    way = way2;
                    continue;
                }
                linkedList3.add(way2);
            }
            if (way == null) {
                linkedList3.removeFirst();
            }
            for (Way way3 : linkedList3) {
                linkedList.add(new ChangeCommand(way3, UnGlueAction.modifyWay(this.selectedNode, way3, linkedList, linkedList2)));
            }
            this.notifyWayPartOfRelation(linkedList3);
        } else {
            linkedList.add(new ChangeCommand(this.selectedWay, UnGlueAction.modifyWay(this.selectedNode, this.selectedWay, linkedList, linkedList2)));
            this.notifyWayPartOfRelation(Collections.singleton(this.selectedWay));
        }
        if (propertiesMembershipDialog != null) {
            propertiesMembershipDialog.update(this.selectedNode, linkedList2, linkedList);
        }
        this.execCommands(linkedList, linkedList2);
    }

    private void execCommands(List<Command> list, List<Node> list2) {
        MainApplication.undoRedo.add(new SequenceCommand(I18n.trn("Dupe into {0} node", "Dupe into {0} nodes", (long)list2.size() + 1L, (long)list2.size() + 1L), list));
        this.getLayerManager().getEditDataSet().setSelected(list2.get(0));
    }

    private boolean unglueSelfCrossingWay() {
        Way object2 = null;
        for (Way object3 : this.selectedNode.getParentWays()) {
            if (!object3.isUsable() || object3.getNodesCount() < 1) continue;
            object2 = object3;
        }
        if (object2 == null) {
            return false;
        }
        LinkedList linkedList = new LinkedList();
        List<Node> list = object2.getNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>(list.size());
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        boolean bl = false;
        for (Node node : list) {
            if (node == this.selectedNode) {
                if (bl) {
                    Node node2 = new Node(node, true);
                    linkedList.add(new AddCommand(node2));
                    arrayList.add(node2);
                    arrayList2.add(node2);
                    continue;
                }
                arrayList.add(node);
                bl = true;
                continue;
            }
            arrayList.add(node);
        }
        if (arrayList2.isEmpty()) {
            return false;
        }
        linkedList.add(new ChangeNodesCommand(object2, arrayList));
        this.notifyWayPartOfRelation(Collections.singleton(object2));
        try {
            PropertiesMembershipDialog userCancelException = PropertiesMembershipDialog.showIfNecessary(Collections.singleton(this.selectedNode), false);
            if (userCancelException != null) {
                userCancelException.update(this.selectedNode, arrayList2, linkedList);
            }
            this.execCommands(linkedList, arrayList2);
            return true;
        }
        catch (UserCancelException userCancelException) {
            Logging.trace(userCancelException);
            return false;
        }
    }

    private void unglueOneWayAnyNodes() {
        PropertiesMembershipDialog propertiesMembershipDialog;
        Way way = this.selectedWay;
        try {
            propertiesMembershipDialog = PropertiesMembershipDialog.showIfNecessary(this.selectedNodes, false);
        }
        catch (UserCancelException userCancelException) {
            Logging.trace(userCancelException);
            return;
        }
        LinkedList<Command> linkedList = new LinkedList<Command>();
        LinkedList<Node> linkedList2 = new LinkedList<Node>();
        for (Node node : this.selectedNodes) {
            LinkedList<Node> linkedList3 = new LinkedList<Node>();
            way = UnGlueAction.modifyWay(node, way, linkedList, linkedList3);
            if (propertiesMembershipDialog != null) {
                propertiesMembershipDialog.update(node, linkedList3, linkedList);
            }
            linkedList2.addAll(linkedList3);
        }
        linkedList.add(new ChangeCommand(this.selectedWay, way));
        this.notifyWayPartOfRelation(Collections.singleton(this.selectedWay));
        MainApplication.undoRedo.add(new SequenceCommand(I18n.trn("Dupe {0} node into {1} nodes", "Dupe {0} nodes into {1} nodes", this.selectedNodes.size(), this.selectedNodes.size(), this.selectedNodes.size() + linkedList2.size()), linkedList));
        this.getLayerManager().getEditDataSet().setSelected(linkedList2);
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    protected void checkAndConfirmOutlyingUnglue() throws UserCancelException {
        boolean bl;
        ArrayList<Node> arrayList = new ArrayList<Node>(2 + (this.selectedNodes == null ? 0 : this.selectedNodes.size()));
        if (this.selectedNodes != null) {
            arrayList.addAll(this.selectedNodes);
        }
        if (this.selectedNode != null) {
            arrayList.add(this.selectedNode);
        }
        if (!(bl = Command.checkAndConfirmOutlyingOperation("unglue", I18n.tr("Unglue confirmation", new Object[0]), I18n.tr("You are about to unglue nodes outside of the area you have downloaded.<br>This can cause problems because other objects (that you do not see) might use them.<br>Do you really want to unglue?", new Object[0]), I18n.tr("You are about to unglue incomplete objects.<br>This will cause problems because you don''t see the real object.<br>Do you really want to unglue?", new Object[0]), arrayList, null))) {
            throw new UserCancelException();
        }
    }

    protected void notifyWayPartOfRelation(Iterable<Way> iterable) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Way object2 : iterable) {
            for (OsmPrimitive osmPrimitive : object2.getReferrers()) {
                if (!(osmPrimitive instanceof Relation) || !osmPrimitive.isUsable()) continue;
                hashSet.add(osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()));
            }
        }
        if (hashSet.isEmpty()) {
            return;
        }
        String string = I18n.trn("Unglueing affected {0} relation: {1}", "Unglueing affected {0} relations: {1}", hashSet.size(), hashSet.size(), Utils.joinAsHtmlUnorderedList(hashSet));
        String string2 = I18n.trn("Ensure that the relation has not been broken!", "Ensure that the relations have not been broken!", hashSet.size(), new Object[0]);
        new Notification("<html>" + (String)string + string2).setIcon(2).show();
    }

    static final class PropertiesMembershipDialog
    extends ExtendedDialog {
        final transient ExistingBothNewChoice tags;
        final transient ExistingBothNewChoice memberships;

        private PropertiesMembershipDialog(boolean bl, boolean bl2, boolean bl3) {
            super(Main.parent, I18n.tr("Tags / Memberships", new Object[0]), I18n.tr("Unglue", new Object[0]), I18n.tr("Cancel", new Object[0]));
            this.setButtonIcons("unglueways", "cancel");
            JPanel jPanel = new JPanel(new GridBagLayout());
            if (bl2) {
                jPanel.add((Component)new JLabel(I18n.tr("Where should the tags of the node be put?", new Object[0])), GBC.std(1, 1).span(3).insets(0, 20, 0, 0));
                this.tags = new ExistingBothNewChoice(bl);
                jPanel.add((Component)this.tags.oldNode, GBC.std(1, 2));
                jPanel.add((Component)this.tags.bothNodes, GBC.std(2, 2));
                jPanel.add((Component)this.tags.newNode, GBC.std(3, 2));
            } else {
                this.tags = null;
            }
            if (bl3) {
                jPanel.add((Component)new JLabel(I18n.tr("Where should the memberships of this node be put?", new Object[0])), GBC.std(1, 3).span(3).insets(0, 20, 0, 0));
                this.memberships = new ExistingBothNewChoice(bl);
                jPanel.add((Component)this.memberships.oldNode, GBC.std(1, 4));
                jPanel.add((Component)this.memberships.bothNodes, GBC.std(2, 4));
                jPanel.add((Component)this.memberships.newNode, GBC.std(3, 4));
            } else {
                this.memberships = null;
            }
            this.setContent(jPanel);
            this.setResizable(false);
        }

        static PropertiesMembershipDialog showIfNecessary(Collection<Node> collection, boolean bl) throws UserCancelException {
            boolean bl2 = PropertiesMembershipDialog.isTagged(collection);
            boolean bl3 = PropertiesMembershipDialog.isUsedInRelations(collection);
            if (bl2 || bl3) {
                PropertiesMembershipDialog propertiesMembershipDialog = new PropertiesMembershipDialog(bl, bl2, bl3);
                propertiesMembershipDialog.showDialog();
                if (propertiesMembershipDialog.getValue() != 1) {
                    throw new UserCancelException();
                }
                return propertiesMembershipDialog;
            }
            return null;
        }

        private static boolean isTagged(Collection<Node> collection) {
            return collection.stream().anyMatch(AbstractPrimitive::hasKeys);
        }

        private static boolean isUsedInRelations(Collection<Node> collection) {
            return collection.stream().anyMatch(node -> node.getReferrers().stream().anyMatch(Relation.class::isInstance));
        }

        void update(Node node, List<Node> list, Collection<Command> collection) {
            this.updateMemberships(node, list, collection);
            this.updateProperties(node, list, collection);
        }

        private void updateProperties(Node node, Iterable<Node> iterable, Collection<Command> collection) {
            if (this.tags != null && this.tags.newNode.isSelected()) {
                Node node2 = new Node(node);
                node2.removeAll();
                collection.add(new ChangeCommand(node, node2));
            } else if (this.tags != null && this.tags.oldNode.isSelected()) {
                for (Node node3 : iterable) {
                    node3.removeAll();
                }
            }
        }

        private void updateMemberships(Node node, List<Node> list, Collection<Command> collection) {
            if (this.memberships != null && this.memberships.bothNodes.isSelected()) {
                UnGlueAction.fixRelations(node, collection, list, false);
            } else if (this.memberships != null && this.memberships.newNode.isSelected()) {
                UnGlueAction.fixRelations(node, collection, list, true);
            }
        }
    }

    private static class ExistingBothNewChoice {
        final AbstractButton oldNode = new JToggleButton(I18n.tr("Existing node", new Object[0]), ImageProvider.get("dialogs/conflict/tagkeeptheir"));
        final AbstractButton bothNodes = new JToggleButton(I18n.tr("Both nodes", new Object[0]), ImageProvider.get("dialogs/conflict/tagundecide"));
        final AbstractButton newNode = new JToggleButton(I18n.tr("New node", new Object[0]), ImageProvider.get("dialogs/conflict/tagkeepmine"));

        ExistingBothNewChoice(boolean bl) {
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.oldNode);
            buttonGroup.add(this.bothNodes);
            buttonGroup.add(this.newNode);
            buttonGroup.setSelected((bl ? this.newNode : this.oldNode).getModel(), true);
        }
    }
}

