/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.util.concurrent.Future;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class DownloadOsmCompressedTask
extends DownloadOsmTask {
    private static final String PATTERN_COMPRESS = "https?://.*/.*\\.osm.(gz|bz2?|zip)";

    @Override
    public String[] getPatterns() {
        return new String[]{PATTERN_COMPRESS};
    }

    @Override
    public String getTitle() {
        return I18n.tr("Download Compressed OSM", new Object[0]);
    }

    @Override
    public Future<?> download(boolean bl, Bounds bounds, ProgressMonitor progressMonitor) {
        return null;
    }

    @Override
    public Future<?> loadUrl(boolean bl, final String string, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadOsmTask.DownloadTask(bl, (OsmServerReader)new OsmServerLocationReader(string), progressMonitor){

            @Override
            protected DataSet parseDataSet() throws OsmTransferException {
                ProgressMonitor progressMonitor = this.progressMonitor.createSubTaskMonitor(-1, false);
                if (string.matches("https?://.*/.*\\.osm.bz2?")) {
                    return this.reader.parseOsmBzip2(progressMonitor);
                }
                if (string.matches("https?://.*/.*\\.osm.gz")) {
                    return this.reader.parseOsmGzip(progressMonitor);
                }
                return this.reader.parseOsmZip(progressMonitor);
            }
        };
        this.currentBounds = null;
        this.extractOsmFilename("https?://.*/(.*\\.osm.(gz|bz2?|zip))", string);
        return MainApplication.worker.submit(this.downloadTask);
    }
}

