/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchMode;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public class FilterMatcher {
    private final List<FilterInfo> hiddenFilters = new ArrayList<FilterInfo>();
    private final List<FilterInfo> disabledFilters = new ArrayList<FilterInfo>();

    public void update(Collection<Filter> collection) throws SearchParseError {
        this.reset();
        for (Filter filter : collection) {
            this.add(filter);
        }
    }

    public void reset() {
        this.hiddenFilters.clear();
        this.disabledFilters.clear();
    }

    public void add(Filter filter) throws SearchParseError {
        if (!filter.enable) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo(filter);
        if (filterInfo.isDelete) {
            if (filter.hiding) {
                this.hiddenFilters.add(filterInfo);
            } else {
                this.disabledFilters.add(filterInfo);
                this.hiddenFilters.add(filterInfo);
            }
        } else {
            if (filter.mode == SearchMode.replace && filter.hiding) {
                this.hiddenFilters.clear();
                this.disabledFilters.clear();
            }
            this.disabledFilters.add(filterInfo);
            if (filter.hiding) {
                this.hiddenFilters.add(filterInfo);
            }
        }
    }

    private static boolean isFiltered(OsmPrimitive osmPrimitive, boolean bl) {
        return bl ? osmPrimitive.isDisabledAndHidden() : osmPrimitive.isDisabled();
    }

    private static boolean isFilterExplicit(OsmPrimitive osmPrimitive, boolean bl) {
        return bl ? osmPrimitive.getHiddenType() : osmPrimitive.getDisabledType();
    }

    private static boolean allParentWaysFiltered(OsmPrimitive osmPrimitive, boolean bl) {
        List<OsmPrimitive> list = osmPrimitive.getReferrers();
        boolean bl2 = false;
        for (OsmPrimitive osmPrimitive2 : list) {
            if (!(osmPrimitive2 instanceof Way)) continue;
            if (!FilterMatcher.isFiltered(osmPrimitive2, bl)) {
                return false;
            }
            bl2 |= FilterMatcher.isFilterExplicit(osmPrimitive2, bl);
        }
        return bl2;
    }

    private static boolean oneParentWayNotFiltered(OsmPrimitive osmPrimitive, boolean bl) {
        List<OsmPrimitive> list = osmPrimitive.getReferrers();
        for (OsmPrimitive osmPrimitive2 : list) {
            if (!(osmPrimitive2 instanceof Way) || FilterMatcher.isFiltered(osmPrimitive2, bl)) continue;
            return true;
        }
        return false;
    }

    private static boolean allParentMultipolygonsFiltered(OsmPrimitive osmPrimitive, boolean bl) {
        boolean bl2 = false;
        for (Relation relation : new SubclassFilteredCollection(osmPrimitive.getReferrers(), OsmPrimitive::isMultipolygon)) {
            if (!FilterMatcher.isFiltered(relation, bl)) {
                return false;
            }
            bl2 |= FilterMatcher.isFilterExplicit(relation, bl);
        }
        return bl2;
    }

    private static boolean oneParentMultipolygonNotFiltered(OsmPrimitive osmPrimitive, boolean bl) {
        for (Relation relation : new SubclassFilteredCollection(osmPrimitive.getReferrers(), OsmPrimitive::isMultipolygon)) {
            if (FilterMatcher.isFiltered(relation, bl)) continue;
            return true;
        }
        return false;
    }

    private static FilterType test(List<FilterInfo> list, OsmPrimitive osmPrimitive, boolean bl) {
        MapFrame mapFrame = MainApplication.getMap();
        if (osmPrimitive.isIncomplete() || mapFrame != null && mapFrame.mapMode != null && mapFrame.mapMode.getPreservedPrimitives().contains(osmPrimitive)) {
            return FilterType.NOT_FILTERED;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (FilterInfo filterInfo : list) {
            if (filterInfo.isDelete) {
                if (!bl2 || !filterInfo.match.match(osmPrimitive)) continue;
                bl2 = false;
                continue;
            }
            if (bl2 && (bl3 || filterInfo.isInverted) || !filterInfo.match.match(osmPrimitive)) continue;
            bl2 = true;
            if (filterInfo.isInverted) continue;
            bl3 = true;
        }
        if (osmPrimitive instanceof Node) {
            if (bl2) {
                if (bl3) {
                    return FilterType.PASSIV;
                }
                if (FilterMatcher.oneParentWayNotFiltered(osmPrimitive, bl)) {
                    return FilterType.NOT_FILTERED;
                }
                return FilterType.PASSIV;
            }
            if (!osmPrimitive.isTagged() && FilterMatcher.allParentWaysFiltered(osmPrimitive, bl)) {
                return FilterType.PASSIV;
            }
            return FilterType.NOT_FILTERED;
        }
        if (osmPrimitive instanceof Way) {
            if (bl2) {
                if (bl3) {
                    return FilterType.EXPLICIT;
                }
                if (FilterMatcher.oneParentMultipolygonNotFiltered(osmPrimitive, bl)) {
                    return FilterType.NOT_FILTERED;
                }
                return FilterType.PASSIV;
            }
            if (!osmPrimitive.isTagged() && FilterMatcher.allParentMultipolygonsFiltered(osmPrimitive, bl)) {
                return FilterType.EXPLICIT;
            }
            return FilterType.NOT_FILTERED;
        }
        if (bl2) {
            return bl3 ? FilterType.EXPLICIT : FilterType.PASSIV;
        }
        return FilterType.NOT_FILTERED;
    }

    public FilterType isHidden(OsmPrimitive osmPrimitive) {
        return FilterMatcher.test(this.hiddenFilters, osmPrimitive, true);
    }

    public FilterType isDisabled(OsmPrimitive osmPrimitive) {
        return FilterMatcher.test(this.disabledFilters, osmPrimitive, false);
    }

    public static FilterMatcher of(Filter ... filterArray) throws SearchParseError {
        FilterMatcher filterMatcher = new FilterMatcher();
        for (Filter filter : filterArray) {
            filterMatcher.add(filter);
        }
        return filterMatcher;
    }

    private static class FilterInfo {
        private final SearchCompiler.Match match;
        private final boolean isDelete;
        private final boolean isInverted;

        FilterInfo(Filter filter) throws SearchParseError {
            this.isDelete = filter.mode == SearchMode.remove || filter.mode == SearchMode.in_selection;
            SearchCompiler.Match match = SearchCompiler.compile(filter);
            this.match = filter.inverted ? new SearchCompiler.Not(match) : match;
            this.isInverted = filter.inverted;
        }
    }

    public static enum FilterType {
        NOT_FILTERED,
        EXPLICIT,
        PASSIV;

    }
}

