/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class TagCollection
implements Iterable<Tag>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Tag, Integer> tags = new HashMap<Tag, Integer>();
    private static final Pattern SPLIT_VALUES_PATTERN = Pattern.compile(";\\s*");

    public static TagCollection from(Tagged tagged) {
        TagCollection tagCollection = new TagCollection();
        if (tagged != null) {
            for (String string : tagged.keySet()) {
                tagCollection.add(new Tag(string, tagged.get(string)));
            }
        }
        return tagCollection;
    }

    public static TagCollection from(Map<String, String> map) {
        TagCollection tagCollection = new TagCollection();
        if (map == null) {
            return tagCollection;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey() == null ? "" : entry.getKey();
            String string2 = entry.getValue() == null ? "" : entry.getValue();
            tagCollection.add(new Tag(string, string2));
        }
        return tagCollection;
    }

    public static TagCollection unionOfAllPrimitives(Collection<? extends Tagged> collection) {
        TagCollection tagCollection = new TagCollection();
        if (collection == null) {
            return tagCollection;
        }
        for (Tagged tagged : collection) {
            if (tagged == null) continue;
            tagCollection.add(TagCollection.from(tagged));
        }
        return tagCollection;
    }

    public static TagCollection commonToAllPrimitives(Collection<? extends Tagged> collection) {
        TagCollection tagCollection = new TagCollection();
        if (collection == null || collection.isEmpty()) {
            return tagCollection;
        }
        tagCollection.add(TagCollection.from(collection.iterator().next()));
        for (Tagged tagged : collection) {
            if (tagged == null) continue;
            tagCollection.add(tagCollection.intersect(TagCollection.from(tagged)));
        }
        return tagCollection;
    }

    public static TagCollection unionOfAllPrimitives(DataSet dataSet) {
        TagCollection tagCollection = new TagCollection();
        if (dataSet == null) {
            return tagCollection;
        }
        tagCollection.add(TagCollection.unionOfAllPrimitives(dataSet.allPrimitives()));
        return tagCollection;
    }

    public TagCollection() {
    }

    public TagCollection(TagCollection tagCollection) {
        if (tagCollection != null) {
            this.tags.putAll(tagCollection.tags);
        }
    }

    public TagCollection(Collection<Tag> collection) {
        this.add(collection);
    }

    public int size() {
        return this.tags.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public final void add(Tag tag) {
        if (tag != null) {
            this.tags.merge(tag, 1, (n, n2) -> n + n2);
        }
    }

    public int getTagOccurence(Tag tag) {
        return this.tags.getOrDefault(tag, 0);
    }

    public final void add(Collection<Tag> collection) {
        if (collection == null) {
            return;
        }
        for (Tag tag : collection) {
            this.add(tag);
        }
    }

    public final void add(TagCollection tagCollection) {
        if (tagCollection != null) {
            for (Map.Entry<Tag, Integer> entry : tagCollection.tags.entrySet()) {
                this.tags.merge(entry.getKey(), entry.getValue(), (n, n2) -> n + n2);
            }
        }
    }

    public void remove(Tag tag) {
        if (tag == null) {
            return;
        }
        this.tags.remove(tag);
    }

    public void remove(Collection<Tag> collection) {
        if (collection != null) {
            collection.stream().forEach(this::remove);
        }
    }

    public void remove(TagCollection tagCollection) {
        if (tagCollection != null) {
            tagCollection.tags.keySet().stream().forEach(this::remove);
        }
    }

    public void removeByKey(String string) {
        if (string != null) {
            this.tags.keySet().removeIf(tag -> tag.matchesKey(string));
        }
    }

    public void removeByKey(Collection<String> collection) {
        if (collection == null) {
            return;
        }
        for (String string : collection) {
            this.removeByKey(string);
        }
    }

    public boolean contains(Tag tag) {
        return this.tags.containsKey(tag);
    }

    public boolean containsAll(Collection<Tag> collection) {
        if (collection == null) {
            return false;
        }
        return this.tags.keySet().containsAll(collection);
    }

    public boolean containsAllKeys(Collection<String> collection) {
        if (collection == null) {
            return false;
        }
        return collection.stream().filter(Objects::nonNull).allMatch(this::hasTagsFor);
    }

    public int getNumTagsFor(String string) {
        return (int)this.generateStreamForKey(string).count();
    }

    public boolean hasTagsFor(String string) {
        return this.getNumTagsFor(string) > 0;
    }

    public boolean hasValuesFor(String string) {
        return this.generateStreamForKey(string).anyMatch(tag -> !tag.getValue().isEmpty());
    }

    public boolean hasUniqueNonEmptyValue(String string) {
        return this.generateStreamForKey(string).filter(tag -> !tag.getValue().isEmpty()).count() == 1L;
    }

    public boolean hasEmptyValue(String string) {
        return this.generateStreamForKey(string).anyMatch(tag -> tag.getValue().isEmpty());
    }

    public boolean hasUniqueEmptyValue(String string) {
        Set<String> set = this.getValues(string);
        return set.size() == 1 && set.contains("");
    }

    public TagCollection getTagsFor(String string) {
        TagCollection tagCollection = new TagCollection();
        this.generateStreamForKey(string).forEach(tagCollection::add);
        return tagCollection;
    }

    public TagCollection getTagsFor(Collection<String> collection) {
        TagCollection tagCollection = new TagCollection();
        if (collection == null) {
            return tagCollection;
        }
        for (String string : collection) {
            if (string == null) continue;
            tagCollection.add(this.getTagsFor(string));
        }
        return tagCollection;
    }

    public Set<Tag> asSet() {
        return new HashSet<Tag>(this.tags.keySet());
    }

    public List<Tag> asList() {
        return new ArrayList<Tag>(this.tags.keySet());
    }

    @Override
    public Iterator<Tag> iterator() {
        return this.tags.keySet().iterator();
    }

    public Set<String> getKeys() {
        return this.generateKeyStream().collect(Collectors.toCollection(HashSet::new));
    }

    public Set<String> getKeysWithMultipleValues() {
        HashSet hashSet = new HashSet();
        return this.generateKeyStream().filter(string -> !hashSet.add(string)).collect(Collectors.toSet());
    }

    public void setUniqueForKey(Tag tag) {
        if (tag == null) {
            return;
        }
        this.removeByKey(tag.getKey());
        this.add(tag);
    }

    public void setUniqueForKey(String string, String string2) {
        Tag tag = new Tag(string, string2);
        this.setUniqueForKey(tag);
    }

    public Set<String> getValues() {
        return this.tags.keySet().stream().map(Tag::getValue).collect(Collectors.toSet());
    }

    public Set<String> getValues(String string) {
        return this.generateStreamForKey(string).map(Tag::getValue).collect(Collectors.toSet());
    }

    public boolean isApplicableToPrimitive() {
        return this.getKeysWithMultipleValues().isEmpty();
    }

    public void applyTo(Tagged tagged) {
        if (tagged == null) {
            return;
        }
        this.ensureApplicableToPrimitive();
        for (Tag tag : this.tags.keySet()) {
            if (tag.getValue() == null || tag.getValue().isEmpty()) {
                tagged.remove(tag.getKey());
                continue;
            }
            tagged.put(tag.getKey(), tag.getValue());
        }
    }

    public void applyTo(Collection<? extends Tagged> collection) {
        if (collection == null) {
            return;
        }
        this.ensureApplicableToPrimitive();
        for (Tagged tagged : collection) {
            this.applyTo(tagged);
        }
    }

    public void replaceTagsOf(Tagged tagged) {
        if (tagged == null) {
            return;
        }
        this.ensureApplicableToPrimitive();
        tagged.removeAll();
        for (Tag tag : this.tags.keySet()) {
            tagged.put(tag.getKey(), tag.getValue());
        }
    }

    public void replaceTagsOf(Collection<? extends Tagged> collection) {
        if (collection == null) {
            return;
        }
        this.ensureApplicableToPrimitive();
        for (Tagged tagged : collection) {
            this.replaceTagsOf(tagged);
        }
    }

    private void ensureApplicableToPrimitive() {
        if (!this.isApplicableToPrimitive()) {
            throw new IllegalStateException(I18n.tr("Tag collection cannot be applied to a primitive because there are keys with multiple values.", new Object[0]));
        }
    }

    public TagCollection intersect(TagCollection tagCollection) {
        TagCollection tagCollection2 = new TagCollection();
        if (tagCollection != null) {
            this.tags.keySet().stream().filter(tagCollection::contains).forEach(tagCollection2::add);
        }
        return tagCollection2;
    }

    public TagCollection minus(TagCollection tagCollection) {
        TagCollection tagCollection2 = new TagCollection(this);
        if (tagCollection != null) {
            tagCollection2.remove(tagCollection);
        }
        return tagCollection2;
    }

    public TagCollection union(TagCollection tagCollection) {
        TagCollection tagCollection2 = new TagCollection(this);
        if (tagCollection != null) {
            tagCollection2.add(tagCollection);
        }
        return tagCollection2;
    }

    public TagCollection emptyTagsForKeysMissingIn(TagCollection tagCollection) {
        TagCollection tagCollection2 = new TagCollection();
        for (String string : this.minus(tagCollection).getKeys()) {
            tagCollection2.add(new Tag(string));
        }
        return tagCollection2;
    }

    public String getJoinedValues(String string) {
        Set<String> set = this.getValues(string);
        if (set.size() == 1) {
            return set.iterator().next();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        for (String object : set) {
            List<String> list = Arrays.asList(SPLIT_VALUES_PATTERN.split(object));
            linkedHashMap.put(object, list);
            linkedHashSet.addAll(list);
        }
        linkedHashSet.remove("");
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            if (!((Collection)entry.getValue()).containsAll(linkedHashSet)) continue;
            return (String)entry.getKey();
        }
        return Utils.join(";", linkedHashSet);
    }

    public String getSummedValues(String string) {
        int n = 0;
        for (String string2 : this.getValues(string)) {
            try {
                n += Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Logging.trace(numberFormatException);
            }
        }
        return Integer.toString(n);
    }

    private Stream<String> generateKeyStream() {
        return this.tags.keySet().stream().map(Tag::getKey);
    }

    private Stream<Tag> generateStreamForKey(String string) {
        return this.tags.keySet().stream().filter(tag -> tag.matchesKey(string));
    }

    public String toString() {
        return this.tags.toString();
    }
}

