/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.Graphics2D;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.visitor.paint.AbstractMapRenderer;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.data.osm.visitor.paint.WireframeMapRenderer;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public final class MapRendererFactory {
    public static final String PREF_KEY_RENDERER_CLASS_NAME = "mappaint.renderer-class-name";
    private static MapRendererFactory instance;
    private final List<Descriptor> descriptors = new ArrayList<Descriptor>();
    private Class<? extends AbstractMapRenderer> activeRenderer;

    public static synchronized MapRendererFactory getInstance() {
        if (instance == null) {
            instance = new MapRendererFactory();
        }
        return instance;
    }

    private static Class<?> loadRendererClass(String string) {
        for (ClassLoader classLoader : PluginHandler.getResourceClassLoaders()) {
            try {
                return Class.forName(string, true, classLoader);
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                Logging.trace(throwable);
            }
        }
        Logging.error(I18n.tr("Failed to load map renderer class ''{0}''. The class wasn''t found.", string));
        return null;
    }

    private MapRendererFactory() {
        this.registerDefaultRenderers();
        String string = Main.pref.get(PREF_KEY_RENDERER_CLASS_NAME, null);
        if (string != null) {
            this.activateMapRenderer(string);
        } else {
            this.activateDefault();
        }
    }

    private void activateMapRenderer(String string) {
        Class<?> clazz = MapRendererFactory.loadRendererClass(string);
        if (clazz == null) {
            Logging.error(I18n.tr("Can''t activate map renderer class ''{0}'', because the class wasn''t found.", string));
            Logging.error(I18n.tr("Activating the standard map renderer instead.", new Object[0]));
            this.activateDefault();
        } else if (!AbstractMapRenderer.class.isAssignableFrom(clazz)) {
            Logging.error(I18n.tr("Can''t activate map renderer class ''{0}'', because it isn''t a subclass of ''{1}''.", string, AbstractMapRenderer.class.getName()));
            Logging.error(I18n.tr("Activating the standard map renderer instead.", new Object[0]));
            this.activateDefault();
        } else {
            Class<AbstractMapRenderer> clazz2 = clazz.asSubclass(AbstractMapRenderer.class);
            if (!this.isRegistered(clazz2)) {
                Logging.error(I18n.tr("Can''t activate map renderer class ''{0}'', because it isn''t registered as map renderer.", string));
                Logging.error(I18n.tr("Activating the standard map renderer instead.", new Object[0]));
                this.activateDefault();
            } else {
                this.activate(clazz2);
            }
        }
    }

    private void registerDefaultRenderers() {
        this.register(WireframeMapRenderer.class, I18n.tr("Wireframe Map Renderer", new Object[0]), I18n.tr("Renders the map as simple wire frame.", new Object[0]));
        this.register(StyledMapRenderer.class, I18n.tr("Styled Map Renderer", new Object[0]), I18n.tr("Renders the map using style rules in a set of style sheets.", new Object[0]));
    }

    public boolean isRegistered(Class<? extends AbstractMapRenderer> clazz) {
        CheckParameterUtil.ensureParameterNotNull(clazz);
        for (Descriptor descriptor : this.descriptors) {
            if (!descriptor.getRenderer().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    public void register(Class<? extends AbstractMapRenderer> clazz, String string, String string2) {
        CheckParameterUtil.ensureParameterNotNull(clazz);
        if (this.isRegistered(clazz)) {
            throw new IllegalStateException(MessageFormat.format("Class ''{0}'' already registered a renderer", clazz.getName()));
        }
        Descriptor descriptor = new Descriptor(clazz, string, string2);
        this.descriptors.add(descriptor);
    }

    public void unregister(Class<? extends AbstractMapRenderer> clazz) {
        if (clazz == null) {
            return;
        }
        if (!this.isRegistered(clazz)) {
            return;
        }
        Iterator<Descriptor> iterator = this.descriptors.iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = iterator.next();
            if (!descriptor.getRenderer().equals(clazz)) continue;
            iterator.remove();
            break;
        }
        if (this.activeRenderer != null && this.activeRenderer.equals(clazz)) {
            this.activateDefault();
        }
    }

    public void activate(Class<? extends AbstractMapRenderer> clazz) {
        CheckParameterUtil.ensureParameterNotNull(clazz);
        if (!this.isRegistered(clazz)) {
            throw new IllegalStateException(MessageFormat.format("Class ''{0}'' not registered as renderer. Can''t activate it.", clazz.getName()));
        }
        this.activeRenderer = clazz;
        Main.pref.put(PREF_KEY_RENDERER_CLASS_NAME, this.activeRenderer.getName());
    }

    public void activateDefault() {
        Class<StyledMapRenderer> clazz = StyledMapRenderer.class;
        if (!this.isRegistered(clazz)) {
            throw new IllegalStateException(MessageFormat.format("Class ''{0}'' not registered as renderer. Can''t activate default renderer.", clazz.getName()));
        }
        this.activate(clazz);
    }

    public AbstractMapRenderer createActiveRenderer(Graphics2D graphics2D, NavigatableComponent navigatableComponent, boolean bl) {
        try {
            Constructor<? extends AbstractMapRenderer> constructor = this.activeRenderer.getConstructor(Graphics2D.class, NavigatableComponent.class, Boolean.TYPE);
            return (AbstractMapRenderer)AbstractMapRenderer.class.cast(constructor.newInstance(graphics2D, navigatableComponent, bl));
        }
        catch (InvocationTargetException invocationTargetException) {
            Logging.debug(invocationTargetException);
            throw new MapRendererFactoryException(invocationTargetException.getCause());
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            throw new MapRendererFactoryException(exception);
        }
    }

    public List<Descriptor> getMapRendererDescriptors() {
        return Collections.unmodifiableList(this.descriptors);
    }

    public boolean isWireframeMapRendererActive() {
        return WireframeMapRenderer.class.equals(this.activeRenderer);
    }

    public static class Descriptor {
        private final Class<? extends AbstractMapRenderer> renderer;
        private final String displayName;
        private final String description;

        public Descriptor(Class<? extends AbstractMapRenderer> clazz, String string, String string2) {
            this.renderer = clazz;
            this.displayName = string;
            this.description = string2;
        }

        public Class<? extends AbstractMapRenderer> getRenderer() {
            return this.renderer;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class MapRendererFactoryException
    extends RuntimeException {
        public MapRendererFactoryException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public MapRendererFactoryException(String string) {
            super(string);
        }

        public MapRendererFactoryException(Throwable throwable) {
            super(throwable);
        }
    }
}

