/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.io.PrintStream;
import java.util.List;
import java.util.function.Supplier;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class RenderBenchmarkCollector {
    public void renderStart(double d) {
    }

    public boolean renderSort() {
        return true;
    }

    public boolean renderDraw(List<StyledMapRenderer.StyleRecord> list) {
        return true;
    }

    public void renderDone() {
    }

    public static Supplier<RenderBenchmarkCollector> defaultBenchmarkSupplier() {
        return () -> Logging.isTraceEnabled() || Main.pref.getBoolean("mappaint.render.benchmark", false) ? new LoggingBenchmark() : new RenderBenchmarkCollector();
    }

    public static class LoggingBenchmark
    extends CapturingBenchmark {
        private final PrintStream outStream = System.err;
        private double circum;

        @Override
        public void renderStart(double d) {
            this.circum = d;
            super.renderStart(d);
            this.outStream.print("BENCHMARK: rendering ");
        }

        @Override
        public boolean renderDraw(List<StyledMapRenderer.StyleRecord> list) {
            boolean bl = super.renderDraw(list);
            this.outStream.print("phase 1 (calculate styles): " + Utils.getDurationString(this.timeSortingDone - this.timeStart));
            return bl;
        }

        @Override
        public void renderDone() {
            super.renderDone();
            this.outStream.println("; phase 2 (draw): " + Utils.getDurationString(this.timeFinished - this.timeGenerateDone) + "; total: " + Utils.getDurationString(this.timeFinished - this.timeStart) + " (scale: " + this.circum + " zoom level: " + Selector.GeneralSelector.scale2level(this.circum) + ')');
        }
    }

    public static class CapturingBenchmark
    extends RenderBenchmarkCollector {
        protected long timeStart;
        protected long timeGenerateDone;
        protected long timeSortingDone;
        protected long timeFinished;

        @Override
        public void renderStart(double d) {
            this.timeStart = System.currentTimeMillis();
            super.renderStart(d);
        }

        @Override
        public boolean renderSort() {
            this.timeGenerateDone = System.currentTimeMillis();
            return super.renderSort();
        }

        @Override
        public boolean renderDraw(List<StyledMapRenderer.StyleRecord> list) {
            this.timeSortingDone = System.currentTimeMillis();
            return super.renderDraw(list);
        }

        public long getGenerateTime() {
            return this.timeGenerateDone - this.timeStart;
        }

        public long getSortTime() {
            return this.timeSortingDone - this.timeGenerateDone;
        }

        @Override
        public void renderDone() {
            this.timeFinished = System.currentTimeMillis();
            super.renderDone();
        }

        public long getDrawTime() {
            return this.timeFinished - this.timeGenerateDone;
        }
    }
}

