/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.OpenLocationAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OsmUrlToBounds;

public enum DownloadParamType {
    httpUrl{

        @Override
        public List<Future<?>> download(String string, Collection<File> collection) {
            return new OpenLocationAction().openUrl(false, string);
        }

        @Override
        public List<Future<?>> downloadGps(String string) {
            Bounds bounds = OsmUrlToBounds.parse(string);
            if (bounds == null) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Ignoring malformed URL: \"{0}\"", string), I18n.tr("Warning", new Object[0]), 2);
                return Collections.emptyList();
            }
            return MainApplication.downloadFromParamBounds(true, bounds);
        }
    }
    ,
    fileUrl{

        @Override
        public List<Future<?>> download(String string, Collection<File> collection) {
            File file = null;
            try {
                file = new File(new URI(string));
            }
            catch (URISyntaxException uRISyntaxException) {
                Logging.warn(uRISyntaxException);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Ignoring malformed file URL: \"{0}\"", string), I18n.tr("Warning", new Object[0]), 2);
            }
            if (file != null) {
                collection.add(file);
            }
            return Collections.emptyList();
        }
    }
    ,
    bounds{

        private List<Future<?>> downloadFromParamBounds(boolean bl, String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            if (stringTokenizer.countTokens() == 4) {
                return MainApplication.downloadFromParamBounds(bl, new Bounds(new LatLon(Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken())), new LatLon(Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken()))));
            }
            return Collections.emptyList();
        }

        @Override
        public List<Future<?>> download(String string, Collection<File> collection) {
            return this.downloadFromParamBounds(false, string);
        }

        @Override
        public List<Future<?>> downloadGps(String string) {
            return this.downloadFromParamBounds(true, string);
        }
    }
    ,
    fileName{

        @Override
        public List<Future<?>> download(String string, Collection<File> collection) {
            collection.add(new File(string));
            return Collections.emptyList();
        }
    };


    public abstract List<Future<?>> download(String var1, Collection<File> var2);

    public List<Future<?>> downloadGps(String string) {
        if (!GraphicsEnvironment.isHeadless()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Parameter \"downloadgps\" does not accept file names or file URLs", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
        }
        return Collections.emptyList();
    }

    public static DownloadParamType paramType(String string) {
        if (string.startsWith("http:") || string.startsWith("https:")) {
            return httpUrl;
        }
        if (string.startsWith("file:")) {
            return fileUrl;
        }
        String string2 = "\\s*[+-]?[0-9]+(\\.[0-9]+)?\\s*";
        if (string.matches(string2 + "(," + string2 + "){3}")) {
            return bounds;
        }
        return fileName;
    }
}

