/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadNotesTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.download.AbstractDownloadSourcePanel;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSettings;
import org.openstreetmap.josm.gui.download.DownloadSource;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;

public class OSMDownloadSource
implements DownloadSource<OSMDownloadData> {
    public static final String SIMPLE_NAME = "osmdownloadpanel";

    @Override
    public AbstractDownloadSourcePanel<OSMDownloadData> createPanel() {
        return new OSMDownloadSourcePanel(this);
    }

    @Override
    public void doDownload(OSMDownloadData oSMDownloadData, DownloadSettings downloadSettings) {
        Future<?> future;
        AbstractDownloadTask abstractDownloadTask;
        Bounds bounds = downloadSettings.getDownloadBounds().orElseThrow(() -> new IllegalArgumentException("OSM downloads requires bounds"));
        boolean bl = downloadSettings.zoomToData();
        boolean bl2 = downloadSettings.asNewLayer();
        ArrayList arrayList = new ArrayList();
        if (oSMDownloadData.isDownloadOSMData()) {
            abstractDownloadTask = new DownloadOsmTask();
            abstractDownloadTask.setZoomAfterDownload(bl && !oSMDownloadData.isDownloadGPX() && !oSMDownloadData.isDownloadNotes());
            future = ((DownloadOsmTask)abstractDownloadTask).download(bl2, bounds, null);
            MainApplication.worker.submit(new PostDownloadHandler(abstractDownloadTask, future));
            if (bl) {
                arrayList.add(new Pair(abstractDownloadTask, future));
            }
        }
        if (oSMDownloadData.isDownloadGPX()) {
            abstractDownloadTask = new DownloadGpsTask();
            abstractDownloadTask.setZoomAfterDownload(bl && !oSMDownloadData.isDownloadOSMData() && !oSMDownloadData.isDownloadNotes());
            future = ((DownloadGpsTask)abstractDownloadTask).download(bl2, bounds, null);
            MainApplication.worker.submit(new PostDownloadHandler(abstractDownloadTask, future));
            if (bl) {
                arrayList.add(new Pair(abstractDownloadTask, future));
            }
        }
        if (oSMDownloadData.isDownloadNotes()) {
            abstractDownloadTask = new DownloadNotesTask();
            abstractDownloadTask.setZoomAfterDownload(bl && !oSMDownloadData.isDownloadOSMData() && !oSMDownloadData.isDownloadGPX());
            future = ((DownloadNotesTask)abstractDownloadTask).download(false, bounds, null);
            MainApplication.worker.submit(new PostDownloadHandler(abstractDownloadTask, future));
            if (bl) {
                arrayList.add(new Pair(abstractDownloadTask, future));
            }
        }
        if (bl && arrayList.size() > 1) {
            MainApplication.worker.submit(() -> {
                ProjectionBounds projectionBounds = null;
                for (Pair pair : arrayList) {
                    try {
                        ((Future)pair.b).get();
                        ProjectionBounds projectionBounds2 = ((AbstractDownloadTask)pair.a).getDownloadProjectionBounds();
                        if (projectionBounds == null) {
                            projectionBounds = projectionBounds2;
                            continue;
                        }
                        if (projectionBounds2 == null) continue;
                        projectionBounds.extend(projectionBounds2);
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        Logging.warn(exception);
                    }
                }
                MapFrame mapFrame = MainApplication.getMap();
                if (mapFrame != null && projectionBounds != null) {
                    Pair pair;
                    pair = projectionBounds;
                    GuiHelper.runInEDTAndWait(() -> OSMDownloadSource.lambda$null$1(mapFrame, (ProjectionBounds)((Object)pair)));
                }
            });
        }
    }

    @Override
    public String getLabel() {
        return I18n.tr("Download from OSM", new Object[0]);
    }

    @Override
    public boolean onlyExpert() {
        return false;
    }

    private static /* synthetic */ void lambda$null$1(MapFrame mapFrame, ProjectionBounds projectionBounds) {
        mapFrame.mapView.zoomTo(new ViewportData(projectionBounds));
    }

    static class OSMDownloadData {
        private final boolean downloadOSMData;
        private final boolean downloadNotes;
        private final boolean downloadGPX;

        OSMDownloadData(boolean bl, boolean bl2, boolean bl3) {
            this.downloadOSMData = bl;
            this.downloadNotes = bl2;
            this.downloadGPX = bl3;
        }

        boolean isDownloadOSMData() {
            return this.downloadOSMData;
        }

        boolean isDownloadNotes() {
            return this.downloadNotes;
        }

        boolean isDownloadGPX() {
            return this.downloadGPX;
        }
    }

    public static class OSMDownloadSourcePanel
    extends AbstractDownloadSourcePanel<OSMDownloadData> {
        private final JCheckBox cbDownloadOsmData;
        private final JCheckBox cbDownloadGpxData;
        private final JCheckBox cbDownloadNotes;
        private final JLabel sizeCheck = new JLabel();
        private static final BooleanProperty DOWNLOAD_OSM = new BooleanProperty("download.osm.data", true);
        private static final BooleanProperty DOWNLOAD_GPS = new BooleanProperty("download.osm.gps", false);
        private static final BooleanProperty DOWNLOAD_NOTES = new BooleanProperty("download.osm.notes", false);

        public OSMDownloadSourcePanel(OSMDownloadSource oSMDownloadSource) {
            super(oSMDownloadSource);
            this.setLayout(new GridBagLayout());
            ChangeListener changeListener = changeEvent -> DownloadDialog.getInstance().getSelectedDownloadArea().ifPresent(this::updateSizeCheck);
            this.add((Component)new JLabel(I18n.tr("Data Sources and Types:", new Object[0])), GBC.std().insets(5, 5, 1, 5).anchor(10));
            this.cbDownloadOsmData = new JCheckBox(I18n.tr("OpenStreetMap data", new Object[0]), true);
            this.cbDownloadOsmData.setToolTipText(I18n.tr("Select to download OSM data in the selected download area.", new Object[0]));
            this.cbDownloadOsmData.getModel().addChangeListener(changeListener);
            this.cbDownloadGpxData = new JCheckBox(I18n.tr("Raw GPS data", new Object[0]));
            this.cbDownloadGpxData.setToolTipText(I18n.tr("Select to download GPS traces in the selected download area.", new Object[0]));
            this.cbDownloadGpxData.getModel().addChangeListener(changeListener);
            this.cbDownloadNotes = new JCheckBox(I18n.tr("Notes", new Object[0]));
            this.cbDownloadNotes.setToolTipText(I18n.tr("Select to download notes in the selected download area.", new Object[0]));
            this.cbDownloadNotes.getModel().addChangeListener(changeListener);
            Font font = this.sizeCheck.getFont();
            this.sizeCheck.setFont(font.deriveFont(0, font.getSize()));
            this.add((Component)this.cbDownloadOsmData, GBC.std().insets(1, 5, 1, 5));
            this.add((Component)this.cbDownloadGpxData, GBC.std().insets(1, 5, 1, 5));
            this.add((Component)this.cbDownloadNotes, GBC.eol().insets(1, 5, 1, 5));
            this.add((Component)this.sizeCheck, GBC.eol().anchor(13).insets(5, 5, 5, 2));
            this.setMinimumSize(new Dimension(450, 115));
        }

        @Override
        public OSMDownloadData getData() {
            return new OSMDownloadData(this.isDownloadOsmData(), this.isDownloadNotes(), this.isDownloadGpxData());
        }

        @Override
        public void rememberSettings() {
            DOWNLOAD_OSM.put(this.isDownloadOsmData());
            DOWNLOAD_GPS.put(this.isDownloadGpxData());
            DOWNLOAD_NOTES.put(this.isDownloadNotes());
        }

        @Override
        public void restoreSettings() {
            this.cbDownloadOsmData.setSelected(DOWNLOAD_OSM.get());
            this.cbDownloadGpxData.setSelected(DOWNLOAD_GPS.get());
            this.cbDownloadNotes.setSelected(DOWNLOAD_NOTES.get());
        }

        @Override
        public boolean checkDownload(DownloadSettings downloadSettings) {
            if (!downloadSettings.getDownloadBounds().isPresent()) {
                JOptionPane.showMessageDialog(this.getParent(), I18n.tr("Please select a download area first.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
                return false;
            }
            if (!(this.isDownloadOsmData() || this.isDownloadGpxData() || this.isDownloadNotes())) {
                JOptionPane.showMessageDialog(this.getParent(), I18n.tr("<html>Neither <strong>{0}</strong> nor <strong>{1}</strong> nor <strong>{2}</strong> is enabled.<br>Please choose to either download OSM data, or GPX data, or Notes, or all.</html>", this.cbDownloadOsmData.getText(), this.cbDownloadGpxData.getText(), this.cbDownloadNotes.getText()), I18n.tr("Error", new Object[0]), 0);
                return false;
            }
            this.rememberSettings();
            return true;
        }

        public boolean isDownloadOsmData() {
            return this.cbDownloadOsmData.isSelected();
        }

        public boolean isDownloadGpxData() {
            return this.cbDownloadGpxData.isSelected();
        }

        public boolean isDownloadNotes() {
            return this.cbDownloadNotes.isSelected();
        }

        @Override
        public Icon getIcon() {
            return ImageProvider.get("download");
        }

        @Override
        public void boudingBoxChanged(Bounds bounds) {
            this.updateSizeCheck(bounds);
        }

        @Override
        public String getSimpleName() {
            return OSMDownloadSource.SIMPLE_NAME;
        }

        private void updateSizeCheck(Bounds bounds) {
            if (bounds == null) {
                this.sizeCheck.setText(I18n.tr("No area selected yet", new Object[0]));
                this.sizeCheck.setForeground(Color.darkGray);
                return;
            }
            boolean bl = false;
            bl = !this.isDownloadNotes() && !this.isDownloadOsmData() && !this.isDownloadGpxData() ? false : (this.isDownloadNotes() && !this.isDownloadOsmData() && !this.isDownloadGpxData() ? bounds.getArea() > Main.pref.getDouble("osm-server.max-request-area-notes", 25.0) : bounds.getArea() > Main.pref.getDouble("osm-server.max-request-area", 0.25));
            this.displaySizeCheckResult(bl);
        }

        private void displaySizeCheckResult(boolean bl) {
            if (bl) {
                this.sizeCheck.setText(I18n.tr("Download area too large; will probably be rejected by server", new Object[0]));
                this.sizeCheck.setForeground(Color.red);
            } else {
                this.sizeCheck.setText(I18n.tr("Download area ok, size probably acceptable to server", new Object[0]));
                this.sizeCheck.setForeground(Color.darkGray);
            }
        }
    }
}

