/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.DefaultTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.gui.widgets.SearchTextResultListPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class OverpassQueryList
extends SearchTextResultListPanel<SelectorItem> {
    private static final DateTimeFormatter FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss, dd-MM-yyyy");
    private final JTextComponent target;
    private final Component componentParent;
    private final transient Map<String, SelectorItem> items;
    private static final String KEY_KEY = "key";
    private static final String QUERY_KEY = "query";
    private static final String LAST_EDIT_KEY = "lastEdit";
    private static final String PREFERENCE_ITEMS = "download.overpass.query";
    private static final String TRANSLATED_HISTORY = I18n.tr("history", new Object[0]);

    public OverpassQueryList(Component component, JTextComponent jTextComponent) {
        this.target = jTextComponent;
        this.componentParent = component;
        this.items = OverpassQueryList.restorePreferences();
        OverpassQueryListMouseAdapter overpassQueryListMouseAdapter = new OverpassQueryListMouseAdapter(this.lsResult, this.lsResultModel);
        this.lsResult.setCellRenderer(new OverpassQueryCellRendered());
        super.setDblClickListener(actionEvent -> this.doubleClickEvent());
        this.lsResult.addMouseListener(overpassQueryListMouseAdapter);
        this.lsResult.addMouseMotionListener(overpassQueryListMouseAdapter);
        this.filterItems();
    }

    public synchronized Optional<SelectorItem> getSelectedItem() {
        int n = this.lsResult.getSelectedIndex();
        if (this.lsResultModel.getSize() <= n || n == -1) {
            return Optional.empty();
        }
        SelectorItem selectorItem = (SelectorItem)this.lsResultModel.getElementAt(n);
        this.filterItems();
        return Optional.of(selectorItem);
    }

    public synchronized void saveHistoricItem(String string) {
        boolean bl = this.items.values().stream().map(SelectorItem::getQuery).anyMatch(string2 -> string2.equals(string));
        if (!bl) {
            SelectorItem selectorItem = new SelectorItem(TRANSLATED_HISTORY + " " + LocalDateTime.now().format(FORMAT), string);
            this.items.put(selectorItem.getKey(), selectorItem);
            this.savePreferences();
            this.filterItems();
        }
    }

    public synchronized void removeSelectedItem() {
        Optional<SelectorItem> optional = this.getSelectedItem();
        if (!optional.isPresent()) {
            JOptionPane.showMessageDialog(this.componentParent, I18n.tr("Please select an item first", new Object[0]));
            return;
        }
        SelectorItem selectorItem = optional.get();
        if (this.items.remove(selectorItem.getKey(), selectorItem)) {
            this.clearSelection();
            this.savePreferences();
            this.filterItems();
        }
    }

    public synchronized void editSelectedItem() {
        Optional<SelectorItem> optional = this.getSelectedItem();
        if (!optional.isPresent()) {
            JOptionPane.showMessageDialog(this.componentParent, I18n.tr("Please select an item first", new Object[0]));
            return;
        }
        SelectorItem selectorItem = optional.get();
        EditItemDialog editItemDialog = new EditItemDialog(this.componentParent, I18n.tr("Edit item", new Object[0]), selectorItem, I18n.tr("Save", new Object[0]), I18n.tr("Cancel", new Object[0]));
        editItemDialog.showDialog();
        Optional<SelectorItem> optional2 = editItemDialog.getOutputItem();
        optional2.ifPresent(selectorItem2 -> {
            this.items.remove(selectorItem.getKey(), selectorItem);
            this.items.put(selectorItem2.getKey(), (SelectorItem)selectorItem2);
            this.savePreferences();
            this.filterItems();
        });
    }

    public synchronized void createNewItem() {
        EditItemDialog editItemDialog = new EditItemDialog(this.componentParent, I18n.tr("Add snippet", new Object[0]), I18n.tr("Add", new Object[0]));
        editItemDialog.showDialog();
        Optional<SelectorItem> optional = editItemDialog.getOutputItem();
        optional.ifPresent(selectorItem -> {
            this.items.put(selectorItem.getKey(), (SelectorItem)selectorItem);
            this.savePreferences();
            this.filterItems();
        });
    }

    @Override
    public void setDblClickListener(ActionListener actionListener) {
    }

    @Override
    protected void filterItems() {
        String string = this.edSearchText.getText().toLowerCase(Locale.ENGLISH);
        List list = this.items.values().stream().sorted((selectorItem, selectorItem2) -> selectorItem2.getLastEdit().compareTo(selectorItem.getLastEdit())).filter(selectorItem -> selectorItem.getKey().contains(string)).collect(Collectors.toList());
        this.lsResultModel.setItems(list);
    }

    private void doubleClickEvent() {
        Optional<SelectorItem> optional = this.getSelectedItem();
        if (!optional.isPresent()) {
            return;
        }
        SelectorItem selectorItem = optional.get();
        this.target.setText(selectorItem.getQuery());
    }

    private void savePreferences() {
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>(this.items.size());
        for (SelectorItem selectorItem : this.items.values()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(KEY_KEY, selectorItem.getKey());
            hashMap.put(QUERY_KEY, selectorItem.getQuery());
            hashMap.put(LAST_EDIT_KEY, selectorItem.getLastEdit().format(FORMAT));
            arrayList.add(hashMap);
        }
        Main.pref.putListOfStructs(PREFERENCE_ITEMS, arrayList);
    }

    private static Map<String, SelectorItem> restorePreferences() {
        Collection<Map<String, String>> collection = Main.pref.getListOfStructs(PREFERENCE_ITEMS, Collections.emptyList());
        HashMap<String, SelectorItem> hashMap = new HashMap<String, SelectorItem>();
        for (Map<String, String> map : collection) {
            try {
                String string = map.get(KEY_KEY);
                String string2 = map.get(QUERY_KEY);
                String string3 = map.get(LAST_EDIT_KEY);
                LocalDateTime localDateTime = string3 == null ? LocalDateTime.MIN : LocalDateTime.parse(string3, FORMAT);
                hashMap.put(string, new SelectorItem(string, string2, localDateTime));
            }
            catch (IllegalArgumentException | DateTimeParseException runtimeException) {
                Logging.error(runtimeException);
            }
        }
        return hashMap;
    }

    public static class SelectorItem {
        private final String itemKey;
        private final String query;
        private final LocalDateTime lastEdit;

        public SelectorItem(String string, String string2) {
            this(string, string2, LocalDateTime.now());
        }

        public SelectorItem(String string, String string2, LocalDateTime localDateTime) {
            Objects.requireNonNull(string, "The name of the item cannot be null");
            Objects.requireNonNull(string2, "The query of the item cannot be null");
            Objects.requireNonNull(localDateTime, "The last edit date time cannot be null");
            if (Utils.isStripEmpty(string)) {
                throw new IllegalArgumentException("The key of the item cannot be empty");
            }
            if (Utils.isStripEmpty(string2)) {
                throw new IllegalArgumentException("The query cannot be empty");
            }
            this.itemKey = string;
            this.query = string2;
            this.lastEdit = localDateTime;
        }

        public String getKey() {
            return this.itemKey;
        }

        public String getQuery() {
            return this.query;
        }

        public LocalDateTime getLastEdit() {
            return this.lastEdit;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.itemKey == null ? 0 : this.itemKey.hashCode());
            n = 31 * n + (this.query == null ? 0 : this.query.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            SelectorItem selectorItem = (SelectorItem)object;
            if (this.itemKey == null ? selectorItem.itemKey != null : !this.itemKey.equals(selectorItem.itemKey)) {
                return false;
            }
            return !(this.query == null ? selectorItem.query != null : !this.query.equals(selectorItem.query));
        }
    }

    private final class EditItemDialog
    extends ExtendedDialog {
        private final JTextField name;
        private final JosmTextArea query;
        private final transient AbstractTextComponentValidator queryValidator;
        private final transient AbstractTextComponentValidator nameValidator;
        private static final int SUCCESS_BTN = 0;
        private static final int CANCEL_BTN = 1;
        private final transient SelectorItem itemToEdit;
        private transient Optional<SelectorItem> outputItem;

        EditItemDialog(Component component, String string, String ... stringArray) {
            this(component, string, (SelectorItem)null, stringArray);
        }

        EditItemDialog(Component component, String string, SelectorItem selectorItem, String ... stringArray) {
            super(component, string, stringArray);
            this.outputItem = Optional.empty();
            this.itemToEdit = selectorItem;
            final String string2 = selectorItem == null ? "" : selectorItem.getKey();
            String string3 = selectorItem == null ? "" : selectorItem.getQuery();
            this.name = new JTextField(string2);
            this.query = new JosmTextArea(string3);
            this.queryValidator = new DefaultTextComponentValidator(this.query, "", I18n.tr("Query cannot be empty", new Object[0]));
            this.nameValidator = new AbstractTextComponentValidator(this.name){

                @Override
                public void validate() {
                    if (this.isValid()) {
                        this.feedbackValid(I18n.tr("This name can be used for the item", new Object[0]));
                    } else {
                        this.feedbackInvalid(I18n.tr("Item with this name already exists", new Object[0]));
                    }
                }

                @Override
                public boolean isValid() {
                    String string = EditItemDialog.this.name.getText();
                    boolean bl = !Utils.isStripEmpty(string);
                    boolean bl2 = !string.equals(string2) && OverpassQueryList.this.items.containsKey(string);
                    return bl && !bl2;
                }
            };
            this.name.getDocument().addDocumentListener(this.nameValidator);
            this.query.getDocument().addDocumentListener(this.queryValidator);
            JPanel jPanel = new JPanel(new GridBagLayout());
            JScrollPane jScrollPane = GuiHelper.embedInVerticalScrollPane(this.query);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
            GBC gBC = GBC.eol().insets(8, 0, 8, 8).anchor(10).fill(2);
            gBC.ipady = 250;
            jPanel.add((Component)this.name, GBC.eol().insets(5).anchor(14).fill(2));
            jPanel.add((Component)jScrollPane, gBC);
            this.setDefaultButton(1);
            this.setCancelButton(2);
            this.setPreferredSize(new Dimension(400, 400));
            this.setContent(jPanel, false);
        }

        public Optional<SelectorItem> getOutputItem() {
            return this.outputItem;
        }

        @Override
        protected void buttonAction(int n, ActionEvent actionEvent) {
            if (n == 0) {
                if (!this.nameValidator.isValid()) {
                    JOptionPane.showMessageDialog(OverpassQueryList.this.componentParent, I18n.tr("The item cannot be created with provided name", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                    return;
                }
                if (!this.queryValidator.isValid()) {
                    JOptionPane.showMessageDialog(OverpassQueryList.this.componentParent, I18n.tr("The item cannot be created with an empty query", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                    return;
                }
                if (this.itemToEdit != null) {
                    String string = this.name.getText();
                    String string2 = this.query.getText();
                    String string3 = this.itemToEdit.getKey();
                    String string4 = this.itemToEdit.getQuery();
                    this.outputItem = Optional.of(new SelectorItem(this.name.getText(), this.query.getText(), !string.equals(string3) || !string2.equals(string4) ? LocalDateTime.now() : this.itemToEdit.getLastEdit()));
                } else {
                    this.outputItem = Optional.of(new SelectorItem(this.name.getText(), this.query.getText()));
                }
            }
            super.buttonAction(n, actionEvent);
        }
    }

    private static class OverpassQueryCellRendered
    extends JLabel
    implements ListCellRenderer<SelectorItem> {
        OverpassQueryCellRendered() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends SelectorItem> jList, SelectorItem selectorItem, int n, boolean bl, boolean bl2) {
            Font font = jList.getFont();
            if (bl) {
                this.setFont(new Font(font.getFontName(), 1, font.getSize() + 2));
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setFont(new Font(font.getFontName(), 0, font.getSize() + 2));
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setText(selectorItem.getKey());
            if (bl && bl2) {
                this.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 1), BorderFactory.createEmptyBorder(2, 0, 2, 0)));
            } else {
                this.setBorder(new CompoundBorder(null, BorderFactory.createEmptyBorder(2, 0, 2, 0)));
            }
            return this;
        }
    }

    private class OverpassQueryListMouseAdapter
    extends MouseAdapter {
        private final JList<SelectorItem> list;
        private final SearchTextResultListPanel.ResultListModel<SelectorItem> model;
        private final JPopupMenu emptySelectionPopup = new JPopupMenu();
        private final JPopupMenu elementPopup = new JPopupMenu();

        OverpassQueryListMouseAdapter(JList<SelectorItem> jList, SearchTextResultListPanel.ResultListModel<SelectorItem> resultListModel) {
            this.list = jList;
            this.model = resultListModel;
            this.initPopupMenus();
        }

        private int locationToIndex(Point point) {
            int n = this.list.locationToIndex(point);
            if (n != -1 && !this.list.getCellBounds(n, n).contains(point)) {
                return -1;
            }
            return n;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            super.mouseClicked(mouseEvent);
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                int n = this.locationToIndex(mouseEvent.getPoint());
                if (this.model.getSize() == 0 || n == -1) {
                    this.list.clearSelection();
                    this.emptySelectionPopup.show(this.list, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    this.list.setSelectedIndex(n);
                    this.list.ensureIndexIsVisible(n);
                    this.elementPopup.show(this.list, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            int n = this.locationToIndex(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            SelectorItem selectorItem = this.model.getElementAt(n);
            this.list.setToolTipText("<html><pre style='width:300px;'>" + Utils.escapeReservedCharactersHTML(Utils.restrictStringLines(selectorItem.getQuery(), 9)));
        }

        private void initPopupMenus() {
            AbstractAction abstractAction = new AbstractAction(I18n.tr("Add", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OverpassQueryList.this.createNewItem();
                }
            };
            AbstractAction abstractAction2 = new AbstractAction(I18n.tr("Edit", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OverpassQueryList.this.editSelectedItem();
                }
            };
            AbstractAction abstractAction3 = new AbstractAction(I18n.tr("Remove", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OverpassQueryList.this.removeSelectedItem();
                }
            };
            this.emptySelectionPopup.add(abstractAction);
            this.elementPopup.add(abstractAction);
            this.elementPopup.add(abstractAction2);
            this.elementPopup.add(abstractAction3);
        }
    }
}

